package com.elitesland.fin.repo.adjusttoorder;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.facade.dto.adjusttoorder.AdjustToOrderDTO;
import com.elitesland.fin.application.facade.param.adjusttoorder.AdjustToOrderParam;
import com.elitesland.fin.application.facade.vo.adjusttoorder.AdjustToOrderVO;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.adjusttoorder.AdjustToOrderDO;
import com.elitesland.fin.entity.adjusttoorder.QAdjustToOrderDO;
import com.elitesland.fin.utils.StringUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author zhiyu.he
 * @date 2023/3/3 16:28
 */
@Component
@RequiredArgsConstructor
public class AdjustToOrderRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QAdjustToOrderDO qAdjustToOrderDO = QAdjustToOrderDO.adjustToOrderDO;
    private final AdjustToOrderRepo adjustToOrderRepo;
    private final UdcProvider udcProvider;

    public PagingVO<AdjustToOrderDTO> page(AdjustToOrderParam adjustOrderPageParam) {
        Predicate where = where(adjustOrderPageParam);
        JPAQuery<AdjustToOrderDTO> query = select(AdjustToOrderDTO.class).where(ExpressionUtils.allOf(where));
        adjustOrderPageParam.setPaging(query);
        adjustOrderPageParam.fillOrders(query, qAdjustToOrderDO);

        long count = query.fetchCount();
        List<AdjustToOrderDTO> adjustToOrderDTOList = query.fetch();

        Map<String, String> accountTypeUdc = udcProvider.getValueMapByUdcCode(UdcEnum.ACCOUNT_TYPE_STORE.getModel(), UdcEnum.ACCOUNT_TYPE_STORE.getCode());
        Map<String, String> creditAccountTypeUdc = udcProvider.getValueMapByUdcCode(UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getModel(), UdcEnum.CREDIT_ACCOUNT_TYPE_CREDIT.getCode());

        adjustToOrderDTOList.stream().forEach(item -> {
            String type = item.getAccountTypeTo();
            if (accountTypeUdc.get(type) != null) {
                item.setAccountTypeToName(accountTypeUdc.get(type));
                return;
            }
            item.setAccountTypeToName(creditAccountTypeUdc.get(type));
        });

        return PagingVO.<AdjustToOrderDTO>builder()
                .total(count)
                .records(adjustToOrderDTOList)
                .build();
    }

    public List<AdjustToOrderVO> queryByIds(List<Long> id) {
        return select(AdjustToOrderVO.class)
                .where(qAdjustToOrderDO.id.in(id))
                .fetch();
    }

    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO) {
        jpaQueryFactory.update(qAdjustToOrderDO)
                .set(qAdjustToOrderDO.docState, status)
                .set(qAdjustToOrderDO.auditTime, LocalDateTime.now())
                .set(qAdjustToOrderDO.auditUser, sysUserDTO.getUsername())
                .set(qAdjustToOrderDO.auditUserId, sysUserDTO.getId())
                .where(qAdjustToOrderDO.id.in(ids))
                .execute();
    }

    public void updateReject(List<Long> ids, String status, SysUserDTO sysUserDTO, String reason) {
        jpaQueryFactory.update(qAdjustToOrderDO)
                .set(qAdjustToOrderDO.docState, status)
                .set(qAdjustToOrderDO.auditTime, LocalDateTime.now())
                .set(qAdjustToOrderDO.auditUser, sysUserDTO.getUsername())
                .set(qAdjustToOrderDO.auditUserId, sysUserDTO.getId())
                .set(qAdjustToOrderDO.auditRejectReason, reason)
                .where(qAdjustToOrderDO.id.in(ids))
                .execute();
    }

    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO, String reason) {
        jpaQueryFactory.update(qAdjustToOrderDO)
                .set(qAdjustToOrderDO.docState, status)
                .set(qAdjustToOrderDO.auditTime, LocalDateTime.now())
                .set(qAdjustToOrderDO.auditUser, sysUserDTO.getUsername())
                .set(qAdjustToOrderDO.auditUserId, sysUserDTO.getId())
                .set(qAdjustToOrderDO.auditRejectReason, reason)
                .where(qAdjustToOrderDO.id.in(ids))
                .execute();
    }

    public AdjustToOrderVO queryById(Long id) {
        return select(AdjustToOrderVO.class)
                .where(qAdjustToOrderDO.id.eq(id))
                .fetchOne();
    }


    private Predicate where(AdjustToOrderParam adjustToOrderParam) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andEq(adjustToOrderParam.getId() != null, qAdjustToOrderDO.id, adjustToOrderParam.getId())
                .andLike(StringUtils.isNotEmpty(adjustToOrderParam.getDocNo()), qAdjustToOrderDO.docNo, StringUtil.buildLikeString(adjustToOrderParam.getDocNo()))
                .andEq(StringUtils.isNotEmpty(adjustToOrderParam.getDocState()), qAdjustToOrderDO.docState, adjustToOrderParam.getDocState())
                .andEq(StringUtils.isNotEmpty(adjustToOrderParam.getAccountTypeFrom()), qAdjustToOrderDO.accountTypeFrom, adjustToOrderParam.getAccountTypeFrom())
                .andEq(StringUtils.isNotEmpty(adjustToOrderParam.getAccountTypeTo()), qAdjustToOrderDO.accountTypeTo, adjustToOrderParam.getAccountTypeTo())
                .andLike(StringUtils.isNotEmpty(adjustToOrderParam.getAccountNameFrom()), qAdjustToOrderDO.accountNameFrom, StringUtil.buildLikeString(adjustToOrderParam.getAccountNameFrom()))
                .andLike(StringUtils.isNotEmpty(adjustToOrderParam.getAccountNameTo()), qAdjustToOrderDO.accountNameTo, StringUtil.buildLikeString(adjustToOrderParam.getAccountNameTo()))
                .andEq(StringUtils.isNotEmpty(adjustToOrderParam.getAdjustReason()), qAdjustToOrderDO.adjustReason, adjustToOrderParam.getAdjustReason())
                .andLike(StringUtils.isNotEmpty(adjustToOrderParam.getRemark()), qAdjustToOrderDO.remark, StringUtil.buildLikeString(adjustToOrderParam.getRemark()))
                .build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qAdjustToOrderDO.id,
                qAdjustToOrderDO.docState,
                qAdjustToOrderDO.accountCodeFrom,
                qAdjustToOrderDO.accountNameFrom,
                qAdjustToOrderDO.accountTypeFrom,
                qAdjustToOrderDO.accountTypeTo,
                qAdjustToOrderDO.accountCodeTo,
                qAdjustToOrderDO.accountNameTo,
                qAdjustToOrderDO.auditTime,
                qAdjustToOrderDO.auditRejectReason,
                qAdjustToOrderDO.auditUser,
                qAdjustToOrderDO.docNo,
                qAdjustToOrderDO.createTime,
                qAdjustToOrderDO.creator,
                qAdjustToOrderDO.adjustAmount,
                qAdjustToOrderDO.remark,
                qAdjustToOrderDO.modifyTime,
                qAdjustToOrderDO.modifyUserId,
                qAdjustToOrderDO.updater,
                qAdjustToOrderDO.adjustReason
        )).from(qAdjustToOrderDO);
    }


    public AdjustToOrderDO findById(Long id) {
        Optional<AdjustToOrderDO> adjustToOrderDOOptional = adjustToOrderRepo.findById(id);
        Assert.isTrue(adjustToOrderDOOptional.isPresent(), "查询不到调剂单");
        return adjustToOrderDOOptional.get();
    }


}
