package com.elitesland.fin.repo.creditaccount;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.creditaccount.CreditAccountSnapshotParam;
import com.elitesland.fin.application.facade.vo.creditaccount.CreditAccountSnapshotVo;
import com.elitesland.fin.entity.creditaccount.CreditAccountSnapshotDO;
import com.elitesland.fin.entity.creditaccount.QCreditAccountSnapshotDO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.stereotype.Repository;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.repo
 * @date 2023/2/16 15:00
 */
@Repository
public class CreditAccountSnapshotRepoProc extends BaseRepoProc<CreditAccountSnapshotDO> {

    private final static QCreditAccountSnapshotDO Q_DO = QCreditAccountSnapshotDO.creditAccountSnapshotDO;

    protected CreditAccountSnapshotRepoProc() {
        super(Q_DO);
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                Q_DO.id,
                Q_DO.ouCode,
                Q_DO.ouName,
                Q_DO.objectName,
                Q_DO.creditAccountCode,
                Q_DO.creditAccountName,
                Q_DO.creditAccountType,
                Q_DO.objectCode,
                Q_DO.deptName,
                Q_DO.productLineCode,
                Q_DO.productLineName,
                Q_DO.creditAccountLimit,
                Q_DO.creditAccountUsedLimit,
                Q_DO.creditAccountOccupancyLimit,
                Q_DO.creditAccountAvailableLimit,
                Q_DO.status,
                Q_DO.snapshotTime,
                Q_DO.remark,
                Q_DO.createTime,
                Q_DO.creator,
                Q_DO.createUserId,
                Q_DO.modifyTime,
                Q_DO.modifyUserId,
                Q_DO.updater,
                Q_DO.tenantId
        )).from(Q_DO);
    }

    private PredicateBuilder commonBuilder(CreditAccountSnapshotParam param) {
        return PredicateBuilder.builder()
                .andIn(CollectionUtil.isNotEmpty(param.getIds()), Q_DO.id, param.getIds())
                .andLike(StrUtil.isNotBlank(param.getCreditAccountCode()), Q_DO.creditAccountCode, param.getCreditAccountCode())
                .andLike(StrUtil.isNotBlank(param.getKeyWord()), new StringExpression[]{Q_DO.creditAccountCode, Q_DO.creditAccountName}, param.getKeyWord())
                .andLike(StrUtil.isNotBlank(param.getCreditAccountName()), Q_DO.creditAccountName, param.getCreditAccountName())
                .andLike(StrUtil.isNotBlank(param.getObjectName()), Q_DO.objectName, param.getObjectName())
                .andEq(StrUtil.isNotBlank(param.getObjectCode()), Q_DO.objectCode, param.getObjectCode())
                .andGoe(ObjectUtil.isNotNull(param.getSnapshotStartTime()), Q_DO.snapshotTime, param.getSnapshotStartTime())
                .andLoe(ObjectUtil.isNotNull(param.getSnapshotEndTime()), Q_DO.snapshotTime, param.getSnapshotEndTime());

    }

    public PagingVO<CreditAccountSnapshotVo> querySnapshot(CreditAccountSnapshotParam param) {
        Predicate predicate = commonBuilder(param).build();
        JPAQuery<CreditAccountSnapshotVo> query = select(CreditAccountSnapshotVo.class).where(predicate);
        param.setPaging(query);
        param.fillOrders(query, Q_DO);
        return PagingVO.<CreditAccountSnapshotVo>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }
}
