package com.elitesland.fin.repo.limitadjustorder;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.facade.dto.limitadjustorder.LimitAdjustOrderDTO;
import com.elitesland.fin.application.facade.param.limitadjustorder.LimitAdjustOrderParam;
import com.elitesland.fin.application.facade.vo.adjustorder.AdjustOrderVO;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.limitadjustorder.LimitAdjustOrderDO;
import com.elitesland.fin.entity.limitadjustorder.QLimitAdjustOrderDO;
import com.elitesland.fin.utils.StringUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @author zhiyu.he
 * @date 2023/2/25 9:59
 */
@Component
@RequiredArgsConstructor
public class LimitAdjustOrderRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QLimitAdjustOrderDO qLimitAdjustOrder = QLimitAdjustOrderDO.limitAdjustOrderDO;
    private final LimitAdjustOrderRepo limitAdjustOrderRepo;

    public PagingVO<LimitAdjustOrderDTO> page(LimitAdjustOrderParam limitAdjustOrderParam) {
        List<Predicate> where = where(limitAdjustOrderParam);
        JPAQuery<LimitAdjustOrderDTO> query = select(LimitAdjustOrderDTO.class).where(ExpressionUtils.allOf(where));

        limitAdjustOrderParam.setPaging(query);
        limitAdjustOrderParam.fillOrders(query, qLimitAdjustOrder);

        return PagingVO.<LimitAdjustOrderDTO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    public List<LimitAdjustOrderDTO> queryByParam(LimitAdjustOrderParam limitAdjustOrderParam) {
        List<Predicate> where = where(limitAdjustOrderParam);
        JPAQuery<LimitAdjustOrderDTO> query = select(LimitAdjustOrderDTO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    public List<AdjustOrderVO> queryByIds(List<Long> id) {
        return select(AdjustOrderVO.class)
                .where(qLimitAdjustOrder.id.in(id))
                .fetch();
    }

    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO) {
        jpaQueryFactory.update(qLimitAdjustOrder)
                .set(qLimitAdjustOrder.docState, status)
                .set(qLimitAdjustOrder.auditTime, LocalDateTime.now())
                .set(qLimitAdjustOrder.auditUser, sysUserDTO.getUsername())
                .where(qLimitAdjustOrder.id.in(ids))
                .execute();
    }

    public void updateReject(List<Long> ids, String status, SysUserDTO sysUserDTO, String reason) {
        jpaQueryFactory.update(qLimitAdjustOrder)
                .set(qLimitAdjustOrder.docState, status)
                .set(qLimitAdjustOrder.auditTime, LocalDateTime.now())
                .set(qLimitAdjustOrder.auditUser, sysUserDTO.getUsername())
                .set(qLimitAdjustOrder.auditRejectReason, reason)
                .where(qLimitAdjustOrder.id.in(ids))
                .execute();
    }

    public void updateByIds(List<Long> ids, String status, SysUserDTO sysUserDTO, String reason) {
        jpaQueryFactory.update(qLimitAdjustOrder)
                .set(qLimitAdjustOrder.docState, status)
                .set(qLimitAdjustOrder.auditTime, LocalDateTime.now())
                .set(qLimitAdjustOrder.auditUser, sysUserDTO.getUsername())
                .set(qLimitAdjustOrder.auditRejectReason, reason)
                .where(qLimitAdjustOrder.id.in(ids))
                .execute();
    }

    public AdjustOrderVO queryById(Long id) {
        return select(AdjustOrderVO.class)
                .where(qLimitAdjustOrder.id.eq(id))
                .fetchOne();
    }

    private String buildLikeString(String string) {
        return FinConstant.PERCENTAGE.concat(string).concat(FinConstant.PERCENTAGE);
    }

    private List<Predicate> where(LimitAdjustOrderParam limitAdjustOrderParam) {
        List<Predicate> predicates = new ArrayList<>();

        if (limitAdjustOrderParam.getId() != null) {
            predicates.add(qLimitAdjustOrder.id.eq(limitAdjustOrderParam.getId()));
        }

        if (StringUtils.isNotEmpty(limitAdjustOrderParam.getDocNo())) {
            predicates.add(qLimitAdjustOrder.docNo.like(buildLikeString(limitAdjustOrderParam.getDocNo())));
        }

        if (StringUtils.isNotEmpty(limitAdjustOrderParam.getCreditType())) {
            predicates.add(qLimitAdjustOrder.creditType.eq(limitAdjustOrderParam.getCreditType()));
        }

        if (StringUtils.isNotEmpty(limitAdjustOrderParam.getAdjustType())) {
            predicates.add(qLimitAdjustOrder.adjustType.eq(limitAdjustOrderParam.getAdjustType()));
        }

        if (StringUtils.isNotEmpty(limitAdjustOrderParam.getDocState())) {
            predicates.add(qLimitAdjustOrder.docState.eq(limitAdjustOrderParam.getDocState()));
        }

        if (StringUtils.isNotEmpty(limitAdjustOrderParam.getObjectName())) {
            predicates.add(qLimitAdjustOrder.objectName.like(buildLikeString(limitAdjustOrderParam.getObjectName())));
        }

        if (StringUtils.isNotEmpty(limitAdjustOrderParam.getCreditAccountName())) {
            predicates.add(qLimitAdjustOrder.creditAccountName.like(buildLikeString(limitAdjustOrderParam.getCreditAccountName())));
        }

        if (StringUtils.isNotEmpty(limitAdjustOrderParam.getAdjustReason())) {
            predicates.add(qLimitAdjustOrder.adjustReason.eq(limitAdjustOrderParam.getAdjustReason()));
        }

        if (limitAdjustOrderParam.getCreateTimeStart() != null) {
            predicates.add(qLimitAdjustOrder.createTime.goe(limitAdjustOrderParam.getCreateTimeStart()));
        }

        if (limitAdjustOrderParam.getCreateTimeEnd() != null) {
            predicates.add(qLimitAdjustOrder.createTime.loe(limitAdjustOrderParam.getCreateTimeEnd()));
        }

        if (limitAdjustOrderParam.getAuditTimeStart() != null) {
            predicates.add(qLimitAdjustOrder.auditTime.goe(limitAdjustOrderParam.getAuditTimeStart()));
        }

        if (limitAdjustOrderParam.getAuditTimeEnd() != null) {
            predicates.add(qLimitAdjustOrder.auditTime.loe(limitAdjustOrderParam.getAuditTimeEnd()));
        }

        if (limitAdjustOrderParam.getCurrentTime()!= null) {
            predicates.add(qLimitAdjustOrder.expireTime.loe(limitAdjustOrderParam.getCurrentTime()));
        }
        if(ObjectUtil.isNotNull(limitAdjustOrderParam.getCurrEffectiveTime())){
            predicates.add(qLimitAdjustOrder.effectiveTime.loe(limitAdjustOrderParam.getCurrEffectiveTime()));
        }

        if(StringUtils.isNotEmpty(limitAdjustOrderParam.getRemark())){
            predicates.add(qLimitAdjustOrder.remark.like(StringUtil.buildLikeString(limitAdjustOrderParam.getRemark())));
        }


        return predicates;
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qLimitAdjustOrder.id,
                qLimitAdjustOrder.docNo,
                qLimitAdjustOrder.docState,
                qLimitAdjustOrder.creditType,
                qLimitAdjustOrder.adjustType,
                qLimitAdjustOrder.expireTime,
                qLimitAdjustOrder.ouCode,
                qLimitAdjustOrder.ouName,
                qLimitAdjustOrder.buCode,
                qLimitAdjustOrder.buName,
                qLimitAdjustOrder.productLine,
                qLimitAdjustOrder.saleUser,
                qLimitAdjustOrder.objectType,
                qLimitAdjustOrder.objectName,
                qLimitAdjustOrder.creditAccountCode,
                qLimitAdjustOrder.creditAccountName,
                qLimitAdjustOrder.adjustLimit,
                qLimitAdjustOrder.adjustReason,
                qLimitAdjustOrder.auditUser,
                qLimitAdjustOrder.auditTime,
                qLimitAdjustOrder.auditRejectReason,
                qLimitAdjustOrder.creator,
                qLimitAdjustOrder.createTime,
                qLimitAdjustOrder.updater,
                qLimitAdjustOrder.modifyTime,
                qLimitAdjustOrder.remark,
                qLimitAdjustOrder.workflowProcInstId.as("procInstId"),
                qLimitAdjustOrder.workflowProcInstStatus.as("procInstStatus"),
                qLimitAdjustOrder.workflowSubmitTime,
                qLimitAdjustOrder.workflowEndTime,
                qLimitAdjustOrder.workflowCurrentNodeKey,
                qLimitAdjustOrder.workflowCurrentNodeName,
                qLimitAdjustOrder.workflowCurrentUserIds,
                qLimitAdjustOrder.workflowRejectedMessage,
                qLimitAdjustOrder.effectiveTime,
                qLimitAdjustOrder.fileCode
        )).from(qLimitAdjustOrder);
    }

    public LimitAdjustOrderDO findById(Long id){
        Optional<LimitAdjustOrderDO> limitAdjustOrderDOOptional = limitAdjustOrderRepo.findById(id);
        Assert.isTrue(limitAdjustOrderDOOptional.isPresent(),"查不到额度调整单");
        return limitAdjustOrderDOOptional.get();
    }


    @Transactional(rollbackFor = Exception.class)
    public void updateDocStateByIds(LimitAdjustOrderParam limitAdjustOrderParam) {
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qLimitAdjustOrder);
        if(limitAdjustOrderParam.getDocState()!=null){
            jpaUpdateClause.set(qLimitAdjustOrder.docState, limitAdjustOrderParam.getDocState());
        }
        jpaUpdateClause.where(qLimitAdjustOrder.id.in(limitAdjustOrderParam.getIds()));
        jpaUpdateClause.execute();
    }

    @Transactional(rollbackFor = Exception.class)
    public void updateWorkflow(LimitAdjustOrderDO limitAdjustOrderDO, ProcessInfo processInfo) {
        // 修改业务审批数据
        QLimitAdjustOrderDO qLimitAdjustOrderDO = QLimitAdjustOrderDO.limitAdjustOrderDO;
        JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qLimitAdjustOrderDO)
                .set(qLimitAdjustOrderDO.workflowProcInstId, processInfo.getProcInstId())
                .set(qLimitAdjustOrderDO.workflowSubmitTime, LocalDateTime.now())
                .where(qLimitAdjustOrderDO.id.eq(limitAdjustOrderDO.getId()));
        if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
            jpaUpdateClause.set(qLimitAdjustOrderDO.workflowProcInstStatus, ProcInstStatus.APPROVING);
            jpaUpdateClause.set(qLimitAdjustOrderDO.docState, UdcEnum.APPLY_STATUS_DOING.getValueCode());
        }
        jpaUpdateClause.execute();
    }
}
