package com.elitesland.fin.rocketmq.channel;

import org.springframework.cloud.stream.annotation.Input;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;

/**
 *消费者消费的通道
 *  Processor可以用于既有输入又有输出通道应用中。 不能订阅重复。 要么使用聚合。 要么分开二选
 */
public interface FinSalMqProcessor {

    //销售结算单
    String INPUT_SAL = "yst-corder-fin-input";

    @Input(INPUT_SAL)
    SubscribableChannel endPointInput();

    String APPROVE_ACCOUNT_FLOW_OUTPUT = "approve-account-flow-output";
    @Output(APPROVE_ACCOUNT_FLOW_OUTPUT)
    MessageChannel approveAccountFlowOutput();

    String APPROVE_ACCOUNT_FLOW_INPUT = "approve-account-flow-input";
    @Input(APPROVE_ACCOUNT_FLOW_INPUT)
    SubscribableChannel approveAccountFlowInput();

    String GENERATE_ACCOUNT_FLOW_OUTPUT = "generate-account-flow-output";
    @Output(GENERATE_ACCOUNT_FLOW_OUTPUT)
    MessageChannel generateAccountFlowOutput();

    String GENERATE_ACCOUNT_FLOW_INPUT = "generate-account-flow-input";
    @Input(GENERATE_ACCOUNT_FLOW_INPUT)
    SubscribableChannel generateAccountFlowInput();

    String APPROVE_CREDIT_ACCOUNT_FLOW_OUTPUT = "approve-credit-account-flow-output";
    @Output(APPROVE_CREDIT_ACCOUNT_FLOW_OUTPUT)
    MessageChannel approveCreditAccountFlowOutput();

    String APPROVE_CREDIT_ACCOUNT_FLOW_INPUT = "approve-credit-account-flow-input";
    @Input(APPROVE_CREDIT_ACCOUNT_FLOW_INPUT)
    SubscribableChannel approveCreditAccountFlowInput();

    String GENERATE_CREDIT_ACCOUNT_FLOW_OUTPUT = "generate-credit-account-flow-output";
    @Output(GENERATE_CREDIT_ACCOUNT_FLOW_OUTPUT)
    MessageChannel generateCreditAccountFlowOutput();

    String GENERATE_CREDIT_ACCOUNT_FLOW_INPUT = "generate-credit-account-flow-input";
    @Input(GENERATE_CREDIT_ACCOUNT_FLOW_INPUT)
    SubscribableChannel generateCreditAccountFlowInput();
}
