package com.elitesland.fin.application.facade.dto.account;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author gyj
 * @date 2023/05/24 18:23
 */
@Data
public class AccountRuleConfigDtlDTO extends BaseModelDTO implements Serializable {
    private static final long serialVersionUID = -6636051829799954013L;

    @ApiModelProperty(value = "主表ID")
    private Long masId;

    @ApiModelProperty(value = "执行序列")
    private Integer priorityNo;

    @ApiModelProperty(value = "事务码")
    private String ioCode;

    @ApiModelProperty("事务码名称")
    private String ioName;

    @ApiModelProperty("适用单据类型")
    private String optDocType;

    @ApiModelProperty("适用单据状态")
    private String optDocStatus;

    @ApiModelProperty("适用账户类型")
    private String optAccountType;

    @ApiModelProperty("指定账户")
    private String specificAccount;

    @ApiModelProperty("最高透支额度")
    private BigDecimal maxLimit;

    @ApiModelProperty("计算比例")
    private BigDecimal calculatePercent;

    @ApiModelProperty(value = "流水自动审核 1-是 0-否")
    private boolean automaticReview;
}