package com.elitesland.fin.application.facade.param.adjusttoorder;

import com.elitesland.fin.application.facade.base.BaseModelParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/3/3 20:45
 */
@Data
@ApiModel(description = "调剂单")
public class AdjustToOrderParam extends BaseModelParam {

    @ApiModelProperty("单号")
    private String docNo;

    @ApiModelProperty("单据状态")
    private String docState;

    @ApiModelProperty("从账户类型")
    private String accountTypeFrom;

    @ApiModelProperty("从账户编码")
    private String accountCodeFrom;

    @ApiModelProperty("从账户名称")
    private String accountNameFrom;

    @ApiModelProperty("至账户名称")
    private String accountNameTo;

    @ApiModelProperty("至账户类型")
    private String accountTypeTo;

    @ApiModelProperty("至账户编码")
    private String accountCodeTo;

    @ApiModelProperty("调整原因")
    private String adjustReason;

    @ApiModelProperty("调整金额")
    private BigDecimal adjustAmount;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditTime;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejectReason;

}
