package com.elitesland.fin.application.facade.param.invoice;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @Author: ryan.xu
 * @since 2023/4/19
 */
@Data
@Accessors(chain = true)
@ApiModel("待开发票分页查询参数")
public class InvoiceAwaitQueryParam extends AbstractOrderQueryParam {

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("单号")
    private String docNo;

    @ApiModelProperty("待开发票状态")
    private String invoiceAwaitStatus;

//    @ApiModelProperty("公司名称")
//    private String ouName;

    @ApiModelProperty("来源单号")
    private String optDocNo;

    @ApiModelProperty("主客户编码")
    private String mainCustCode;

    @ApiModelProperty("主客户名称")
    private String mainCustName;

    @ApiModelProperty("对账类型-订单分组")
    private String docType3;

    /**
     * 订货人
     */
    @ApiModelProperty("订货人")
    private String recvContactName;
    /**
     * 订货联系电话
     */
    @ApiModelProperty("订货联系电话")
    private String recvContactTel;
}
