package com.elitesland.fin.application.facade.vo.invoice;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Data
@ApiModel(value = "付款通知单返回实体")
public class PaymentNoticeRespVO implements Serializable {
    private static final long serialVersionUID = 2617718744779453725L;

    @ApiModelProperty(" 付款通知单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("加盟商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long franchiseeId;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    /**
     * 开户银行
     */
    @ApiModelProperty(name = "开户银行")
    private String invBankNo;
    /**
     * 银行账号
     */
    @ApiModelProperty(name = "银行账号")
    private String bankAccount;
    /**
     * 收费项目
     */
    @ApiModelProperty(name = "收费项目")
    private String itemCode;

    @ApiModelProperty(name = "收费项目名称")
    private String itemCodeName;
    /**
     * 含税金额
     */
    @ApiModelProperty(name = "含税金额")
    private BigDecimal amt;
    /**
     * 税率
     */
    @ApiModelProperty(name = "税率")
    private BigDecimal taxRate;
    /**
     * 日期
     */
    @ApiModelProperty(name = "日期")
    private LocalDate noticeDate;
    /**
     * 通知内容
     */
    @ApiModelProperty(name = "通知内容")
    private String noticeContent;

    @ApiModelProperty("门店编码")
    private String storeCode;
    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty(name = "联行号")
    private String uniBankNo;
    @ApiModelProperty(name = "付款银行")
    private String payBank;
    @ApiModelProperty(name = "付款账户")
    private String payAccount;
    @ApiModelProperty(name = "备注")
    private String remark;
    @ApiModelProperty(name = "可开票金额")
    private BigDecimal amtRate;

    @ApiModelProperty(name = "付款通知单明细")
    private List<PaymentNoticeDRespVO> paymentNoticeDList;
}
