package com.elitesland.fin.domain.entity.accountingengine;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author gyj
 * @date 2023/10/10
 */

@Entity
@Table(name="fin_set_of_book_ou")
@org.hibernate.annotations.Table(appliesTo = "fin_set_of_book_ou", comment = "账套公司")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class FinSetOfBookOuDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2545000595570608501L;

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '主表id'")
    private Long masId;

    @Column(name = "ou_code", columnDefinition = "varchar(20) comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(20) comment '公司名称'")
    private String ouName;
}
