package com.elitesland.fin.provider.account;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.account.AccountBalanceConvert;
import com.elitesland.fin.application.facade.param.account.AccountBalanceParam;
import com.elitesland.fin.application.facade.vo.account.AccountBalanceVO;
import com.elitesland.fin.application.service.account.AccountBalanceService;
import com.elitesland.fin.dto.account.AccountBalanceRpcDTO;
import com.elitesland.fin.param.account.AccountBalanceRpcParam;
import com.elitesland.fin.service.account.AccountBalanceRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/12/27
 * @Version 1.0
 * @Content:
 */
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + AccountBalanceRpcService.PATH)
@Slf4j
public class AccountBalanceRpcServiceImpl implements AccountBalanceRpcService{

    public final AccountBalanceService accountBalanceService;

    @Override
    public ApiResult<List<AccountBalanceRpcDTO>> selectAccountBalanceByParam(AccountBalanceRpcParam accountRpcParam) {

        AccountBalanceParam accountBalanceParam = AccountBalanceConvert.INSTANCE.rpcParamToParam(accountRpcParam);
        List<AccountBalanceVO> accountBalanceVOList =  accountBalanceService.selectAccountBalanceByParam(accountBalanceParam);
        if (CollectionUtil.isEmpty(accountBalanceVOList)){
            return ApiResult.ok(Collections.emptyList());
        }

        List<AccountBalanceRpcDTO> accountBalanceRpcDTOList = accountBalanceVOList.stream().map(AccountBalanceConvert.INSTANCE::voToRpcDto).collect(Collectors.toList());

        return ApiResult.ok(accountBalanceRpcDTOList);
    }

}
