/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.provider.invoice.await;

import com.elitesland.fin.application.convert.invoice.InvoiceAwaitConvert;
import com.elitesland.fin.application.convert.invoice.InvoiceAwaitDConvert;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDDO;
import com.elitesland.fin.entity.invoice.InvoiceAwaitDO;
import com.elitesland.fin.enums.InvoiceAwaitTypeEnum;
import com.elitesland.fin.param.invoice.InvoiceAwaitSaveParam;
import com.elitesland.fin.provider.invoice.await.InvoiceAwaitSaveService;
import com.elitesland.fin.repo.invoice.InvoiceAwaitDRepo;
import com.elitesland.fin.repo.invoice.InvoiceAwaitRepo;
import com.elitesland.fin.rpc.system.SystemRpcService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SalSoInvoiceAwaitSaveServiceImpl
implements InvoiceAwaitSaveService {
    private static final Logger log = LoggerFactory.getLogger(SalSoInvoiceAwaitSaveServiceImpl.class);
    private final InvoiceAwaitRepo invoiceAwaitRepo;
    private final InvoiceAwaitDRepo invoiceAwaitDRepo;
    private final SystemRpcService systemRpcService;

    @Override
    public InvoiceAwaitTypeEnum getPaymentRecordStrategy() {
        return InvoiceAwaitTypeEnum.SAL_SO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveInvoiceAwait(InvoiceAwaitSaveParam param) {
        InvoiceAwaitDO invoiceAwaitDO = InvoiceAwaitConvert.INSTANCE.saveParam2Do(param);
        invoiceAwaitDO.setDocNo(this.systemRpcService.sysNumberRuleGenerateCode("yst-fin", "PAYMENT_RECORDS", new ArrayList<String>()));
        Long masId = ((InvoiceAwaitDO)this.invoiceAwaitRepo.save(invoiceAwaitDO)).getId();
        this.saveRecordsD(param, masId);
        return masId;
    }

    protected void saveRecordsD(InvoiceAwaitSaveParam saveVO, Long masId) {
        List invoiceAwaitDSaveParamList = saveVO.getInvoiceAwaitDSaveParamList();
        List<InvoiceAwaitDDO> invoiceAwaitDDOS = InvoiceAwaitDConvert.INSTANCE.saveVOs2DOs(invoiceAwaitDSaveParamList);
        AtomicInteger lineNo = new AtomicInteger();
        invoiceAwaitDDOS.stream().forEach(ddo -> {
            ddo.setMasId(masId);
            ddo.setLineNo(lineNo.getAndIncrement());
        });
        this.invoiceAwaitDRepo.deleteByMasId(masId);
        this.invoiceAwaitDRepo.saveAll(invoiceAwaitDDOS);
    }

    public SalSoInvoiceAwaitSaveServiceImpl(InvoiceAwaitRepo invoiceAwaitRepo, InvoiceAwaitDRepo invoiceAwaitDRepo, SystemRpcService systemRpcService) {
        this.invoiceAwaitRepo = invoiceAwaitRepo;
        this.invoiceAwaitDRepo = invoiceAwaitDRepo;
        this.systemRpcService = systemRpcService;
    }
}

