/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.domain.service.apverconfig;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.core.seq.SeqNumProvider;
import com.elitesland.fin.application.convert.apverconfig.ApVerConfigConvert;
import com.elitesland.fin.application.convert.apverconfig.ApVerConfigDtlConvert;
import com.elitesland.fin.domain.entity.apverconfig.ApVerConfig;
import com.elitesland.fin.domain.entity.apverconfig.ApVerConfigDO;
import com.elitesland.fin.domain.entity.apverconfig.ApVerConfigDtlDO;
import com.elitesland.fin.domain.param.apverconfig.ApVerConfigPageParam;
import com.elitesland.fin.domain.service.apverconfig.ApVerConfigDomainService;
import com.elitesland.fin.infr.dto.apverconfig.ApVerConfigDTO;
import com.elitesland.fin.infr.dto.apverconfig.ApVerConfigDtlDTO;
import com.elitesland.fin.infr.repo.apverconfig.ApVerConfigDtlRepo;
import com.elitesland.fin.infr.repo.apverconfig.ApVerConfigDtlRepoProc;
import com.elitesland.fin.infr.repo.apverconfig.ApVerConfigRepo;
import com.elitesland.fin.infr.repo.apverconfig.ApVerConfigRepoProc;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApVerConfigDomainServiceImpl
implements ApVerConfigDomainService {
    private final ApVerConfigRepo apVerConfigRepo;
    private final ApVerConfigRepoProc apVerConfigRepoProc;
    private final ApVerConfigDtlRepo apVerConfigDtlRepo;
    private final ApVerConfigDtlRepoProc apVerConfigDtlRepoProc;
    private final SeqNumProvider sysNumberRuleService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String save(ApVerConfig apVerConfig) {
        apVerConfig.checkNotNull();
        apVerConfig.defaultValue();
        if (apVerConfig.getId() == null) {
            apVerConfig.setDefaultFlag(this.apVerConfigRepoProc.isFirst() == false);
            Boolean nameByName = this.apVerConfigRepoProc.existNameByName(apVerConfig.getSchemeName());
            if (nameByName.booleanValue()) {
                throw new BusinessException("\u5df2\u5b58\u5728\u7684\u65b9\u6848\u540d\u79f0!");
            }
        } else {
            Boolean existNameById = this.apVerConfigRepoProc.existNameById(apVerConfig.getSchemeName(), apVerConfig.getId());
            if (existNameById.booleanValue()) {
                throw new BusinessException("\u5df2\u5b58\u5728\u7684\u65b9\u6848\u540d\u79f0!");
            }
        }
        return this.saveOrUpdate(apVerConfig).toString();
    }

    @Override
    public ApVerConfigDTO queryById(Long id) {
        ApVerConfigDTO apVerConfigDTO = this.apVerConfigRepoProc.queryById(id);
        List<ApVerConfigDtlDTO> configDtlDTOS = this.apVerConfigDtlRepoProc.queryByMasId(id);
        apVerConfigDTO.setApVerConfigDtlDTOList(configDtlDTOS);
        return apVerConfigDTO;
    }

    @Override
    public PagingVO<ApVerConfigDTO> page(ApVerConfigPageParam param) {
        return this.apVerConfigRepoProc.page(param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateEnable(List<Long> ids) {
        List<ApVerConfigDTO> apVerConfigDTOS = this.apVerConfigRepoProc.queryByIds(ids);
        apVerConfigDTOS.forEach(dto -> {
            if (!dto.getEnableFlag().booleanValue()) {
                throw new BusinessException("\u5df2\u505c\u7528\u72b6\u6001\u4e0d\u5141\u8bb8\u505c\u7528!");
            }
        });
        this.apVerConfigRepoProc.updateEnable(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateDef(Long id) {
        ApVerConfigDTO apVerConfigDTO = this.apVerConfigRepoProc.queryById(id);
        if (apVerConfigDTO.getDefaultFlag().booleanValue()) {
            throw new BusinessException("\u5df2\u9ed8\u8ba4\u72b6\u6001\u4e0d\u5141\u8bb8\u518d\u6b21\u9ed8\u8ba4!");
        }
        this.apVerConfigRepoProc.updateDefault();
        return this.apVerConfigRepoProc.updateDefaultById(id, true);
    }

    @Override
    public List<ApVerConfigDTO> queryAll() {
        return this.apVerConfigRepoProc.queryAll();
    }

    @Override
    public ApVerConfigDTO queryDef() {
        return this.apVerConfigRepoProc.queryDef();
    }

    private Long saveOrUpdate(ApVerConfig apVerConfig) {
        ApVerConfigDO apVerConfigDO = ApVerConfigConvert.INSTANCE.convert(apVerConfig);
        if (apVerConfig.getId() != null) {
            this.apVerConfigDtlRepoProc.deleteByMasId(apVerConfig.getId());
        } else {
            String payOrderNo = this.sysNumberRuleService.generateCode("yst-fin", "HXFA", null);
            apVerConfigDO.setSchemeNo(payOrderNo);
        }
        ApVerConfigDO configDO = (ApVerConfigDO)this.apVerConfigRepo.save(apVerConfigDO);
        apVerConfig.getConfigDtlSaveParamList().forEach(dtl -> dtl.setMasId(configDO.getId()));
        List<ApVerConfigDtlDO> apVerConfigDtlDOS = ApVerConfigDtlConvert.INSTANCE.convertDo(apVerConfig.getConfigDtlSaveParamList());
        this.apVerConfigDtlRepo.saveAll(apVerConfigDtlDOS);
        return configDO.getId();
    }

    public ApVerConfigDomainServiceImpl(ApVerConfigRepo apVerConfigRepo, ApVerConfigRepoProc apVerConfigRepoProc, ApVerConfigDtlRepo apVerConfigDtlRepo, ApVerConfigDtlRepoProc apVerConfigDtlRepoProc, SeqNumProvider sysNumberRuleService) {
        this.apVerConfigRepo = apVerConfigRepo;
        this.apVerConfigRepoProc = apVerConfigRepoProc;
        this.apVerConfigDtlRepo = apVerConfigDtlRepo;
        this.apVerConfigDtlRepoProc = apVerConfigDtlRepoProc;
        this.sysNumberRuleService = sysNumberRuleService;
    }
}

