/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infr.factory.arorder;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.fin.infr.repo.arorder.ArOrderDtlRepoProc;
import com.elitesland.fin.infr.repo.arorder.ArOrderRepoProc;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ArOrderFactory {
    private final ArOrderDtlRepoProc arOrderDtlRepoProc;
    private final ArOrderRepoProc arOrderRepoProc;

    public PagingVO<ArOrderDTO> page(ArOrderPageParam arOrderPageParam) {
        List<Long> masId = this.arOrderDtlRepoProc.findBySourceId(arOrderPageParam.getSourceNoDtl());
        PagingVO<ArOrderDTO> page = this.arOrderRepoProc.page(arOrderPageParam, masId);
        page.getRecords().forEach(x -> {
            x.setTotalCount(this.arOrderDtlRepoProc.countByMasId(x.getId()).stream().reduce(BigDecimal.ZERO, BigDecimal::add));
            x.setUnVerAmt(x.getTotalAmt().subtract(x.getVerAmt()));
        });
        return page;
    }

    public ArOrderFactory(ArOrderDtlRepoProc arOrderDtlRepoProc, ArOrderRepoProc arOrderRepoProc) {
        this.arOrderDtlRepoProc = arOrderDtlRepoProc;
        this.arOrderRepoProc = arOrderRepoProc;
    }
}

