/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinAccEngDetConditionConvert;
import com.elitesland.fin.application.convert.accountingengine.FinAccEngDetDataConvert;
import com.elitesland.fin.application.convert.accountingengine.FinAccEngDetDataLineConvert;
import com.elitesland.fin.application.convert.accountingengine.FinAccountEngineConvert;
import com.elitesland.fin.application.convert.accountingengine.FinAccountEngineDetailsConvert;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccEngDetConditionParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccountEngineDetailsParam;
import com.elitesland.fin.application.facade.param.accountingengine.FinAccountEngineParam;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccEngDetConditionVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccEngDetDataLineVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccEngDetDataVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccountEngineDetailsVO;
import com.elitesland.fin.application.facade.vo.accountingengine.FinAccountEngineVO;
import com.elitesland.fin.application.service.accountingengine.FinAccountEngineService;
import com.elitesland.fin.application.service.accountingengine.FinJournalLogService;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.accountingengine.FinAccEngDetConditionDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccEngDetDataDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccEngDetDataLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountEngineCustomDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountEngineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountEngineDetailsDO;
import com.elitesland.fin.domain.entity.accountingengine.FinEventTableConditionDO;
import com.elitesland.fin.domain.entity.accountingengine.FinEventTableDO;
import com.elitesland.fin.domain.entity.accountingengine.FinEventTableLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFastCodeDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFastCodeLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleValueDO;
import com.elitesland.fin.domain.entity.accountingengine.FinJournalLogDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookOuDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSobAccountPeriodDO;
import com.elitesland.fin.repo.accountingengine.FinAccEngDetConditionRepo;
import com.elitesland.fin.repo.accountingengine.FinAccEngDetDataLineRepo;
import com.elitesland.fin.repo.accountingengine.FinAccEngDetDataRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountEngineDetailsRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountEngineRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountEngineRepoProc;
import com.elitesland.fin.repo.accountingengine.FinEventTableConditionRepo;
import com.elitesland.fin.repo.accountingengine.FinEventTableLineRepo;
import com.elitesland.fin.repo.accountingengine.FinEventTableRepo;
import com.elitesland.fin.repo.accountingengine.FinFastCodeLineRepo;
import com.elitesland.fin.repo.accountingengine.FinFastCodeLineRepoProc;
import com.elitesland.fin.repo.accountingengine.FinFastCodeRepo;
import com.elitesland.fin.repo.accountingengine.FinFastCodeRepoProc;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepoProc;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepo;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepoProc;
import com.elitesland.fin.repo.accountingengine.FinJournalLogRepo;
import com.elitesland.fin.repo.accountingengine.FinJournalRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookLineRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookOuRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookRepoProc;
import com.elitesland.fin.repo.accountingengine.FinSobAccountPeriodRepo;
import com.elitesland.fin.utils.StringUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FinAccountEngineServiceImpl
implements FinAccountEngineService {
    private static final Logger log = LoggerFactory.getLogger(FinAccountEngineServiceImpl.class);
    private final FinAccountEngineRepo finAccountEngineRepo;
    private final FinAccountEngineRepoProc finAccountEngineRepoProc;
    private final FinAccountEngineDetailsRepo finAccountEngineDetailsRepo;
    private final FinAccEngDetConditionRepo finAccEngDetConditionRepo;
    private final FinAccEngDetDataRepo finAccEngDetDataRepo;
    private final FinAccEngDetDataLineRepo finAccEngDetDataLineRepo;
    private final FinEventTableRepo finEventTableRepo;
    private final FinEventTableLineRepo finEventTableLineRepo;
    private final FinEventTableConditionRepo finEventTableConditionRepo;
    private final FinJournalLogService finJournalLogService;
    private final FinJournalLogRepo finJournalLogRepo;
    private final FinSetOfBookOuRepo finSetOfBookOuRepo;
    private final FinSetOfBookRepo finSetOfBookRepo;
    private final FinSetOfBookRepoProc finSetOfBookRepoProc;
    private final FinSetOfBookLineRepo finSetOfBookLineRepo;
    private final FinFastCodeRepo finFastCodeRepo;
    private final FinFastCodeLineRepo finFastCodeLineRepo;
    private final FinFastCodeLineRepoProc finFastCodeLineRepoProc;
    private final FinFastCodeRepoProc finFastCodeRepoProc;
    private final FinFlexibleRepo finFlexibleRepo;
    private final FinFlexibleRepoProc finFlexibleRepoProc;
    private final FinFlexibleValueRepo finFlexibleValueRepo;
    private final FinFlexibleValueRepoProc finFlexibleValueRepoProc;
    private final FinSobAccountPeriodRepo finSobAccountPeriodRepo;
    private final FinJournalRepo finJournalRepo;

    @Override
    @SysCodeProc
    public PagingVO<FinAccountEngineVO> page(FinAccountEngineParam finAccountEngineParam) {
        return FinAccountEngineConvert.INSTANCE.DTOToVO(this.finAccountEngineRepoProc.page(finAccountEngineParam));
    }

    @Override
    @SysCodeProc
    public FinAccountEngineVO queryFinAccountEngine(FinAccountEngineDetailsParam param) {
        Assert.notNull((Object)param.getMasId(), (String)"masId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Optional optional = this.finAccountEngineRepo.findById(param.getMasId());
        Assert.isTrue((boolean)optional.isPresent(), (String)"\u67e5\u8be2\u7684\u4f1a\u8ba1\u5f15\u64ce\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        FinAccountEngineVO engineVO = FinAccountEngineConvert.INSTANCE.DOToVo((FinAccountEngineDO)optional.get());
        List<FinAccountEngineDetailsDO> detailsDOList = this.finAccountEngineDetailsRepo.findAllByMasIdIn(List.of(param.getMasId()));
        List<FinAccountEngineDetailsVO> detailsVOList = FinAccountEngineDetailsConvert.INSTANCE.DOsToVOs(detailsDOList);
        engineVO.setFinAccountEngineDetails(detailsVOList);
        return engineVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableOrDisable(FinAccountEngineParam finAccountEngineParam) {
        this.checkEnableOrDisableParam(finAccountEngineParam);
        List finAccountEngineDOList = this.finAccountEngineRepo.findAllById(finAccountEngineParam.getIds());
        finAccountEngineDOList.stream().forEach(item -> Assert.isFalse((boolean)finAccountEngineParam.getStatus().equals(item.getStatus()), (String)"\u6570\u636e\u5df2\u7ecf\u542f\u7528/\u7981\u7528", (Object[])new Object[0]));
        finAccountEngineDOList.stream().forEach(item -> item.setStatus(finAccountEngineParam.getStatus()));
    }

    private void checkEnableOrDisableParam(FinAccountEngineParam finAccountEngineParam) {
        Assert.notEmpty(finAccountEngineParam.getIds(), (String)"id\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getStatus(), (String)"\u72b6\u6001\u5fc5\u586b", (Object[])new Object[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateFinAccountEngineDetails(FinAccountEngineDetailsParam param) {
        this.checkSaveOrUpdateFinAccountEngineDetails(param);
        FinAccountEngineDetailsDO finAccountEngineDetailsDO = (FinAccountEngineDetailsDO)this.finAccountEngineDetailsRepo.save(FinAccountEngineDetailsConvert.INSTANCE.paramToDO(param));
        this.finAccEngDetConditionRepo.deleteAllByMasId(finAccountEngineDetailsDO.getId());
        List<FinAccEngDetConditionParam> finAccEngDetConditionParamList = param.getFinAccEngDetConditionDetailList();
        finAccEngDetConditionParamList.stream().forEach(item -> item.setMasId(finAccountEngineDetailsDO.getId()));
        this.finAccEngDetConditionRepo.saveAll(FinAccEngDetConditionConvert.INSTANCE.paramToDO(finAccEngDetConditionParamList));
        return finAccountEngineDetailsDO.getId();
    }

    private void checkSaveOrUpdateFinAccountEngineDetails(FinAccountEngineDetailsParam param) {
        this.checkFinAccountEngineDetailsParam(param);
        List<FinAccEngDetConditionParam> finAccEngDetConditionParamList = param.getFinAccEngDetConditionDetailList();
        Assert.notEmpty(finAccEngDetConditionParamList, (String)"\u4f1a\u8ba1\u5f15\u64ce\u6761\u4ef6\u5fc5\u586b", (Object[])new Object[0]);
        HashSet serialNums = new HashSet();
        finAccEngDetConditionParamList.stream().forEach(item -> {
            Assert.notNull((Object)item.getSerialNum(), (String)"\u5e8f\u53f7\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getColumnName(), (String)"\u5b57\u6bb5\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getConditionType(), (String)"\u6761\u4ef6\u5fc5\u586b", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getValueFrom(), (String)"\u4ece\u503c\u5185\u5bb9\u5fc5\u586b", (Object[])new Object[0]);
            Assert.isFalse((boolean)serialNums.contains(item.getSerialNum()), (String)"\u5e8f\u53f7\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
            serialNums.add(item.getSerialNum());
        });
    }

    private void checkFinAccountEngineDetailsParam(FinAccountEngineDetailsParam param) {
        Assert.notNull((Object)param.getSerialNum(), (String)"\u5e8f\u53f7\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getAccountEngine(), (String)"\u4f1a\u8ba1\u5f15\u64ce\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)param.getActiveFlag(), (String)"\u662f\u5426\u542f\u7528\u5fc5\u586b", (Object[])new Object[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdate(FinAccountEngineParam finAccountEngineParam) {
        this.checkSaveOrUpdateParam(finAccountEngineParam);
        this.checkIdempotent(finAccountEngineParam);
        FinAccountEngineDO finAccountEngineDO = (FinAccountEngineDO)this.finAccountEngineRepo.save(FinAccountEngineConvert.INSTANCE.paramToDO(finAccountEngineParam));
        this.finAccountEngineDetailsRepo.deleteAllByMasId(finAccountEngineDO.getId());
        List<FinAccountEngineDetailsParam> finAccountEngineDetailsParamList = finAccountEngineParam.getFinAccountEngineDetails();
        finAccountEngineDetailsParamList.stream().forEach(item -> item.setMasId(finAccountEngineDO.getId()));
        this.finAccountEngineDetailsRepo.saveAll(FinAccountEngineDetailsConvert.INSTANCE.paramToDO(finAccountEngineDetailsParamList));
        return finAccountEngineDO.getId();
    }

    private void checkSaveOrUpdateParam(FinAccountEngineParam finAccountEngineParam) {
        Assert.notEmpty((CharSequence)finAccountEngineParam.getEventTable(), (String)"\u4e8b\u4ef6\u8868\u5355\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getColumnCompany(), (String)"\u516c\u53f8\u5b57\u6bb5\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalHost(), (String)"\u4e3b\u673a\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalPort(), (String)"\u7aef\u53e3\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalUser(), (String)"\u7528\u6237\u540d\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalPassword(), (String)"\u5bc6\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalDatabase(), (String)"\u6570\u636e\u5e93\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)finAccountEngineParam.getJournalTable(), (String)"\u4e3b\u8868\u5fc5\u586b", (Object[])new Object[0]);
        List<FinAccountEngineDetailsParam> finAccountEngineDetailsParamList = finAccountEngineParam.getFinAccountEngineDetails();
        Assert.notEmpty(finAccountEngineDetailsParamList, (String)"\u4f1a\u8ba1\u5f15\u64ce\u660e\u7ec6\u5fc5\u586b", (Object[])new Object[0]);
        HashSet serialNums = new HashSet();
        finAccountEngineDetailsParamList.stream().forEach(item -> {
            this.checkFinAccountEngineDetailsParam((FinAccountEngineDetailsParam)((Object)item));
            Assert.isFalse((boolean)serialNums.contains(item.getSerialNum()), (String)"\u5e8f\u53f7\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
            serialNums.add(item.getSerialNum());
        });
    }

    private void checkIdempotent(FinAccountEngineParam finAccountEngineParam) {
        FinAccountEngineDO finAccountEngineDO = this.finAccountEngineRepoProc.findByEventTable(finAccountEngineParam.getEventTable());
        if (finAccountEngineDO != null) {
            Assert.equals((Object)finAccountEngineParam.getId(), (Object)finAccountEngineDO.getId(), (String)"\u4e8b\u4ef6\u8868\u5355\u540d\u79f0\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        }
    }

    @Override
    public List<FinAccEngDetDataLineVO> queryFinAccDetDataLine(FinAccountEngineDetailsParam param) {
        Assert.notNull((Object)param.getMasId(), (String)"masId is not null", (Object[])new Object[0]);
        List<FinAccEngDetDataLineDO> dataLineDOList = this.finAccEngDetDataLineRepo.findAllByMasIdIn(List.of(param.getMasId()));
        List<FinAccEngDetDataLineVO> dataLineVOList = FinAccEngDetDataLineConvert.INSTANCE.DOsToVOS(dataLineDOList);
        return dataLineVOList;
    }

    @Override
    public FinAccountEngineDetailsVO queryAccountEngineDetails(FinAccountEngineDetailsParam param) {
        Assert.notNull((Object)param.getMasId(), (String)"masId is not null", (Object[])new Object[0]);
        Optional optional = this.finAccountEngineDetailsRepo.findById(param.getMasId());
        Assert.isTrue((boolean)optional.isPresent(), (String)"\u8be6\u60c5\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        FinAccountEngineDetailsVO detailsVO = FinAccountEngineDetailsConvert.INSTANCE.DOToVO((FinAccountEngineDetailsDO)optional.get());
        List<FinAccEngDetDataDO> detDataDOList = this.finAccEngDetDataRepo.findAllByMasIdIn(List.of(param.getMasId()));
        List<FinAccEngDetDataVO> detDataVOList = FinAccEngDetDataConvert.INSTANCE.DOsToVOs(detDataDOList);
        detailsVO.setFinAccEngDetDataVOList(detDataVOList);
        List<FinAccEngDetConditionDO> conditionDOList = this.finAccEngDetConditionRepo.findAllByMasIdIn(List.of(param.getMasId()));
        List<FinAccEngDetConditionVO> conditionVOList = FinAccEngDetConditionConvert.INSTANCE.DOsToVos(conditionDOList);
        detailsVO.setFinAccEngDetConditionDetailList(conditionVOList);
        return detailsVO;
    }

    private String buildWhere(List<FinEventTableConditionDO> finEventTableConditionDOList, List<FinAccEngDetConditionDO> finAccEngDetConditionDOList) {
        if (CollectionUtils.isEmpty(finEventTableConditionDOList) && CollectionUtils.isEmpty(finAccEngDetConditionDOList)) {
            return "1=1";
        }
        List wheres = finEventTableConditionDOList.stream().map(item -> this.buildWhere(item.getConditionType(), item.getTableName(), item.getColumnName(), item.getValueFrom(), item.getValueTo())).collect(Collectors.toList());
        wheres.addAll(finAccEngDetConditionDOList.stream().map(item -> this.buildWhere(item.getConditionType(), item.getTableName(), item.getColumnName(), item.getValueFrom(), item.getValueTo())).collect(Collectors.toList()));
        return StringUtils.join(wheres, (String)" ".concat("and"));
    }

    private String buildWhere(String conditionType, String tableName, String columnName, String valueFrom, String valueTo) {
        String concat = tableName.concat(".").concat(columnName).concat(" ");
        if (UdcEnum.EVENT_TABLE_CONDITION_BETWEEN_AND.getValueCode().equals(conditionType)) {
            return concat.concat("between").concat(" ").concat(valueFrom).concat(" ").concat("and").concat(" ").concat(valueTo);
        }
        return concat.concat(conditionType).concat(" ").concat(valueFrom);
    }

    private String buildFields(List<FinEventTableLineDO> finEventTableLineDOList) {
        List fieldList = finEventTableLineDOList.stream().map(item -> item.getTableName().concat(".").concat(item.getColumnName())).collect(Collectors.toList());
        return StringUtils.join(fieldList, (String)",");
    }

    private String buildSql(FinAccountEngineCustomDO finAccountEngineCustomDO, List<FinAccEngDetConditionDO> finAccEngDetConditionDOList) {
        if (StringUtils.isNotEmpty((CharSequence)finAccountEngineCustomDO.getFinEventTableDO().getTable())) {
            return "select".concat(" ").concat(this.buildFields(finAccountEngineCustomDO.getFinEventTableLineDOList())).concat(" ").concat("from").concat(" ").concat(finAccountEngineCustomDO.getFinEventTableDO().getMasTable()).concat(" ").concat("inner").concat(" ").concat("join").concat(" ").concat(finAccountEngineCustomDO.getFinEventTableDO().getTable()).concat(" ").concat("where").concat(" ").concat(finAccountEngineCustomDO.getFinEventTableDO().getMasTable()).concat(".").concat("id").concat(" ").concat("=").concat(" ").concat(finAccountEngineCustomDO.getFinEventTableDO().getTable()).concat(".").concat("masId").concat(" ").concat("and").concat(" ").concat(this.buildWhere(finAccountEngineCustomDO.getFinEventTableConditionDOList(), finAccEngDetConditionDOList));
        }
        return "select".concat(" ").concat(this.buildFields(finAccountEngineCustomDO.getFinEventTableLineDOList())).concat(" ").concat("from").concat(" ").concat(finAccountEngineCustomDO.getFinEventTableDO().getMasTable()).concat(" ").concat("where").concat(" ").concat("1").concat("=").concat("1").concat(" ").concat("and").concat(" ").concat(this.buildWhere(finAccountEngineCustomDO.getFinEventTableConditionDOList(), finAccEngDetConditionDOList));
    }

    @Override
    public void generateJournal(FinAccountEngineParam finAccountEngineParam) {
        this.checkGenerateJournalParam(finAccountEngineParam);
        ArrayList<Map> saveMapList = new ArrayList<Map>();
        this.buildSaveMapList(finAccountEngineParam, saveMapList);
        this.saveFinJournal(finAccountEngineParam, saveMapList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildSaveMapList(FinAccountEngineParam finAccountEngineParam, List<Map> saveMapList) {
        FinAccountEngineCustomDO finAccountEngineCustomDO = this.queryData(finAccountEngineParam);
        ResultSet resultSet = null;
        Connection connection = null;
        Statement preparedStatement = null;
        String docNum = null;
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            connection = DriverManager.getConnection(String.format("jdbc:mysql://%s:%s/%s", finAccountEngineCustomDO.getFinEventTableDO().getHost(), finAccountEngineCustomDO.getFinEventTableDO().getPort(), finAccountEngineCustomDO.getFinEventTableDO().getDatabase()), finAccountEngineCustomDO.getFinEventTableDO().getUser(), finAccountEngineCustomDO.getFinEventTableDO().getPassword());
            for (FinAccountEngineDetailsDO finAccountEngineDetailsDO : finAccountEngineCustomDO.getFinAccountEngineDetailsDOList()) {
                List<FinAccEngDetConditionDO> finAccEngDetConditionDOListItem = finAccountEngineCustomDO.getFinAccEngDetConditionDOList().stream().filter(finAccEngDetDataDO -> finAccountEngineDetailsDO.getId().equals(finAccEngDetDataDO.getMasId())).collect(Collectors.toList());
                String sql = this.buildSql(finAccountEngineCustomDO, finAccEngDetConditionDOListItem);
                preparedStatement = connection.prepareStatement(sql);
                resultSet = preparedStatement.executeQuery();
                ArrayList resultList = new ArrayList();
                while (resultSet.next()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    int columnCount = resultSet.getMetaData().getColumnCount();
                    for (int i = 1; i <= columnCount; ++i) {
                        map.put(resultSet.getMetaData().getColumnName(i), resultSet.getObject(resultSet.getMetaData().getColumnName(i)));
                    }
                    resultList.add(map);
                }
                if (CollectionUtils.isEmpty(resultList)) {
                    this.saveFinJournalLog(null, String.format("{},{}\u7684\u6761\u4ef6\u672a\u547d\u4e2d", finAccountEngineParam.getEventTable(), finAccountEngineDetailsDO.getAccountEngine()));
                    return;
                }
                List finAccEngDetDataDOListItem = finAccountEngineCustomDO.getFinAccEngDetDataDOList().stream().filter(finAccEngDetDataDO -> finAccountEngineDetailsDO.getId().equals(finAccEngDetDataDO.getMasId())).collect(Collectors.toList());
                Assert.notEmpty(finAccEngDetDataDOListItem, (String)"\u67e5\u4e0d\u5230\u6570\u636e\u884c\u8be6\u60c5", (Object[])new Object[0]);
                for (FinAccEngDetDataDO finAccEngDetDataDO2 : finAccEngDetDataDOListItem) {
                    for (Map map : resultList) {
                        Assert.notNull(map.get(finAccountEngineParam.getColumnCompany()), (String)"\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
                        String ouCode = String.valueOf(map.get(finAccountEngineParam.getColumnCompany()));
                        Assert.notNull(map.get(finAccountEngineParam.getColumnDocNum()), (String)"\u5355\u636e\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
                        docNum = String.valueOf(map.get(finAccountEngineParam.getColumnDocNum()));
                        if (!this.checkFinSetOfBookOu(finAccountEngineCustomDO, ouCode, docNum, finAccountEngineParam, finAccountEngineDetailsDO, finAccEngDetDataDO2)) {
                            return;
                        }
                        List finAccEngDetDataLineDOListItem = finAccountEngineCustomDO.getFinAccEngDetDataLineDOList().stream().filter(finAccEngDetDataLineDO -> finAccEngDetDataDO2.getId().equals(finAccEngDetDataLineDO.getMasId())).collect(Collectors.toList());
                        Assert.notEmpty(finAccEngDetDataLineDOListItem, (String)"\u67e5\u4e0d\u5230\u6570\u636e\u6620\u5c04", (Object[])new Object[0]);
                        HashMap saveMap = new HashMap();
                        for (FinAccEngDetDataLineDO finAccEngDetDataLineDO2 : finAccEngDetDataLineDOListItem) {
                            if (!this.checkConstant(finAccEngDetDataLineDO2, docNum, finAccountEngineParam, finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap)) {
                                return;
                            }
                            if (!this.checkColumn(finAccEngDetDataLineDO2, map, docNum, finAccountEngineParam, finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap)) {
                                return;
                            }
                            if (!this.checkFastCode(finAccEngDetDataLineDO2, finAccountEngineCustomDO, map, docNum, finAccountEngineParam, finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap)) {
                                return;
                            }
                            if (!this.checkFlexible(finAccEngDetDataLineDO2, finAccountEngineCustomDO, docNum, finAccountEngineParam, finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap)) {
                                return;
                            }
                            if (this.checkAccountPeriod(finAccEngDetDataLineDO2, map, finAccountEngineCustomDO, ouCode, docNum, finAccountEngineParam, finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap)) continue;
                            return;
                        }
                        saveMapList.add(saveMap);
                    }
                }
            }
        }
        catch (Exception e) {
            this.saveFinJournalLog(docNum, e.getMessage());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean checkFinSetOfBookOu(FinAccountEngineCustomDO finAccountEngineCustomDO, String ouCode, String docNum, FinAccountEngineParam finAccountEngineParam, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO) {
        String sobCode = finAccEngDetDataDO.getSobCode();
        FinSetOfBookDO finSetOfBookDOResult = finAccountEngineCustomDO.getFinSetOfBookDOList().stream().filter(finSetOfBookDO -> finSetOfBookDO.getSobCode().equals(sobCode)).findFirst().orElse(null);
        Assert.notNull((Object)finSetOfBookDOResult, (String)"\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u8d26\u5957", (Object[])new Object[0]);
        List finSetOfBookOuDOListItem = finAccountEngineCustomDO.getFinSetOfBookOuDOList().stream().filter(finSetOfBookOuDO -> finSetOfBookDOResult.getId().equals(finSetOfBookOuDO.getMasId())).collect(Collectors.toList());
        Assert.notNull(finSetOfBookOuDOListItem, (String)"\u67e5\u4e0d\u5230\u8d26\u5957\u516c\u53f8", (Object[])new Object[0]);
        FinSetOfBookOuDO finSetOfBookOuDOResult = finSetOfBookOuDOListItem.stream().filter(finSetOfBookOuDO -> ouCode.equals(finSetOfBookOuDO.getOuCode())).findFirst().orElse(null);
        if (finSetOfBookOuDOResult == null) {
            this.saveFinJournalLog(docNum, String.format("{}\uff0c{},{},{}\u65e0\u5206\u914d\u6b64\u8d26\u5957", finAccountEngineParam.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), ouCode));
            return false;
        }
        return true;
    }

    private FinAccountEngineCustomDO queryData(FinAccountEngineParam finAccountEngineParam) {
        FinEventTableDO finEventTableDO = this.finEventTableRepo.findByEventTableAndStatus(finAccountEngineParam.getEventTable(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        Assert.notNull((Object)finEventTableDO, (String)"\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4e8b\u4ef6\u8868\u5355", (Object[])new Object[0]);
        List<FinEventTableLineDO> finEventTableLineDOList = this.finEventTableLineRepo.findAllByMasId(finEventTableDO.getId());
        Assert.notEmpty(finEventTableLineDOList, (String)"\u67e5\u4e0d\u5230\u4e8b\u4ef6\u8868\u5355\u660e\u7ec6", (Object[])new Object[0]);
        List<FinEventTableConditionDO> finEventTableConditionDOList = this.finEventTableConditionRepo.findAllByMasId(finEventTableDO.getId());
        FinAccountEngineDO finAccountEngineDO = this.finAccountEngineRepo.findByIdAndStatus(finAccountEngineParam.getId(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        Assert.notNull((Object)finAccountEngineDO, (String)"\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4f1a\u8ba1\u5f15\u64ce", (Object[])new Object[0]);
        List<FinAccountEngineDetailsDO> finAccountEngineDetailsDOList = this.finAccountEngineDetailsRepo.findAllByMasIdAndActiveFlag(finAccountEngineParam.getId(), Boolean.TRUE).stream().sorted(Comparator.comparing(FinAccountEngineDetailsDO::getSerialNum).reversed()).collect(Collectors.toList());
        Assert.notEmpty(finAccountEngineDetailsDOList, (String)"\u67e5\u4e0d\u5230\u542f\u7528\u7684\u4f1a\u8ba1\u5f15\u64ce\u660e\u7ec6", (Object[])new Object[0]);
        List<Long> finAccountEngineDetailsDOIds = finAccountEngineDetailsDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<FinAccEngDetConditionDO> finAccEngDetConditionDOList = this.finAccEngDetConditionRepo.findAllByMasIdIn(finAccountEngineDetailsDOIds);
        List<FinAccEngDetDataDO> finAccEngDetDataDOList = this.finAccEngDetDataRepo.findAllByMasIdIn(finAccountEngineDetailsDOIds).stream().sorted(Comparator.comparing(FinAccEngDetDataDO::getSerialNum).reversed()).collect(Collectors.toList());
        Assert.notEmpty(finAccEngDetDataDOList, (String)"\u67e5\u4e0d\u5230\u6570\u636e\u884c\u8be6\u60c5", (Object[])new Object[0]);
        List<Long> finAccEngDetDataDOIds = finAccEngDetDataDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<FinAccEngDetDataLineDO> finAccEngDetDataLineDOList = this.finAccEngDetDataLineRepo.findAllByMasIdIn(finAccEngDetDataDOIds);
        Assert.notEmpty(finAccEngDetDataLineDOList, (String)"\u67e5\u4e0d\u5230\u6570\u636e\u6620\u5c04", (Object[])new Object[0]);
        List<String> fastCodes = finAccEngDetDataLineDOList.stream().map(FinAccEngDetDataLineDO::getFastCode).collect(Collectors.toList());
        List<FinFastCodeDO> finFastCodeDOList = this.finFastCodeRepoProc.findAllByFastCodeInAndStatus(fastCodes, UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<Long> finFastCodeDOIds = finFastCodeDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<FinFastCodeLineDO> finFastCodeLineDOList = this.finFastCodeLineRepoProc.findByMasIdIn(finFastCodeDOIds);
        List<String> sobCodes = finAccEngDetDataDOList.stream().map(FinAccEngDetDataDO::getSobCode).collect(Collectors.toList());
        List<FinSetOfBookDO> finSetOfBookDOList = this.finSetOfBookRepo.findAllBySobCodeInAndStatus(sobCodes, UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        Assert.notEmpty(finSetOfBookDOList, (String)"\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u5e10\u5957", (Object[])new Object[0]);
        List<Long> finSetOfBookDOIds = finSetOfBookDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<FinSetOfBookOuDO> finSetOfBookOuDOList = this.finSetOfBookOuRepo.findAllByMasIdIn(finSetOfBookDOIds);
        Assert.notEmpty(finSetOfBookOuDOList, (String)"\u67e5\u4e0d\u5230\u5e10\u5957\u5e10\u5957\u516c\u53f8", (Object[])new Object[0]);
        List<FinSetOfBookLineDO> finSetOfBookLineDOList = this.finSetOfBookLineRepo.findAllByMasIdIn(finSetOfBookDOIds);
        Assert.notEmpty(finSetOfBookLineDOList, (String)"\u67e5\u4e0d\u5230\u5e10\u5957\u660e\u7ec6", (Object[])new Object[0]);
        List<FinSobAccountPeriodDO> finSobAccountPeriodDOList = this.finSobAccountPeriodRepo.findAllByStatus(UdcEnum.ACCOUNT_PERIOD_CONTROL_STATUS_OPEN.getValueCode());
        List<String> flexibleCodes = finSetOfBookLineDOList.stream().filter(finSetOfBookLineDO -> StringUtils.isNotEmpty((CharSequence)finSetOfBookLineDO.getFlexibleCode())).map(FinSetOfBookLineDO::getFlexibleCode).collect(Collectors.toList());
        List<FinFlexibleDO> finFlexibleDOList = this.finFlexibleRepoProc.findAllByFlexibleCodeInAndStatus(flexibleCodes, UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<Long> finSetOfBookLineDOIds = finFlexibleDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<FinFlexibleValueDO> finFlexibleValueDOList = this.finFlexibleValueRepoProc.findByMasIdInAndValidTime(finSetOfBookLineDOIds, LocalDateTime.now());
        FinAccountEngineCustomDO finAccountEngineCustomDO = new FinAccountEngineCustomDO();
        finAccountEngineCustomDO.setFinEventTableDO(finEventTableDO);
        finAccountEngineCustomDO.setFinEventTableLineDOList(finEventTableLineDOList);
        finAccountEngineCustomDO.setFinEventTableConditionDOList(finEventTableConditionDOList);
        finAccountEngineCustomDO.setFinAccountEngineDetailsDOList(finAccountEngineDetailsDOList);
        finAccountEngineCustomDO.setFinAccEngDetConditionDOList(finAccEngDetConditionDOList);
        finAccountEngineCustomDO.setFinAccEngDetDataDOList(finAccEngDetDataDOList);
        finAccountEngineCustomDO.setFinAccEngDetDataLineDOList(finAccEngDetDataLineDOList);
        finAccountEngineCustomDO.setFinFastCodeDOList(finFastCodeDOList);
        finAccountEngineCustomDO.setFinFastCodeLineDOList(finFastCodeLineDOList);
        finAccountEngineCustomDO.setFinSetOfBookDOList(finSetOfBookDOList);
        finAccountEngineCustomDO.setFinSetOfBookOuDOList(finSetOfBookOuDOList);
        finAccountEngineCustomDO.setFinSetOfBookLineDOList(finSetOfBookLineDOList);
        finAccountEngineCustomDO.setFinSobAccountPeriodDOList(finSobAccountPeriodDOList);
        finAccountEngineCustomDO.setFinFlexibleDOList(finFlexibleDOList);
        finAccountEngineCustomDO.setFinFlexibleValueDOList(finFlexibleValueDOList);
        return finAccountEngineCustomDO;
    }

    private boolean checkConstant(FinAccEngDetDataLineDO finAccEngDetDataLineDO, String docNum, FinAccountEngineParam finAccountEngineParam, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO, Map saveMap) {
        if (UdcEnum.SOURCE_TYPE_CONSTANT.getValueCode().equals(finAccEngDetDataLineDO.getSourceType())) {
            if (StringUtils.isEmpty((CharSequence)finAccEngDetDataLineDO.getConstant())) {
                this.saveFinJournalLog(docNum, String.format("{},{},{},{}\u5e38\u6570\u51fa\u9519", finAccountEngineParam.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), finAccEngDetDataLineDO.getColumnName()));
                return false;
            }
            this.put(saveMap, finAccEngDetDataLineDO.getColumnName(), finAccEngDetDataLineDO.getConstant());
        }
        return true;
    }

    private boolean checkColumn(FinAccEngDetDataLineDO finAccEngDetDataLineDO, Map result, String docNum, FinAccountEngineParam finAccountEngineParam, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO, Map saveMap) {
        if (UdcEnum.SOURCE_TYPE_COLUMN.getValueCode().equals(finAccEngDetDataLineDO.getSourceType())) {
            if (result.get(finAccEngDetDataLineDO.getColumnSource()) == null) {
                this.saveFinJournalLog(docNum, String.format("{},{},{},{}\u5217\u6765\u6e90\u5b57\u6bb5\u51fa\u9519", finAccountEngineParam.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), finAccEngDetDataLineDO.getColumnName()));
                return false;
            }
            this.put(saveMap, finAccEngDetDataLineDO.getColumnName(), finAccEngDetDataLineDO.getColumnSource());
        }
        return true;
    }

    private boolean checkFastCode(FinAccEngDetDataLineDO finAccEngDetDataLineDO, FinAccountEngineCustomDO finAccountEngineCustomDO, Map result, String docNum, FinAccountEngineParam finAccountEngineParam, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO, Map saveMap) {
        if (UdcEnum.SOURCE_TYPE_FAST_CODE.getValueCode().equals(finAccEngDetDataLineDO.getSourceType())) {
            FinFastCodeDO finFastCodeDOResult = finAccountEngineCustomDO.getFinFastCodeDOList().stream().filter(finFastCodeDO -> finFastCodeDO.getFastCode().equals(finAccEngDetDataLineDO.getFastCode())).findFirst().orElse(null);
            Assert.notNull((Object)finFastCodeDOResult, (String)"\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u5feb\u7801", (Object[])new Object[0]);
            List finFastCodeLineDOListItem = finAccountEngineCustomDO.getFinFastCodeLineDOList().stream().filter(finFastCodeLineDO -> finFastCodeDOResult.getId().equals(finFastCodeLineDO.getMasId())).collect(Collectors.toList());
            Assert.notNull((Object)finFastCodeDOResult, (String)"\u6ca1\u67e5\u5230\u5feb\u7801\u660e\u7ec6", (Object[])new Object[0]);
            FinFastCodeLineDO finFastCodeLineDOResult = finFastCodeLineDOListItem.stream().filter(finFastCodeLineDO -> {
                if (StringUtils.isNotEmpty((CharSequence)finFastCodeLineDO.getConditionOne()) && !finFastCodeLineDO.getConditionOneValue().equals(result.get(finFastCodeLineDO.getConditionOne()))) {
                    return false;
                }
                if (StringUtils.isNotEmpty((CharSequence)finFastCodeLineDO.getConditionTwo()) && !finFastCodeLineDO.getConditionTwoValue().equals(result.get(finFastCodeLineDO.getConditionTwo()))) {
                    return false;
                }
                return !StringUtils.isNotEmpty((CharSequence)finFastCodeLineDO.getConditionThree()) || finFastCodeLineDO.getConditionThreeValue().equals(result.get(finFastCodeLineDO.getConditionThree()));
            }).findFirst().orElse(null);
            if (finFastCodeLineDOResult == null) {
                this.saveFinJournalLog(docNum, String.format("{},{},{},{}\u5feb\u7801\u51fa\u9519", finAccountEngineParam.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), finAccEngDetDataLineDO.getColumnName()));
                return false;
            }
            if ("\u8f93\u51fa1".equals(finAccEngDetDataLineDO.getOutputColumn())) {
                saveMap.put(StringUtil.convertToCamelCase(finAccEngDetDataLineDO.getColumnName()), finFastCodeLineDOResult.getOutputOne());
            }
            if ("\u8f93\u51fa2".equals(finAccEngDetDataLineDO.getOutputColumn())) {
                saveMap.put(StringUtil.convertToCamelCase(finAccEngDetDataLineDO.getColumnName()), finFastCodeLineDOResult.getOutputTwo());
            }
            if ("\u8f93\u51fa3".equals(finAccEngDetDataLineDO.getOutputColumn())) {
                saveMap.put(StringUtil.convertToCamelCase(finAccEngDetDataLineDO.getColumnName()), finFastCodeLineDOResult.getOutputThree());
            }
        }
        return true;
    }

    private boolean checkFlexible(FinAccEngDetDataLineDO finAccEngDetDataLineDO, FinAccountEngineCustomDO finAccountEngineCustomDO, String docNum, FinAccountEngineParam finAccountEngineParam, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO, Map saveMap) {
        if (UdcEnum.SOURCE_TYPE_FLEXIBLE.getValueCode().equals(finAccEngDetDataLineDO.getSourceType())) {
            FinFlexibleValueDO finFlexibleValueDOResult = finAccountEngineCustomDO.getFinFlexibleValueDOList().stream().filter(finFlexibleValueDO -> finFlexibleValueDO.getFlexibleValueCode().equals(finAccEngDetDataLineDO.getFlexibleCode())).findFirst().orElse(null);
            Assert.notNull((Object)finFlexibleValueDOResult, (String)"\u67e5\u4e0d\u5230\u6709\u6548\u7684\u503c\u96c6\u660e\u7ec6", (Object[])new Object[0]);
            if (finFlexibleValueDOResult == null) {
                this.saveFinJournalLog(docNum, String.format("{},{},{},{}\u503c\u96c6\u51fa\u9519", finAccountEngineParam.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), finAccEngDetDataLineDO.getColumnName()));
                return false;
            }
            this.put(saveMap, finAccEngDetDataLineDO.getColumnName(), finFlexibleValueDOResult.getFlexibleValueName());
        }
        return true;
    }

    private boolean checkAccountPeriod(FinAccEngDetDataLineDO finAccEngDetDataLineDO, Map result, FinAccountEngineCustomDO finAccountEngineCustomDO, String ouCode, String docNum, FinAccountEngineParam finAccountEngineParam, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO, Map saveMap) {
        if (UdcEnum.SOURCE_TYPE_ACCOUNT_PERIOD.getValueCode().equals(finAccEngDetDataLineDO.getSourceType())) {
            Assert.notNull(result.get(finAccEngDetDataLineDO.getColumnSource()), (String)"\u4f1a\u8ba1\u671f\u95f4\u4e3a\u7a7a", (Object[])new Object[0]);
            LocalDateTime localDateTime = (LocalDateTime)result.get(finAccEngDetDataLineDO.getColumnSource());
            String sobCode = finAccEngDetDataDO.getSobCode();
            FinSetOfBookDO finSetOfBookDOResult = finAccountEngineCustomDO.getFinSetOfBookDOList().stream().filter(finSetOfBookDO -> finSetOfBookDO.getSobCode().equals(sobCode)).findFirst().orElse(null);
            Assert.notNull((Object)finSetOfBookDOResult, (String)"\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u8d26\u5957", (Object[])new Object[0]);
            FinSobAccountPeriodDO finSobAccountPeriodDOResult = finAccountEngineCustomDO.getFinSobAccountPeriodDOList().stream().filter(finSobAccountPeriodDO -> finSetOfBookDOResult.getSobCode().equals(finSobAccountPeriodDO.getSobCode()) && ouCode.equals(finSobAccountPeriodDO.getOuCode()) && UdcEnum.ACCOUNT_PERIOD_CONTROL_STATUS_OPEN.getValueCode().equals(finSobAccountPeriodDO.getStatus()) && localDateTime.compareTo(finSobAccountPeriodDO.getActiveStartTime()) >= 0 && localDateTime.compareTo(finSobAccountPeriodDO.getActiveEndTime()) <= 0).findFirst().orElse(null);
            if (finSobAccountPeriodDOResult == null) {
                this.saveFinJournalLog(docNum, String.format("{},{},{},{}\u4f1a\u8ba1\u671f\u95f4\u51fa\u9519", finAccountEngineParam.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), finAccEngDetDataLineDO.getColumnName()));
                return false;
            }
            this.put(saveMap, finAccEngDetDataLineDO.getColumnName(), finSobAccountPeriodDOResult.getPeriodStyle());
        }
        return true;
    }

    private void checkGenerateJournalParam(FinAccountEngineParam finAccountEngineParam) {
        Assert.notEmpty((CharSequence)finAccountEngineParam.getEventTable(), (String)"\u4e8b\u4ef6\u8868\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)finAccountEngineParam.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void put(Map map, String key, String value) {
        map.put(StringUtil.convertToCamelCase(key), value);
    }

    private void saveFinJournal(FinAccountEngineParam finAccountEngineParam, List<Map> saveMapList) {
        if (CollectionUtils.isEmpty(saveMapList)) {
            return;
        }
        FinAccountEngineDO finAccountEngineDO = this.finAccountEngineRepo.findAllById(finAccountEngineParam.getId());
        Assert.notNull((Object)finAccountEngineDO, (String)"\u67e5\u4e0d\u5230\u4f1a\u8ba1\u5f15\u64ce", (Object[])new Object[0]);
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            connection = DriverManager.getConnection(String.format("jdbc:mysql://%s:%s/%s", finAccountEngineDO.getJournalHost(), finAccountEngineDO.getJournalPort(), finAccountEngineDO.getJournalDatabase()), finAccountEngineDO.getJournalUser(), finAccountEngineDO.getJournalPassword());
            String sql = this.buildSql(finAccountEngineDO, saveMapList);
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.execute();
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String buildSql(FinAccountEngineDO finAccountEngineDO, List<Map> saveMapList) {
        List values = saveMapList.stream().map(map -> "(".concat(StringUtils.join(map.values(), (String)",")).concat(")")).collect(Collectors.toList());
        String sql = "insert".concat(" ").concat("into").concat(" ").concat(finAccountEngineDO.getJournalTable()).concat(" ").concat("(").concat(StringUtils.join(saveMapList.get(0).keySet(), (String)",")).concat(")").concat(" ").concat("values").concat(StringUtils.join(values, (String)","));
        return sql;
    }

    private void saveFinJournalLog(String docNum, String log) {
        FinJournalLogDO finJournalLogDo = new FinJournalLogDO();
        finJournalLogDo.setDocNum(docNum);
        finJournalLogDo.setLog(log);
        this.finJournalLogRepo.save(finJournalLogDo);
    }

    public FinAccountEngineServiceImpl(FinAccountEngineRepo finAccountEngineRepo, FinAccountEngineRepoProc finAccountEngineRepoProc, FinAccountEngineDetailsRepo finAccountEngineDetailsRepo, FinAccEngDetConditionRepo finAccEngDetConditionRepo, FinAccEngDetDataRepo finAccEngDetDataRepo, FinAccEngDetDataLineRepo finAccEngDetDataLineRepo, FinEventTableRepo finEventTableRepo, FinEventTableLineRepo finEventTableLineRepo, FinEventTableConditionRepo finEventTableConditionRepo, FinJournalLogService finJournalLogService, FinJournalLogRepo finJournalLogRepo, FinSetOfBookOuRepo finSetOfBookOuRepo, FinSetOfBookRepo finSetOfBookRepo, FinSetOfBookRepoProc finSetOfBookRepoProc, FinSetOfBookLineRepo finSetOfBookLineRepo, FinFastCodeRepo finFastCodeRepo, FinFastCodeLineRepo finFastCodeLineRepo, FinFastCodeLineRepoProc finFastCodeLineRepoProc, FinFastCodeRepoProc finFastCodeRepoProc, FinFlexibleRepo finFlexibleRepo, FinFlexibleRepoProc finFlexibleRepoProc, FinFlexibleValueRepo finFlexibleValueRepo, FinFlexibleValueRepoProc finFlexibleValueRepoProc, FinSobAccountPeriodRepo finSobAccountPeriodRepo, FinJournalRepo finJournalRepo) {
        this.finAccountEngineRepo = finAccountEngineRepo;
        this.finAccountEngineRepoProc = finAccountEngineRepoProc;
        this.finAccountEngineDetailsRepo = finAccountEngineDetailsRepo;
        this.finAccEngDetConditionRepo = finAccEngDetConditionRepo;
        this.finAccEngDetDataRepo = finAccEngDetDataRepo;
        this.finAccEngDetDataLineRepo = finAccEngDetDataLineRepo;
        this.finEventTableRepo = finEventTableRepo;
        this.finEventTableLineRepo = finEventTableLineRepo;
        this.finEventTableConditionRepo = finEventTableConditionRepo;
        this.finJournalLogService = finJournalLogService;
        this.finJournalLogRepo = finJournalLogRepo;
        this.finSetOfBookOuRepo = finSetOfBookOuRepo;
        this.finSetOfBookRepo = finSetOfBookRepo;
        this.finSetOfBookRepoProc = finSetOfBookRepoProc;
        this.finSetOfBookLineRepo = finSetOfBookLineRepo;
        this.finFastCodeRepo = finFastCodeRepo;
        this.finFastCodeLineRepo = finFastCodeLineRepo;
        this.finFastCodeLineRepoProc = finFastCodeLineRepoProc;
        this.finFastCodeRepoProc = finFastCodeRepoProc;
        this.finFlexibleRepo = finFlexibleRepo;
        this.finFlexibleRepoProc = finFlexibleRepoProc;
        this.finFlexibleValueRepo = finFlexibleValueRepo;
        this.finFlexibleValueRepoProc = finFlexibleValueRepoProc;
        this.finSobAccountPeriodRepo = finSobAccountPeriodRepo;
        this.finJournalRepo = finJournalRepo;
    }
}

