/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.config;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountAutoRepaymentService;
import com.elitesland.fin.application.service.creditaccount.CreditAccountService;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.application.service.limitadjustorder.LimitAdjustOrderService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JobHandler {
    private static final Logger log = LoggerFactory.getLogger(JobHandler.class);
    private final LimitAdjustOrderService limitAdjustOrderService;
    private final InvoiceAwaitService invoiceAwaitService;
    private final CreditAccountService creditAccountService;
    private final AccountService accountService;
    private final CreditAccountAutoRepaymentService creditAccountAutoRepaymentService;

    @XxlJob(value="expireLimitAdjustOrder")
    public ReturnT<String> expireLimitAdjustOrder(String param) {
        try {
            this.limitAdjustOrderService.expireLimitAdjustOrder();
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="activeLimitAdjustOrder")
    public ReturnT<String> activeLimitAdjustOrder(String param) {
        try {
            log.info("\u767b\u5f55\u4eba\u4fe1\u606f\uff1a{}", (Object)SecurityContextUtil.currentUser());
            this.limitAdjustOrderService.activeLimitAdjustOrder();
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="invoiceAwaitOrder")
    public ReturnT<String> invoiceAwaitOrder(String param) {
        try {
            this.invoiceAwaitService.invoiceAwaitOrder(param);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="creditAccountSnapshot")
    public ReturnT<String> creditAccountSnapshot(String param) {
        XxlJobLogger.log((String)"creditAccountSnapshot \u53c2\u6570:{}", (Object[])new Object[]{param});
        try {
            this.creditAccountService.creditAccountSnapshot(param);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="accountSnapshot")
    public ReturnT<String> accountSnapshot(String param) {
        XxlJobLogger.log((String)"accountSnapshot \u53c2\u6570:{}", (Object[])new Object[]{param});
        try {
            this.accountService.accountSnapshot(param);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @XxlJob(value="creditAccountAutoRepayment")
    public ReturnT<String> creditAccountAutoRepayment(String param) {
        XxlJobLogger.log((String)"\u4fe1\u7528\u8d26\u6237\u81ea\u52a8\u8fd8\u6b3e\u5b9a\u65f6\u4efb\u52a1 \u53c2\u6570:{}", (Object[])new Object[]{param});
        try {
            this.creditAccountAutoRepaymentService.creditAccountAutoRepayment(param);
        }
        catch (Exception e) {
            XxlJobLogger.log((String)("\u4fe1\u7528\u8d26\u6237\u81ea\u52a8\u8fd8\u6b3e\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u679c:============================" + e.getMessage()), (Object[])new Object[0]);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    public JobHandler(LimitAdjustOrderService limitAdjustOrderService, InvoiceAwaitService invoiceAwaitService, CreditAccountService creditAccountService, AccountService accountService, CreditAccountAutoRepaymentService creditAccountAutoRepaymentService) {
        this.limitAdjustOrderService = limitAdjustOrderService;
        this.invoiceAwaitService = invoiceAwaitService;
        this.creditAccountService = creditAccountService;
        this.accountService = accountService;
        this.creditAccountAutoRepaymentService = creditAccountAutoRepaymentService;
    }
}

