package com.elitesland.fin.application.convert.paymentperiod;

import com.elitesland.fin.application.facade.param.paymentperiod.AgingRangeDtlSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.AgingRangeDtlVO;
import com.elitesland.fin.domain.entity.paymentperiod.AgingRangeDtlDO;
import com.elitesland.fin.infr.dto.paymentperiod.AgingRangeDtlDTO;
import org.mapstruct.Mapper;
import org.mapstruct.ReportingPolicy;
import org.mapstruct.factory.Mappers;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/16
 * @Version 1.0
 * @Content:
 */
@Mapper(unmappedTargetPolicy = ReportingPolicy.IGNORE)
public interface AgingRangeDtlConvert {
    AgingRangeDtlConvert INSTANCE = Mappers.getMapper(AgingRangeDtlConvert.class);

    /**
     * saveVO转换DO
     *
     * @param saveVO 入参
     * @return DO
     */
    AgingRangeDtlDO saveVoToDo(AgingRangeDtlSaveParam saveVO);

    /**
     * DO转换RespVO
     *
     * @param dtlDO 入参
     * @return RespVO
     */
    AgingRangeDtlVO doToRespVo(AgingRangeDtlDO dtlDO);

    /**
     * DO转换DTO
     *
     * @param dtlDO 入参
     * @return DTO
     */
    AgingRangeDtlDTO doToDto(AgingRangeDtlDO dtlDO);

    /**
     * DTO转换RespVO
     *
     * @param dtlDTO 入参
     * @return RespVO
     */
    AgingRangeDtlVO dtoToRespVo(AgingRangeDtlDTO dtlDTO);

}
