package com.elitesland.fin.application.facade.vo.artype;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelParam;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.artype
 * @date 2022/4/11 14:32
 */
@Data
public class ArTypeVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = -7315283167724643321L;
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("应收单类型代码")
    private String arTypeCode;

    @ApiModelProperty("应收单类型名称")
    private String arTypeName;

    @ApiModelProperty("启用标志")
    private Boolean enableFlag;

    @ApiModelProperty("自动审核")
    private Boolean autoAudit;

    @ApiModelProperty("默认")
    private Boolean defaultFlag;

    @ApiModelProperty("来源单据 [UDC]yst-supp:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String sourceDoc;
    @ApiModelProperty(value = "来源单据名称")
    private String sourceDocName;

    @ApiModelProperty("来源单据类型 [UDC]yst-supp:DOC_TYPE")
    @SysCode(sys = "yst-supp", mod = "DOC_TYPE")
    private String sourceDocType;
    @ApiModelProperty(value = "来源单据类型名称")
    private String sourceDocTypeName;

    @ApiModelProperty("来源单据状态 [UDC]yst-supp:DOC_STATUS")
    @SysCode(sys = "yst-supp", mod = "DOC_STATUS")
    private String sourceDocStatus;
    @ApiModelProperty(value = "来源单据状态名称")
    private String sourceDocStatusName;

    @ApiModelProperty("应收单类型明细")
    private List<ArTypeDtlVO> dtlList;
}
