package com.elitesland.fin.application.web.invoice;

import com.cloudt.apm.common.response.ApiResult;
import com.elitesland.fin.application.facade.param.invoice.ApplyRePushParam;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDtlVO;
import com.elitesland.fin.application.service.invoice.InvoiceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhiMing
 */
@Slf4j
@Api(tags = "发票申请单")
@RestController
@RequestMapping(value = "/inv", produces = MediaType.APPLICATION_JSON_VALUE)
@AllArgsConstructor
public class InvoiceController {

    public final InvoiceService invoiceService;

    @ApiOperation("新增发票申请单")
    @PostMapping("/create")
    public ApiResult<Long> create(@RequestBody @Validated InvoiceApplyParam param) {
        log.info("[FOS-INV] create apply, param={}", param);
        return ApiResult.ok(invoiceService.create(param));
    }

    @ApiOperation("重新推送")
    @PostMapping("/rePushInvoice")
    public ApiResult<String> rePushInvoice(@RequestBody @Validated ApplyRePushParam param) {
        log.info("[FOS-INV] rePush apply, param={}", param);
        try {
            invoiceService.rePush(param);
        } catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
        return ApiResult.ok();
    }

    @ApiOperation("重新开票")
    @GetMapping("/redraft")
//    @NoRepeatSubmit(expireSeconds = 3)
    public ApiResult<Long> redraft(String applyNo) {
        log.info("[FOS-INV] redraft apply, param={}", applyNo);
        Long redraftId = invoiceService.redraft(applyNo);
        return ApiResult.ok(redraftId);
    }

    @ApiOperation("红冲申请")
    @PostMapping("/red")
    public ApiResult<String> red(@RequestBody @Validated InvoiceApplyParam param) {
        log.info("[FOS-INV] red apply, param={}", param);
        try {
            invoiceService.create(param);
        } catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
        return ApiResult.ok();
    }

    @ApiOperation("开票结果查询")
    @PostMapping("/getBlueResult")
    public ApiResult<?> getBlueResult(@RequestBody List<Long> saleInvIdList) {
        log.info("[FOS-INV] getBlueResult, saleInvIdList={}", saleInvIdList);
        try {
            invoiceService.getBlueResult(saleInvIdList);
        } catch (Exception e) {
            log.error("[FOS-INV] getBlueResult error", e);
            return ApiResult.fail(e.getMessage());
        }
        return ApiResult.ok();
    }

//
//    @PostMapping("/page")
//    @ApiOperation("分页查询销售发票列表")
//    public ApiResult<PagingVO<SaleInvoiceVO>> page(@RequestBody SaleInvPageParam param) {
//        PagingVO<SaleInvoiceVO> res = invoiceService.page(param);
//        return ApiResult.ok(res);
//    }

    /**
     * 查询开票明细列表
     *
     * @param masId 主表ID，用于查询对应的开票明细
     * @return 返回开票明细列表的API结果，其中包含开票明细列表
     */
    @GetMapping({"/getDtlList"})
    @ApiOperation("查询开票明细列表")
    public ApiResult<List<SaleInvDtlVO>> getList(Long masId) {
        // 调用服务层方法，根据主表ID查询销售明细列表
        List<SaleInvDtlVO> res = this.invoiceService.getDtlList(masId);
        // 返回查询结果
        return ApiResult.ok(res);
    }
}
