/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infinity.aisino.service;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplySaveParam;
import com.elitesland.fin.infinity.aisino.utils.InvoiceIssueUtil;
import com.elitesland.fin.infinity.aisino.vo.param.account.InvoiceBlueApplyParam;
import com.elitesland.fin.infinity.aisino.vo.param.account.InvoiceBlueApplyRequest;
import com.elitesland.fin.infinity.aisino.vo.param.account.InvoiceBlueResultParam;
import com.elitesland.fin.infinity.aisino.vo.param.account.ItemDetail;
import com.elitesland.fin.param.saleinv.InvoiceDetailSaveParam;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AisinoApplyPayloadService {
    private static final Logger log = LoggerFactory.getLogger(AisinoApplyPayloadService.class);
    @Value(value="${aisino.encrypt.key:Y#Y*B!PC}")
    private String encryptKey;

    public InvoiceBlueApplyParam blueApplyInitial(InvoiceApplySaveParam saveParam) {
        InvoiceBlueApplyParam row = new InvoiceBlueApplyParam();
        row.setFPQQLSH(saveParam.getCustTaxNo() + saveParam.getApplyNo());
        InvoiceBlueApplyRequest request = new InvoiceBlueApplyRequest();
        request.setDJH(saveParam.getApplyNo());
        request.setGMFMC(saveParam.getInvCustCode());
        request.setGMFSH(saveParam.getCustTaxNo());
        request.setGMFYH(saveParam.getInvBankNo());
        request.setGMFYHZH(saveParam.getBankAccount());
        request.setGMFRYXZ("1");
        request.setKPLX("0");
        if (saveParam.getInvType().equals("VANA")) {
            request.setFPZLDM("01");
        } else if (saveParam.getInvType().equals("VANSP")) {
            request.setFPZLDM("02");
        }
        request.setJSHJ(this.scale(saveParam.getTotalAmt()));
        if (!Objects.equals(request.getGMFRYXZ(), "1")) {
            request.setBZ("\u8d2d\u4e70\u65b9\u5730\u5740\uff1a" + saveParam.getCustAdd() + ";\u7535\u8bdd\uff1a" + saveParam.getPhone() + ";\u8d2d\u65b9\u5f00\u6237\u94f6\u884c\uff1a" + saveParam.getCustBank() + ";\u94f6\u884c\u8d26\u53f7\uff1a" + saveParam.getCustBankAcc());
        }
        request.setXHFKHH(saveParam.getSaleBank());
        request.setXHFYHZH(saveParam.getSaleBankAcc());
        BigDecimal netAmt = BigDecimal.ZERO;
        BigDecimal taxAmt = BigDecimal.ZERO;
        ArrayList<ItemDetail> itemDetails = new ArrayList<ItemDetail>();
        int lineNo = 1;
        for (InvoiceDetailSaveParam detail : saveParam.getDetails()) {
            netAmt = netAmt.add(detail.getExclTaxAmt());
            taxAmt = taxAmt.add(detail.getTaxAmt());
            ItemDetail drow = new ItemDetail();
            drow.setXH(Integer.toString(lineNo));
            drow.setSPBM(detail.getItemCode());
            drow.setSPMC(detail.getItemName());
            drow.setSPJM(detail.getTaxCode());
            drow.setGGXH(detail.getItemType());
            drow.setJLDW(detail.getUom());
            drow.setSLV(detail.getTaxRate().toString());
            drow.setSL(Objects.isNull(detail.getQty()) ? null : detail.getQty().toString());
            drow.setDJ(this.scale(detail.getPrice()));
            drow.setJE(this.scale(detail.getTotalAmt()));
            drow.setSE(this.scale(detail.getTaxAmt()));
            drow.setKCE("0");
            if (detail.getDiscountAmt() != null && detail.getDiscountAmt().compareTo(BigDecimal.ZERO) > 0) {
                drow.setHXZ("2");
            } else {
                drow.setHXZ("0");
            }
            drow.setHSBZ("1");
            itemDetails.add(drow);
            ++lineNo;
            if (detail.getDiscountAmt() == null || detail.getDiscountAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
            ItemDetail discountRow = new ItemDetail();
            discountRow.setXH(Integer.toString(lineNo));
            discountRow.setSPBM(detail.getItemCode());
            discountRow.setSPMC(detail.getItemName());
            discountRow.setSPJM(detail.getTaxCode());
            discountRow.setGGXH("");
            discountRow.setJLDW("");
            discountRow.setSLV(detail.getTaxRate().toString());
            discountRow.setSL("");
            discountRow.setDJ("");
            discountRow.setJE(this.scale(detail.getTotalAmt().negate()));
            discountRow.setSE(this.scale(detail.getTaxAmt().negate()));
            discountRow.setKCE("");
            discountRow.setHXZ("1");
            itemDetails.add(discountRow);
            ++lineNo;
        }
        request.setHJJE(this.scale(netAmt));
        request.setHJSE(this.scale(taxAmt));
        request.setMXLIST(itemDetails);
        row.setREQUEST(request);
        return row;
    }

    public InvoiceBlueResultParam getBlueResult(String applyNo, LocalDateTime applyTime) {
        InvoiceBlueResultParam result = new InvoiceBlueResultParam();
        result.setFPHM(applyNo);
        result.setKPRQ(applyTime.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        return result;
    }

    public String encrypt(String row) {
        return this.getEncryptedData(JSONObject.toJSONString((Object)row));
    }

    private String getEncryptedData(String row) {
        byte[] encryptedBytes = InvoiceIssueUtil.encrypt(row.getBytes(), this.encryptKey);
        if (encryptedBytes == null) {
            log.error("\u52a0\u5bc6\u5931\u8d25,\u52a0\u5bc6\u7ed3\u679c\u4e3a\u7a7a\uff0c\u52a0\u5bc6\u6570\u636e:{}", (Object)row);
            throw new BusinessException("\u52a0\u5bc6\u5931\u8d25,\u52a0\u5bc6\u7ed3\u679c\u4e3a\u7a7a\uff0c\u52a0\u5bc6\u6570\u636e:" + row);
        }
        return InvoiceIssueUtil.byteToHexString(encryptedBytes);
    }

    private String scale(BigDecimal num) {
        return num.setScale(2, RoundingMode.HALF_UP).toString();
    }
}

