/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infinity.aisino.service;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.facade.param.invoice.InvoiceApplyParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceSaveVO;
import com.elitesland.fin.application.service.invoice.InvoiceApplyService;
import com.elitesland.fin.application.service.invoice.InvoiceAwaitService;
import com.elitesland.fin.domain.entity.invoiceredraft.InvoiceRedraftDO;
import com.elitesland.fin.domain.entity.invoiceredraft.QInvoiceRedraftDO;
import com.elitesland.fin.domain.entity.saleinv.SaleInvDO;
import com.elitesland.fin.dto.invoice.InvoiceApplyRpcDTO;
import com.elitesland.fin.infinity.aisino.entity.AisinoLogDO;
import com.elitesland.fin.infinity.aisino.enums.RedStateEnum;
import com.elitesland.fin.infinity.aisino.repo.AisinoLogRepo;
import com.elitesland.fin.infinity.aisino.service.AisinoApplyPayloadService;
import com.elitesland.fin.infinity.aisino.service.AisinoService;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoApplyPayload;
import com.elitesland.fin.infinity.aisino.vo.param.invoice.InvoiceMain;
import com.elitesland.fin.infinity.aisino.vo.param.notice.InvoiceParam;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoApplyRespVO;
import com.elitesland.fin.infinity.aisino.vo.resp.AisinoRespVO;
import com.elitesland.fin.infinity.http.RestClient;
import com.elitesland.fin.infinity.http.param.HttpParam;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDtlDTO;
import com.elitesland.fin.infr.repo.invoiceredraft.InvoiceRedraftRepo;
import com.elitesland.fin.infr.repo.saleinv.SaleInvDtlRepoProc;
import com.elitesland.fin.infr.repo.saleinv.SaleInvRepo;
import com.elitesland.fin.param.saleinv.InvoiceSaveParam;
import com.elitesland.fin.utils.BeanUtils;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import com.saobei.open.sdk.util.HttpClientUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class AisinoServiceImpl
implements AisinoService {
    private static final Logger log = LoggerFactory.getLogger(AisinoServiceImpl.class);
    private final RestClient restClient;
    private final AisinoLogRepo aisinoLogRepo;
    private final SaleInvRepo saleInvRepo;
    private final SaleInvDtlRepoProc saleInvDtlRepoProc;
    private final JPAQueryFactory jpaQueryFactory;
    private final QInvoiceRedraftDO qdo = QInvoiceRedraftDO.invoiceRedraftDO;
    private final TaskExecutor taskExecutor;
    @Autowired
    @Lazy
    private InvoiceAwaitService invoiceAwaitService;
    @Autowired
    private InvoiceRedraftRepo invoiceRedraftRepo;
    private final InvoiceApplyService invoiceApplyService;
    private final AisinoApplyPayloadService aisinoApplyPayloadService;
    @Value(value="${aisino.api.url:http://221.234.42.184:9236}")
    private String baseUrl;

    @Override
    public void addLog(String type, String name, String param) {
        AisinoLogDO xforceLog = new AisinoLogDO();
        xforceLog.setRequestType(type);
        xforceLog.setRequestTypeName(name);
        xforceLog.setRequestParam(param);
        this.aisinoLogRepo.save(xforceLog);
    }

    @Override
    public AisinoApplyRespVO orderUploadApply(AisinoApplyPayload payload) {
        Map<String, Object> requestBody = BeanUtils.beanToMap(payload, new String[0]);
        String url = this.baseUrl + "/openapi/qd/qpt/Kp_Fpkj";
        log.info("\u84dd\u7968\u7533\u8bf7\u5730\u5740\uff1a{},\u5165\u53c2: {}", (Object)url, (Object)BeanUtils.toJsonStr(requestBody));
        String jsonString = JSON.toJSONString((Object)payload);
        this.addLog("XF_BIZ_ORDER_UPLOAD", "\u822a\u4fe1\u5f00\u7968\u4e0a\u4f20\u63a5\u53e3\uff1a\u53c2\u6570", jsonString);
        String responseStr = null;
        try {
            responseStr = HttpClientUtil.post((String)url, (String)jsonString, (int)8000, (String)"application/json", (String)"utf-8");
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        this.addLog("XF_BIZ_ORDER_UPLOAD", "\u822a\u4fe1\u5f00\u7968\u4e0a\u4f20\u63a5\u53e3\uff1a\u7ed3\u679c", responseStr);
        AisinoApplyRespVO responseVO = (AisinoApplyRespVO)JSON.parseObject((String)responseStr, AisinoApplyRespVO.class);
        if (responseVO == null) {
            throw new BusinessException("\u822a\u4fe1\u5f00\u7968\u4e0a\u4f20\u54cd\u5e94\u4e3a\u7a7a");
        }
        log.info("\u84dd\u7968\u7533\u8bf7\u8fd4\u56de: {}", (Object)responseVO);
        return responseVO;
    }

    @Override
    public AisinoApplyRespVO blueResult(AisinoApplyPayload payload) {
        Map<String, Object> requestBody = BeanUtils.beanToMap(payload, new String[0]);
        String url = this.baseUrl + "/openapi/qd/qpt/Yp_FpUrl";
        log.info("\u84dd\u7968\u83b7\u53d6\u5165\u53c2: {}", (Object)BeanUtils.toJsonStr(requestBody));
        String jsonString = JSON.toJSONString((Object)payload);
        this.addLog("XF_BIZ_ORDER_UPLOAD", "\u822a\u4fe1\u5f00\u7968\u4e0a\u4f20\u63a5\u53e3\uff1a\u53c2\u6570", jsonString);
        String responseStr = null;
        try {
            responseStr = HttpClientUtil.post((String)url, (String)jsonString, (int)8000, (String)"application/json", (String)"utf-8");
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        this.addLog("XF_BIZ_ORDER_UPLOAD", "\u822a\u4fe1\u5f00\u7968\u4e0a\u4f20\u63a5\u53e3\uff1a\u7ed3\u679c", responseStr);
        AisinoApplyRespVO responseVO = (AisinoApplyRespVO)JSON.parseObject((String)responseStr, AisinoApplyRespVO.class);
        if (responseVO == null) {
            throw new BusinessException("\u822a\u4fe1\u5f00\u7968\u4e0a\u4f20\u54cd\u5e94\u4e3a\u7a7a");
        }
        log.info("\u84dd\u7968\u83b7\u53d6\u8fd4\u56de: {}", (Object)responseVO);
        return responseVO;
    }

    @Override
    public AisinoApplyRespVO orderRedInitial(AisinoApplyPayload payload) {
        Map<String, Object> requestBody = BeanUtils.beanToMap(payload, new String[0]);
        String url = this.baseUrl + "/openapi/qd/qpt/Kp_Fpkj";
        HttpParam param = new HttpParam();
        param.setUrl(url);
        param.setBody(requestBody);
        param.setRequestMethod(RequestMethod.POST);
        this.addLog("XF_BIZ_ORDER_UPLOAD", "\u4e1a\u52a1\u5355\u4e0a\u4f20\u63a5\u53e3\uff1a\u53c2\u6570", BeanUtils.toJsonStr(requestBody));
        String exchange = this.restClient.exchange(param);
        this.addLog("XF_BIZ_ORDER_UPLOAD", "\u4e1a\u52a1\u5355\u4e0a\u4f20\u63a5\u53e3\uff1a\u7ed3\u679c", BeanUtils.toJsonStr(exchange));
        AisinoRespVO responseVO = AisinoRespVO.convertResult(exchange);
        log.info("[AISINO] response: {}", (Object)responseVO);
        log.info("\u662f\u5426\u63d0\u4ea4\u6210\u529f\uff1a{}", (Object)AisinoRespVO.success(responseVO));
        Object result = responseVO.getResult();
        AisinoApplyRespVO aisinoApplyRespVO = (AisinoApplyRespVO)BeanUtils.toBean((Object)result, AisinoApplyRespVO.class);
        log.info("[AISINO] blueApplyRespVO: {}", (Object)aisinoApplyRespVO);
        return aisinoApplyRespVO;
    }

    @Override
    public AisinoApplyRespVO orderRedSave(AisinoApplyPayload payload) {
        Map<String, Object> requestBody = BeanUtils.beanToMap(payload, new String[0]);
        String url = this.baseUrl + "/openapi/qd/qpt/Kp_Fpkj";
        HttpParam param = new HttpParam();
        param.setUrl(url);
        param.setBody(requestBody);
        param.setRequestMethod(RequestMethod.POST);
        this.addLog("XF_BIZ_ORDER_UPLOAD", "\u4e1a\u52a1\u5355\u4e0a\u4f20\u63a5\u53e3\uff1a\u53c2\u6570", BeanUtils.toJsonStr(requestBody));
        String exchange = this.restClient.exchange(param);
        this.addLog("XF_BIZ_ORDER_UPLOAD", "\u4e1a\u52a1\u5355\u4e0a\u4f20\u63a5\u53e3\uff1a\u7ed3\u679c", BeanUtils.toJsonStr(exchange));
        AisinoRespVO responseVO = AisinoRespVO.convertResult(exchange);
        log.info("[AISINO] response: {}", (Object)responseVO);
        log.info("\u662f\u5426\u63d0\u4ea4\u6210\u529f\uff1a{}", (Object)AisinoRespVO.success(responseVO));
        Object result = responseVO.getResult();
        AisinoApplyRespVO aisinoApplyRespVO = (AisinoApplyRespVO)BeanUtils.toBean((Object)result, AisinoApplyRespVO.class);
        log.info("[AISINO] blueApplyRespVO: {}", (Object)aisinoApplyRespVO);
        return aisinoApplyRespVO;
    }

    @Override
    public AisinoApplyRespVO orderRedOpen(AisinoApplyPayload payload) {
        Map<String, Object> requestBody = BeanUtils.beanToMap(payload, new String[0]);
        String url = this.baseUrl + "/openapi/qd/qpt/Kp_Fpkj";
        HttpParam param = new HttpParam();
        param.setUrl(url);
        param.setBody(requestBody);
        param.setRequestMethod(RequestMethod.POST);
        this.addLog("XF_BIZ_ORDER_UPLOAD", "\u4e1a\u52a1\u5355\u4e0a\u4f20\u63a5\u53e3\uff1a\u53c2\u6570", BeanUtils.toJsonStr(requestBody));
        String exchange = this.restClient.exchange(param);
        this.addLog("XF_BIZ_ORDER_UPLOAD", "\u4e1a\u52a1\u5355\u4e0a\u4f20\u63a5\u53e3\uff1a\u7ed3\u679c", BeanUtils.toJsonStr(exchange));
        AisinoRespVO responseVO = AisinoRespVO.convertResult(exchange);
        log.info("[AISINO] response: {}", (Object)responseVO);
        log.info("\u662f\u5426\u63d0\u4ea4\u6210\u529f\uff1a{}", (Object)AisinoRespVO.success(responseVO));
        Object result = responseVO.getResult();
        AisinoApplyRespVO aisinoApplyRespVO = (AisinoApplyRespVO)BeanUtils.toBean((Object)result, AisinoApplyRespVO.class);
        log.info("[AISINO] blueApplyRespVO: {}", (Object)aisinoApplyRespVO);
        return aisinoApplyRespVO;
    }

    @Override
    public void saveInvoice(InvoiceParam invoiceParam) {
        ArrayList<InvoiceSaveParam> saveParams = new ArrayList<InvoiceSaveParam>();
        InvoiceMain invoiceMain = invoiceParam.getInvoiceMain();
        InvoiceApplyRpcDTO applyRpcDTO = this.invoiceApplyService.queryIdByApplyNo(invoiceMain.getSalesbillNo());
        Assert.notNull((Object)applyRpcDTO.getApplyId(), (String)(invoiceMain.getSalesbillNo() + " \u5355\u636e\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
        InvoiceSaveParam saveParam = new InvoiceSaveParam();
        saveParam.setMasId(applyRpcDTO.getApplyId());
        saveParam.setInvNo(invoiceMain.getInvoiceNo());
        saveParam.setInvCode(invoiceMain.getInvoiceCode());
        saveParam.setFlowNo(invoiceMain.getBatchNo());
        saveParam.setCheckCode(invoiceMain.getCheckCode());
        saveParam.setBlueInvCode(invoiceMain.getOriginInvoiceCode());
        saveParam.setBlueInvNo(invoiceMain.getOriginInvoiceNo());
        saveParam.setTotalAmt(new BigDecimal(invoiceMain.getAmountWithTax()));
        saveParam.setInvDate(LocalDateTime.parse(invoiceMain.getPaperDrewDate()));
        saveParam.setRedState(invoiceMain.getRedStatus());
        saveParam.setInvState(invoiceMain.getStatus());
        saveParam.setInvPdfUrl(invoiceMain.getPdfPath());
        saveParam.setInvFailCause("");
        saveParams.add(saveParam);
        this.invoiceApplyService.saveInvoice(saveParams);
        CompletableFuture.runAsync(() -> this.handleOutcomeOfInvoice(invoiceMain, applyRpcDTO), (Executor)this.taskExecutor);
    }

    private void handleOutcomeOfInvoice(InvoiceMain invoiceMain, InvoiceApplyRpcDTO applyRpcDTO) {
        log.info("\u5f00\u59cb\u786e\u8ba4\u5173\u8054\u5355\u636e\u72b6\u6001,\u5f00\u7968\u72b6\u6001:{},\u7ea2\u51b2\u72b6\u6001:{},\u5f00\u7968\u7533\u8bf7\u5355\u5165\u53c2:{}", new Object[]{invoiceMain.getStatus(), invoiceMain.getRedStatus(), JSON.toJSONString((Object)applyRpcDTO)});
        List sourceDocNoList = applyRpcDTO.getPaymentNoList();
        if (RedStateEnum.RED_PUNCH.getCode().equals(invoiceMain.getRedStatus())) {
            InvoiceRedraftDO invoiceRedraftDO;
            SaleInvDO saleInvDO = this.saleInvRepo.findByApplyNo(invoiceMain.getSalesbillNo());
            if (!Objects.isNull(saleInvDO)) {
                log.error("\u672a\u627e\u5230\u5f00\u7968\u7533\u8bf7\u5355\uff0c\u5355\u53f7\u4e3a\uff1a{}", (Object)invoiceMain.getSalesbillNo());
            }
            List<SaleInvDtlDTO> saleInvDtlDTOList = this.saleInvDtlRepoProc.getList(saleInvDO.getId());
            ArrayList<Long> salInvDtlIdList = new ArrayList();
            if (!CollectionUtils.isEmpty(saleInvDtlDTOList)) {
                salInvDtlIdList = saleInvDtlDTOList.stream().map(SaleInvDtlDTO::getSourceLineId).collect(Collectors.toList());
            }
            if (!ObjectUtils.isEmpty((Object)((Object)(invoiceRedraftDO = this.invoiceRedraftRepo.findByOrigApplyNo(invoiceMain.getSalesbillNo())))) && ProcInstStatus.APPROVED.equals((Object)invoiceRedraftDO.getWorkflowProcInstStatus()) && ObjectUtils.isEmpty((Object)invoiceRedraftDO.getOrigApplyNo())) {
                log.info("\u7ea2\u51b2\u540e\u5f00\u59cb\u521b\u5efa\u65b0\u7684\u5f00\u7968\u7533\u8bf7\u5355");
                this.createInvoice(applyRpcDTO, saleInvDO, salInvDtlIdList, invoiceRedraftDO);
            }
        }
    }

    private void createInvoice(InvoiceApplyRpcDTO applyRpcDTO, SaleInvDO saleInvDO, List<Long> paymentRecordDetailIdList, InvoiceRedraftDO invoiceRedraftDO) {
        InvoiceApplyParam param = new InvoiceApplyParam();
        param.setOptDocNos(applyRpcDTO.getPaymentNoList());
        param.setIds(applyRpcDTO.getPaymentIds());
        if (!CollectionUtils.isEmpty(paymentRecordDetailIdList)) {
            param.setBizDtlKey(paymentRecordDetailIdList);
        }
        param.setCustTaxNo(saleInvDO.getCustTaxNo());
        param.setCustInvTitle(saleInvDO.getCustInvTitle());
        param.setAddress(saleInvDO.getCustAdd());
        param.setCustBank(saleInvDO.getCustBank());
        param.setCustBankAcc(saleInvDO.getCustBankAcc());
        param.setCustTel(saleInvDO.getCustTel());
        param.setInvType(invoiceRedraftDO.getInvoiceType());
        log.info("\u5f00\u59cb\u751f\u6210\u5f00\u7968\u7533\u8bf7\u5355\uff0c\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)param));
        List<InvoiceSaveVO> saveList = this.invoiceAwaitService.invoiceApply(param);
        log.info("\u4fdd\u5b58\u5f00\u7968\u7533\u8bf7\u5355\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString(saveList));
        if (!CollectionUtils.isEmpty(saveList)) {
            for (InvoiceSaveVO save : saveList) {
                if (!Objects.isNull(save.getApplyNo())) {
                    log.info("\u5f00\u59cb\u6267\u884c\u66f4\u65b0\u65b0\u7533\u8bf7\u5355\u53f7\u66f4\u65b0\u8bed\u53e5\uff0c\u6570\u636e\u4e3a{},id:{}", (Object)save.getApplyNo(), (Object)invoiceRedraftDO.getId());
                }
                JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.redraftApplyNo, (Object)save.getApplyNo()).where(new Predicate[]{this.qdo.id.eq((Object)invoiceRedraftDO.getId())});
                log.info("\u6253\u5370\u6267\u884c\u8bed\u53e5");
                update.execute();
            }
        }
    }

    public AisinoServiceImpl(RestClient restClient, AisinoLogRepo aisinoLogRepo, SaleInvRepo saleInvRepo, SaleInvDtlRepoProc saleInvDtlRepoProc, JPAQueryFactory jpaQueryFactory, TaskExecutor taskExecutor, InvoiceApplyService invoiceApplyService, AisinoApplyPayloadService aisinoApplyPayloadService) {
        this.restClient = restClient;
        this.aisinoLogRepo = aisinoLogRepo;
        this.saleInvRepo = saleInvRepo;
        this.saleInvDtlRepoProc = saleInvDtlRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
        this.taskExecutor = taskExecutor;
        this.invoiceApplyService = invoiceApplyService;
        this.aisinoApplyPayloadService = aisinoApplyPayloadService;
    }
}

