/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.infinity.aisino.vo.param;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRedApplySaveParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRedInitialRespVO;
import com.elitesland.fin.infinity.aisino.utils.InvoiceIssueUtil;
import com.elitesland.fin.infinity.aisino.vo.param.AisinoRedPayload;
import com.elitesland.fin.infinity.aisino.vo.param.invoice.AisinoRedOpenParam;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.format.DateTimeFormatter;
import org.jetbrains.annotations.NotNull;

public class AisinoApplyPayload {
    @JSONField(name="APPID")
    private String APPID;
    @JSONField(name="DATA")
    private String DATA;
    @JSONField(name="USERNAME")
    private String USERNAME;
    @JSONField(name="NSRSBH")
    private String NSRSBH;

    public static AisinoApplyPayload convertRedInitial(InvoiceRedApplySaveParam saveParam) {
        AisinoApplyPayload payload = new AisinoApplyPayload();
        AisinoRedPayload row = new AisinoRedPayload();
        row.setLZFPQDHM(saveParam.getOriginApplyNo());
        row.setGMFNSRSBH(saveParam.getCustTaxNo());
        row.setXSFNSRSBH(saveParam.getSaleTaxNo());
        row.setLZKPRQ(saveParam.getInvDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        row.setKPFNSRSBH(saveParam.getSaleTaxNo());
        row.setGJBQ("1");
        row.setTDYSLXDM("");
        if (saveParam.getInvType().equals("VANA")) {
            row.setFPLXDM("81");
        } else if (saveParam.getInvType().equals("VANSP")) {
            row.setFPLXDM("82");
        }
        row.setLZFPHM("");
        row.setLZFPDM("");
        row.setFPLYDM("2");
        String encryptedData = AisinoApplyPayload.getEncryptedData(JSONObject.toJSONString((Object)row));
        payload.setDATA(encryptedData);
        return payload;
    }

    public static AisinoApplyPayload convertRedSave(InvoiceRedInitialRespVO saveParam) {
        return AisinoApplyPayload.getAisinoApplyPayload(JSONObject.toJSONString((Object)saveParam));
    }

    public static AisinoApplyPayload convertRedOpen(AisinoRedOpenParam saveParam) {
        return AisinoApplyPayload.getAisinoApplyPayload(JSONObject.toJSONString((Object)saveParam));
    }

    @NotNull
    private static AisinoApplyPayload getAisinoApplyPayload(String saveParam) {
        AisinoApplyPayload payload = new AisinoApplyPayload();
        String encryptedData = AisinoApplyPayload.getEncryptedData(saveParam);
        payload.setDATA(encryptedData);
        return payload;
    }

    @NotNull
    private static String getEncryptedData(String row) {
        String key = "12345678";
        byte[] encryptedBytes = InvoiceIssueUtil.encrypt(row.getBytes(), key);
        if (encryptedBytes == null) {
            throw new RuntimeException("\u52a0\u5bc6\u5931\u8d25,\u52a0\u5bc6\u7ed3\u679c\u4e3a\u7a7a\uff0c\u52a0\u5bc6\u6570\u636e:" + row);
        }
        return InvoiceIssueUtil.byteToHexString(encryptedBytes);
    }

    private static String scale(BigDecimal num) {
        return num.setScale(2, RoundingMode.HALF_UP).toString();
    }

    public static AisinoApplyPayloadBuilder builder() {
        return new AisinoApplyPayloadBuilder();
    }

    public String getAPPID() {
        return this.APPID;
    }

    public String getDATA() {
        return this.DATA;
    }

    public String getUSERNAME() {
        return this.USERNAME;
    }

    public String getNSRSBH() {
        return this.NSRSBH;
    }

    public void setAPPID(String APPID) {
        this.APPID = APPID;
    }

    public void setDATA(String DATA) {
        this.DATA = DATA;
    }

    public void setUSERNAME(String USERNAME) {
        this.USERNAME = USERNAME;
    }

    public void setNSRSBH(String NSRSBH) {
        this.NSRSBH = NSRSBH;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AisinoApplyPayload)) {
            return false;
        }
        AisinoApplyPayload other = (AisinoApplyPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$APPID = this.getAPPID();
        String other$APPID = other.getAPPID();
        if (this$APPID == null ? other$APPID != null : !this$APPID.equals(other$APPID)) {
            return false;
        }
        String this$DATA = this.getDATA();
        String other$DATA = other.getDATA();
        if (this$DATA == null ? other$DATA != null : !this$DATA.equals(other$DATA)) {
            return false;
        }
        String this$USERNAME = this.getUSERNAME();
        String other$USERNAME = other.getUSERNAME();
        if (this$USERNAME == null ? other$USERNAME != null : !this$USERNAME.equals(other$USERNAME)) {
            return false;
        }
        String this$NSRSBH = this.getNSRSBH();
        String other$NSRSBH = other.getNSRSBH();
        return !(this$NSRSBH == null ? other$NSRSBH != null : !this$NSRSBH.equals(other$NSRSBH));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AisinoApplyPayload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $APPID = this.getAPPID();
        result = result * 59 + ($APPID == null ? 43 : $APPID.hashCode());
        String $DATA = this.getDATA();
        result = result * 59 + ($DATA == null ? 43 : $DATA.hashCode());
        String $USERNAME = this.getUSERNAME();
        result = result * 59 + ($USERNAME == null ? 43 : $USERNAME.hashCode());
        String $NSRSBH = this.getNSRSBH();
        result = result * 59 + ($NSRSBH == null ? 43 : $NSRSBH.hashCode());
        return result;
    }

    public String toString() {
        return "AisinoApplyPayload(APPID=" + this.getAPPID() + ", DATA=" + this.getDATA() + ", USERNAME=" + this.getUSERNAME() + ", NSRSBH=" + this.getNSRSBH() + ")";
    }

    public AisinoApplyPayload(String APPID, String DATA, String USERNAME, String NSRSBH) {
        this.APPID = APPID;
        this.DATA = DATA;
        this.USERNAME = USERNAME;
        this.NSRSBH = NSRSBH;
    }

    public AisinoApplyPayload() {
    }

    public static class AisinoApplyPayloadBuilder {
        private String APPID;
        private String DATA;
        private String USERNAME;
        private String NSRSBH;

        AisinoApplyPayloadBuilder() {
        }

        public AisinoApplyPayloadBuilder APPID(String APPID) {
            this.APPID = APPID;
            return this;
        }

        public AisinoApplyPayloadBuilder DATA(String DATA) {
            this.DATA = DATA;
            return this;
        }

        public AisinoApplyPayloadBuilder USERNAME(String USERNAME) {
            this.USERNAME = USERNAME;
            return this;
        }

        public AisinoApplyPayloadBuilder NSRSBH(String NSRSBH) {
            this.NSRSBH = NSRSBH;
            return this;
        }

        public AisinoApplyPayload build() {
            return new AisinoApplyPayload(this.APPID, this.DATA, this.USERNAME, this.NSRSBH);
        }

        public String toString() {
            return "AisinoApplyPayload.AisinoApplyPayloadBuilder(APPID=" + this.APPID + ", DATA=" + this.DATA + ", USERNAME=" + this.USERNAME + ", NSRSBH=" + this.NSRSBH + ")";
        }
    }
}

