package com.elitesland.fin.application.service.excel.entity;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.elitesland.fin.application.facade.excel.convert.BigDecimalPruneZeroConverter;
import com.elitesland.fin.application.facade.excel.convert.DateTimeToDateConverter;
import com.elitesland.fin.utils.excel.convert.annotation.ExcelConvert;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class PayOrderExportEntity implements Serializable {
    @ApiModelProperty("来源系统单号")
    private String sourceNo;
    
    @ApiModelProperty("供应商编码")
    private String suppCode;
    
    @ApiModelProperty("供应商名称")
    private String suppName;
    
    @ApiModelProperty("公司编码")
    private String ouCode;
    
    @ApiModelProperty("公司名称")
    private String ouName;
    
    @ApiModelProperty("应付单类型名称")
    private String apTypeName;
    
    @ApiModelProperty("应付单类型代码")
    private String apTypeCode;
    
    @ApiModelProperty("付款单类型代码")
    private String payTypeCode;
    @ApiModelProperty("付款单类型名称")
    private String payTypeCodeName;
    
    @ApiModelProperty("付款单号")
    private String payOrderNo;
    
    @ApiModelProperty("币种编码")
    private String currCode;
    
    @ApiModelProperty("币种名称")
    private String currName;
    
    @ApiModelProperty("经办人")
    private String operator;
    
    @ApiModelProperty("业务类型")
    private String buType;
    private String buTypeName;
    
    @ApiModelProperty("含税总金额")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object totalAmt;
    
    @ApiModelProperty("含税总金额(本位币)")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object totalCurAmt;
    
    @ApiModelProperty("业务日期")
    @ExcelConvert(converter = DateTimeToDateConverter.class)
    private Object buDate;
    
    @ApiModelProperty("审核人")
    private String auditUser;
    
    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;
    
    @ApiModelProperty("状态")
    @SysCode(sys = "yst-supp", mod = "APPLY_STATUS")
    private String orderState;
    private String orderStateName;
    
    @ApiModelProperty("汇率")
    @JsonSerialize(using = BigDecimalPruneZeroConverter.class)
    private BigDecimal exchangeRate;
    
    @ApiModelProperty("是否期初")
    private Boolean initFlag;
    
    @ApiModelProperty("实际支付金额")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object realPayAmt;
    
    @ApiModelProperty("实际支付金额(本位币)")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private Object realPayCurAmt;
    
    @ApiModelProperty("预计付款日期")
    @ExcelConvert(converter = DateTimeToDateConverter.class)
    private Object apDate;
    
    @ApiModelProperty("是否预付")
    private Boolean apFlag;
    
    @ApiModelProperty("创建人名称")
    private String creator;
    
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;
    
    @ApiModelProperty("修改人名称")
    private String updater;
    
    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;
    
    @ApiModelProperty("备注")
    private String remark;
    
    @ApiModelProperty("审核拒绝原因")
    private String auditRejection;
    
    @ApiModelProperty("来源单据")
    @SysCode(sys = "yst-fin", mod = "PAY_DOC_CLS")
    private String createMode;
    private String createModeName;
    
    @ApiModelProperty("本位币名称")
    private String localCurrCode;
    
    @ApiModelProperty("本位币编码")
    private String localCurrName;
    
    @ApiModelProperty("核销状态")
    @SysCode(sys = "yst-fin", mod = "VERIFY_STATUS")
    private String verState;
    private String verStateName;
    
    @ApiModelProperty("核销金额")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private BigDecimal verAmt;
    
    @ApiModelProperty("剩余未核销金额")
    @ExcelConvert(converter = AmountRoundConverter.class)
    private BigDecimal unVerAmt;
    
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    
    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;
    
    @ApiModelProperty("地址号")
    private String addrNo;
    
    @ApiModelProperty("供应商地址号")
    private String suppAddrNo;
    
    @ApiModelProperty("红冲状态")
    private Boolean redState;
    
    @ApiModelProperty("红冲来源")
    private String redSourceNo;
    
    @SysCode(sys = "yst-fin", mod = "DOC_PROPOSED_STATUS")
    @ApiModelProperty("拟定状态")
    private String proposedStatus;
    private String proposedStatusName;

    @SysCode(sys = "yst-purc", mod = "IO_TYPE")
    private String inOutCust;
    private String inOutCustName;

    @ApiModelProperty("关联贸易公司")
    private String relevanceOuCode;
    private String relevanceOuName;

    @ApiModelProperty("明细来源单号")
    private String detailSourceNo;

    @ApiModelProperty("行号")
    private Integer sourceLine;

    @SysCode(sys = "yst-fin",mod = "PAY_METHOD")
    private String payType;
    private String payTypeName;

    @ApiModelProperty("付款银行账户")
    private String payBank;

    @ApiModelProperty("付款银行账号")
    private String payAccount;

    @ApiModelProperty("收款银行名称")
    private String recBank;

    @ApiModelProperty("收款银行账号")
    private String recAccount;

    @ExcelConvert(converter = AmountRoundConverter.class)
    private BigDecimal applyVerAmTing;

    @ExcelConvert(converter = AmountRoundConverter.class)
    private BigDecimal detailTotalAmt;

    @ExcelConvert(converter = AmountRoundConverter.class)
    private BigDecimal detailRealPayAmt;

}
