package com.elitesland.fin.domain.entity.paymentperiod;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/11
 * @Version 1.0
 * @Content:
 */
@Entity
@Table(name = "receipt_payment_agreement")
@org.hibernate.annotations.Table(appliesTo = "receipt_payment_agreement", comment = "收付款协议设置")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ReceiptPaymentAgreementDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 2252311435412013418L;

    @Comment("协议类型")
    @Column(name = "protocol_type", columnDefinition = "varchar(32)")
    private String protocolType;

    @Comment("协议编码")
    @Column(name = "protocol_code", columnDefinition = "varchar(64)")
    private String protocolCode;

    @Comment("协议名称")
    @Column(name = "protocol_name", columnDefinition = "varchar(100)")
    private String protocolName;

    @Comment("启用状态")
    @Column(name = "status", columnDefinition = "varchar(32)")
    private String status;



}
