package com.elitesland.fin.entity.invoice;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.support.provider.constant.SupportBusinessObjectConstants;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author: ryan.xu
 * @since 2023/4/13
 */
@Entity
@Table(name = "invoice_await")
@org.hibernate.annotations.Table(appliesTo = "invoice_await", comment = "待开发票")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "待开发票", description = "待开发票表")
@Where(clause = "delete_flag = 0")
public class InvoiceAwaitDO extends CustomFieldBaseModel implements Serializable {

    @Column(name = "doc_no", columnDefinition = "varchar(64) comment '待开发票单号'")
    private String docNo;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(32) comment '公司编码'")
    @BusinessParam(relatedBusinessObject = SupportBusinessObjectConstants.SUPPORT_OU, relatedField = "ouCode")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(256) comment '公司名称'")
    private String ouName;

    @Column(name = "cust_id", columnDefinition = "bigint(20) comment '客户ID'")
    private Long custId;

    @Column(name = "cust_code", columnDefinition = "varchar(32) comment '客户编码'")
    private String custCode;

    @Column(name = "cust_name", columnDefinition = "varchar(64) comment '客户姓名'")
    private String custName;

    @Column(name = "amt", columnDefinition = "DECIMAL(20,8) comment '金额'")
    private BigDecimal amt;

    @Column(name = "invoice_await_status", columnDefinition = "varchar(32) comment '待开发票状态'")
    private String invoiceAwaitStatus;

    @Column(name = "opt_doc_cls", columnDefinition = "varchar(32)  comment '来源单据名称 [UDC]yst-supp:DOC_CLS'")
    private String optDocCls;

    @Column(name = "opt_doc_type", columnDefinition = "varchar(32)  comment '来源单据类型'")
    private String optDocType;

    @Column(name = "opt_doc_status", columnDefinition = "varchar(32)  comment '可开票单据状态'")
    private String optDocStatus;

    @Column(name = "invoice_file_code", columnDefinition = "varchar(64) comment '发票文件编码'")
    private String invoiceFileCode;

    @Column(name = "invoice_apply_no", columnDefinition = "varchar(32) comment '开票申请单号'")
    private String invoiceApplyNo;

//    @Column(name = "remark", columnDefinition = "varchar(64) comment '备注'")
//    private String remark;

    @Column(name = "invoice_type", columnDefinition = "varchar(64) comment '发票类型'")
    private String invoiceType;

    @Column(name = "opt_doc_id", columnDefinition = "bigint(20) comment '来源单据主键id'")
    private Long optDocId;

    @Column(name = "opt_doc_no", columnDefinition = "varchar(64) comment '来源单号'")
    private String optDocNo;

    @ApiModelProperty("汇率")
    @Column(name = "curr_rate", columnDefinition = "DECIMAL(20,8) comment '汇率'")
    private BigDecimal currRate;

    @ApiModelProperty("币种")
    @Column(name = "curr_code", columnDefinition = "varchar(32) comment '币种'")
    private String currCode;

    /**
     * 对账状态
     */
    @ApiModelProperty("对账状态")
    @Column(name = "state", columnDefinition = "varchar(32) comment '对账状态'")
    private String state;

    /**
     * 确认时间
     */
    @ApiModelProperty("确认时间")
    @Column(name = "confirm_time", columnDefinition = "datetime(6) comment '确认时间'")
    private LocalDateTime confirmTime;

    @ApiModelProperty("主客户编码")
    @Column(name = "main_cust_code", columnDefinition = "varchar(32) comment '主客户编码'")
    private String mainCustCode;

    @ApiModelProperty("主客户名称")
    @Column(name = "main_cust_name", columnDefinition = "varchar(32) comment '主客户名称'")
    private String mainCustName;

    @ApiModelProperty("主客户id")
    @Column(name = "main_cust_id", columnDefinition = "bigint(20) comment '主客户id'")
    private Long mainCustId;

    @ApiModelProperty("集团编码")
    @Column(name = "pk_group", columnDefinition = "varchar(32) comment '集团编码'")
    private String pkGroup;

    @ApiModelProperty("结算方式")
    @Column(name = "settlement_type", columnDefinition = "varchar(32) comment '结算方式'")
    private String settlementType;

    @ApiModelProperty("开票类型编码")
    @Column(name = "open_inv_type", columnDefinition = "varchar(32) comment '开票类型编码'")
    private String openInvType;

    @Column(name = "auto_flag", columnDefinition = "tinyint(1) comment '是否自动完成'")
    private Boolean autoFlag;

    @ApiModelProperty(value = "发票类型")
    @Comment("发票类型")
    @Column(columnDefinition = "varchar(40)")
    private String invType;

    @ApiModelProperty(value = "开票抬头")
    @Comment("开票抬头")
    @Column(columnDefinition = "varchar(40)")
    private String invTitle;

    @ApiModelProperty(value = "开票抬头类型")
    @Comment("开票抬头类型")
    @Column(columnDefinition = "varchar(40)")
    private String invTitleType;

    @ApiModelProperty(value = "开票地址")
    @Comment("开票地址")
    @Column(columnDefinition = "varchar(200)")
    private String invAddress;

    @ApiModelProperty(value = "开票电话")
    @Comment("开票电话")
    @Column(columnDefinition = "longtext")
    private String invTel;

    @ApiModelProperty(value = "开票联系人")
    @Comment("开票联系人")
    @Column(columnDefinition = "longtext")
    private String invPicName;

    @ApiModelProperty(value = "开票联系人电话")
    @Comment("开票联系人电话")
    @Column(columnDefinition = "longtext")
    private String invPicPhone;

    @ApiModelProperty(value = "开票银行名称")
    @Comment("开票银行名称")
    @Column(columnDefinition = "longtext")
    private String invBankName;

    @ApiModelProperty(value = "开票银行账号")
    @Comment("开票银行账号")
    @Column(columnDefinition = "longtext")
    private String invBankAcc;

    @ApiModelProperty(value = "税号")
    @Comment("税号")
    @Column(columnDefinition = "varchar(100)")
    private String taxerNo;

    @ApiModelProperty(value = "开票邮箱")
    @Comment("开票邮箱")
    @Column(columnDefinition = "longtext")
    private String invEmail;

    @Column(name = "rec_apply_time", columnDefinition = "datetime default null  comment '对账申请时间'")
    private LocalDateTime recApplyTime;

    @ApiModelProperty(value = "门店编码")
    @Comment("门店编码")
    @Column(columnDefinition = "varchar(40)")
    private String storeCode;
}
