package com.elitesland.fin.infinity.aisino.vo.param;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.elitesland.fin.application.facade.param.invoice.InvoiceRedApplySaveParam;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceRedInitialRespVO;
import com.elitesland.fin.infinity.aisino.utils.InvoiceIssueUtil;
import com.elitesland.fin.infinity.aisino.vo.param.invoice.AisinoRedOpenParam;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.jetbrains.annotations.NotNull;

import java.math.BigDecimal;
import java.math.RoundingMode;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AisinoApplyPayload {

    /**
     * APPID
     */
    @JSONField(name = "APPID")
    private String APPID;

    /**
     * 请求体
     */
    @JSONField(name = "DATA")
    private String DATA;

    /**
     * 登录账号
     */
    @JSONField(name = "USERNAME")
    private String USERNAME;


    /**
     * 纳税人识别号
     */
    @JSONField(name = "NSRSBH")
    private String NSRSBH;


    public static AisinoApplyPayload convertRedInitial(InvoiceRedApplySaveParam saveParam) {
        AisinoApplyPayload payload = new AisinoApplyPayload();
        AisinoRedPayload row = new AisinoRedPayload();
        // 蓝字发票号码
        row.setLZFPQDHM(saveParam.getOriginApplyNo());

        //  购买方纳税人识别号
        row.setGMFNSRSBH(saveParam.getCustTaxNo());

        // 销售方纳税人识别号
        row.setXSFNSRSBH(saveParam.getSaleTaxNo());

        // 蓝字开票日期 YYYY-MM-DD HH:SS:DD
        row.setLZKPRQ(saveParam.getInvDate().format(java.time.format.DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));

        // 开票方纳税人识别号(销售方纳税人识别号)
        row.setKPFNSRSBH(saveParam.getSaleTaxNo());

        // 归集标签
        row.setGJBQ("1");
        // 特定要素类型代码
        row.setTDYSLXDM("");
        // 对应的中台的发票类型，专票、普票
        // 01-增值税专用发票  对应81
        // 02-增值税普通发票  对应82
        if (saveParam.getInvType().equals("VANA")) {
            //电子发票（增值税专用发票）--对应01
            row.setFPLXDM("81");
        } else if (saveParam.getInvType().equals("VANSP")) {
            //电子发票（普通发票）--对应02
            row.setFPLXDM("82");
        }

        // 蓝字发票号码（纸质）不传
        row.setLZFPHM("");
        // 蓝字发票代码（纸质） 不传
        row.setLZFPDM("");
        //发票来源代码 固定传2
        row.setFPLYDM("2");
        String encryptedData = getEncryptedData(JSONObject.toJSONString(row));
        payload.setDATA(encryptedData);
        return payload;
    }


    public static AisinoApplyPayload convertRedSave(InvoiceRedInitialRespVO saveParam) {
        return getAisinoApplyPayload(JSONObject.toJSONString(saveParam));
    }


    public static AisinoApplyPayload convertRedOpen(AisinoRedOpenParam saveParam) {
        return getAisinoApplyPayload(JSONObject.toJSONString(saveParam));
    }

    @NotNull
    private static AisinoApplyPayload getAisinoApplyPayload(String saveParam) {
        AisinoApplyPayload payload = new AisinoApplyPayload();
        String encryptedData = getEncryptedData(saveParam);
        payload.setDATA(encryptedData);
        return payload;
    }

    @NotNull
    private static String getEncryptedData(String row) {
        // 加密秘钥
        String key = "12345678";
        // 加密 数据
        byte[] encryptedBytes = InvoiceIssueUtil.encrypt(row.getBytes(), key);
        if (encryptedBytes == null) {
            throw new RuntimeException("加密失败,加密结果为空，加密数据:" + row);
        }
        return InvoiceIssueUtil.byteToHexString(encryptedBytes);
    }

    private static String scale(BigDecimal num) {
        return num.setScale(2, RoundingMode.HALF_UP).toString();
    }
}
