package com.elitesland.fin.provider.invoice;

import com.elitesland.fin.Application;
import com.elitesland.fin.application.convert.invoice.InvoiceRuleConfigConvert;
import com.elitesland.fin.domain.service.invoice.InvoiceRuleConfigDomainService;
import com.elitesland.fin.dto.invoice.InvoiceRuleConfigRpcDTO;
import com.elitesland.fin.infr.dto.invoice.InvoiceRuleConfigDTO;
import com.elitesland.fin.param.invoice.InvoiceRuleConfigRpcParam;
import com.elitesland.fin.service.invoice.InvoiceRuleConfigRpcService;
import com.elitesland.fin.service.pay.PayRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author sunxw
 * @description
 * @Date 2023/7/17
 */
@Slf4j
@RequiredArgsConstructor
@RestController
@RequestMapping(Application.URI_PREFIX + PayRpcService.PATH)
public class InvoiceRuleConfigRpcServiceImpl implements InvoiceRuleConfigRpcService {

    private final InvoiceRuleConfigDomainService configDomainService;

    @Override
    public List<InvoiceRuleConfigRpcDTO> getInvRuleConfig(List<InvoiceRuleConfigRpcParam> paramList) {

        List<InvoiceRuleConfigDTO> list = configDomainService.getRuleConfigList(InvoiceRuleConfigConvert.INSTANCE.rpcParam2QueryParam(paramList));

        return InvoiceRuleConfigConvert.INSTANCE.dto2RpcDto(list);
    }

}
