package com.elitesland.fin.rpc.tms;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.tms.api.provider.TmsProvider;
import com.elitesland.tms.api.vo.TmsOuQueryParamVO;
import com.elitesland.tms.api.vo.TmsOuRespVO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/08/16
 * @Version 1.0
 * @Content:
 */
@Service
@AllArgsConstructor
@Slf4j
public class TmsOutServiceImpl implements TmsOutService {

    private final TmsProvider tmsProvider;

    @Override
    public List<TmsOuRespVO> findTmsOuList(TmsOuQueryParamVO tmsOuQueryParamVO) {
        ApiResult<List<TmsOuRespVO>> apiResult = tmsProvider.findTmsOuList(tmsOuQueryParamVO);

        if (apiResult.isSuccess()) {
            List<TmsOuRespVO> rpcDTOList = apiResult.getData();
            if (CollectionUtil.isNotEmpty(rpcDTOList)) {
                return rpcDTOList;
            }
        } else {
            throw new BusinessException(ApiCode.FAIL, "调用物流域(findTmsOuList)查询快速公司失败：" + apiResult.getErrorMsg());
        }

        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<String,TmsOuRespVO> findTmsOuMapByCodes(List<String> logisticsOuCodes) {
        if (CollectionUtil.isEmpty(logisticsOuCodes)){
            return new HashMap<>();
        }
        TmsOuQueryParamVO tmsOuQueryParamVO = new TmsOuQueryParamVO();
        tmsOuQueryParamVO.setLogisticsOuCodes(logisticsOuCodes);
        List<TmsOuRespVO> rpcDTOList = this.findTmsOuList(tmsOuQueryParamVO);
        if (CollectionUtil.isEmpty(rpcDTOList)) {
            return new HashMap<>();
        }
        Map<String, TmsOuRespVO> rpcMap = rpcDTOList.stream().collect(Collectors.toMap(TmsOuRespVO::getLogisticsOuCode, t -> t, (t1, t2) -> t1));

        return rpcMap;

    }

}
