package com.elitesland.fin.domain.service.arorder;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.facade.param.arorder.ArOrderSaveParam;
import com.elitesland.fin.application.facade.vo.paymentperiod.ReceiptPaymentAgreementDtlVO;
import com.elitesland.fin.application.service.excel.entity.ArExportEntity;
import com.elitesland.fin.domain.entity.arorder.ArOrder;
import com.elitesland.fin.domain.param.arorder.ArOrderPageParam;
import com.elitesland.fin.domain.param.arorder.ArOrderParam;
import com.elitesland.fin.infr.dto.arorder.ArOrderDTO;
import com.elitesland.workflow.ProcessInfo;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.service.arorder
 * @date 2022/4/12 16:18
 */
public interface ArOrderDomainService {

    Long save(ArOrder apOrder);

    PagingVO<ArOrderDTO> page(ArOrderPageParam arOrderPageParam);

    public PagingVO<ArOrderDTO> writeoffPage(ArOrderPageParam arOrderPageParam);

    ArOrderDTO get(Long id);

    List<ArOrderDTO> get(List<Long> ids);

    Long audit(List<Long> ids, String content, SysUserDTO user);

    void delByArOrderNoOrSourceNos(List<String> sourceNos, String sourceType);

    Long del(List<Long> ids);

    Long delOnly(List<Long> ids);

    Long commit(ArOrder apOrder, Boolean auto);

    Long newCommit(ArOrder apOrder, Boolean auto);

    ArOrderDTO getArOrderAndDtl(Long id);

    Boolean queryByArTypeId(Long arTypeId);

    List<ArOrderDTO> getArOrderList(ArOrderParam apOrderParam);

    void updateVerAmt(Long id, BigDecimal amt);

    void updateWorkInfo(ProcessInfo processInfo, Long resId);

    void updateSourceNo(String sourceNo, Long id);

    PagingVO<ArExportEntity> exportDefault(ArOrderPageParam param);

    /**
     * 重置单据状态
     *
     * @param ids
     */
    void restDocState(List<Long> ids);

    /**
     * 红冲单据创建
     *
     * @param id
     * @return
     */
    ArOrderSaveParam redPunchCreate(Long id);

    /**
     * 计算应收应付起算日期
     *
     * @param createMode
     * @param buDate
     * @param receiptPaymentAgreementDtlVO
     * @return
     */
    LocalDateTime calculateStartCalDate(String createMode, LocalDateTime buDate, ReceiptPaymentAgreementDtlVO receiptPaymentAgreementDtlVO);

    /**
     * 计算应收应付到期付款日
     *
     * @param startCalDate
     * @param receiptPaymentAgreementDtlVO
     * @return
     */
    LocalDateTime calculateExpirePayDate(LocalDate startCalDate, ReceiptPaymentAgreementDtlVO receiptPaymentAgreementDtlVO);

    /**
     * 查询当前账户超账期应付明细总数
     *
     * @param custCode
     * @param ouCode
     * @return
     */
    long countOverduePeriodPay(String custCode, String ouCode);

    /**
     * 生成财务流水
     *
     * @param arOrderDTO
     */
    void createFinFlow(ArOrderDTO arOrderDTO);

}
