package com.elitesland.fin.domain.service.saleinv;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.saleinv.SaleInvParam;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvSumVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvVO;
import com.elitesland.fin.domain.entity.saleinv.SaleInv;
import com.elitesland.fin.domain.param.saleinv.SaleInvAppPageParam;
import com.elitesland.fin.domain.param.saleinv.SaleInvPageParam;
import com.elitesland.fin.infr.dto.saleinv.SaleInvAppDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvSumDTO;
import com.elitesland.fin.infr.dto.saleinv.SaleInvdDtlDTO;
import com.elitesland.workflow.ProcessInfo;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.domain.service.saleinv
 * @date 2022/5/6 17:00
 */
public interface SaleInvDomainService {

    PagingVO<SaleInvDTO> page(SaleInvPageParam saleInvPageParam);

    PagingVO<SaleInvAppDTO> appPage(SaleInvAppPageParam param);

    SaleInvDTO get(Long id);

    Long save(SaleInv saleInv);

    Long del(List<Long> ids);

    Long update(SaleInv saleInv);

    Long submit(SaleInv saleInv);

    List<SaleInvdDtlDTO> getInvdLists(Long masId);

    Long updateInvInfo(SaleInvParam saleInvParam);

    void updateWorkInfo(ProcessInfo processInfo, Long resId);

    /**
     * 更新是否生成应收单标记
     * @param applyNo 开票申请单号
     * @param arFlag 是否生成应收单标记
     */
    void updateArFlagByApplyNo(String applyNo, String arFlag);

    SaleInvVO queryAmt();

    SaleInvSumDTO selectListSum(SaleInvPageParam param);

    SaleInvAppDTO appGet(Long id);
}
