package com.elitesland.fin.application.service.excel.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.fin.application.facade.excel.convert.AmountRoundConverter;
import com.elitesland.fin.utils.ExcelUtil;
import com.elitesland.fin.utils.excel.convert.annotation.ExcelConvert;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@ApiModel(value = "账户", description = "账户")
@Data
public class AccountExportEntity implements Serializable {

    @ExcelProperty(value = "归属公司名称", index = 0)
    private String secOuName;

    @ExcelProperty(value = "开户主体类型", index = 1)
    private String accountHolderTypeName;

    @ExcelProperty(value = "开户主体名称", index = 2)
    private String accountHolderName;

    @ExcelProperty(value = "开户主体编码", index = 3)
    private String accountHolderCode;

    @ExcelProperty(value = "账户编码", index = 4)
    private String accountCode;

    @ExcelProperty(value = "账户名称", index = 5)
    private String accountName;

    @ExcelProperty(value = "账户类型", index = 6)
    private String accountTypeName;

    @ExcelProperty(value = "账户金额", index = 7)
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal accountAmount;

    @ExcelProperty(value = "账户占用金额", index = 8)
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal accountOccupancyAmount;

    @ExcelProperty(value = "账户可用金额", index = 9)
    @JsonSerialize(using = AmountRoundConverter.class)
    private BigDecimal accountAvailableAmount;

    @ExcelProperty(value = "状态", index = 10)
    private String stateName;

    @ExcelProperty(value = "创建人", index = 11)
    private String creator;

    @ExcelProperty(value = "创建时间", index = 12)
    private LocalDateTime createTime;

    @ExcelProperty(value = "备注", index = 13)
    private String remark;

}
