package com.elitesland.fin.application.facade.dto.writeoff;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 应收单基本信息
 */
@Data
public class ArOrderExDTO implements Serializable {

    private static final long serialVersionUID = 4740117621923601427L;

    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "应收单类型(必填)")
    @NotBlank(message = "应收单类型不能为空")
    private String arTypeName;

    @ApiModelProperty(value = "来源系统(必填)")
    @NotBlank(message = "来源系统不能为空")
    private String createMode;

    @ApiModelProperty(value = "应收单主表关联id(必填)")
    @NotNull(message = "应收单主表关联id不能为空")
    private Long relateId;

    @ApiModelProperty(value = "状态(必填)")
    @NotBlank(message = "状态不能为空")
    private String orderState;

    @ApiModelProperty(value = "销售公司(必填)")
    @NotBlank(message = "销售公司不能为空")
    private String ouCode;

    @ApiModelProperty(value = "部门(必填)")
    @NotBlank(message = "部门不能为空")
    private String buCode;

    @ApiModelProperty(value = "业务员(必填)")
    @NotBlank(message = "业务员不能为空")
    private String saleUser;

    @ApiModelProperty(value = "订单客户(必填)")
    @NotBlank(message = "订单客户不能为空")
    private String orderCustomer;

    @ApiModelProperty(value = "客户编码(必填)")
    @NotBlank(message = "客户编码不能为空")
    private String custCode;

    @ApiModelProperty(value = "币种(必填)")
    @NotBlank(message = "币种不能为空")
    private String currCode;

    @ApiModelProperty(value = "汇率(必填)")
    @NotBlank(message = "汇率不能为空")
    private String exchangeRate;

    @ApiModelProperty(value = "原币金额(必填)")
    @NotBlank(message = "原币金额不能为空")
    private String totalAmt;

    @ApiModelProperty(value = "本币金额(必填)")
    @NotBlank(message = "本币金额不能为空")
    private String totalCurAmt;

    @ApiModelProperty(value = "发票号(必填)")
    @NotBlank(message = "发票号不能为空")
    private String invoiceNumber;

    @ApiModelProperty(value = "开票日期(必填)")
    @NotNull(message = "开票日期不能为空")
    private LocalDateTime invDate;

    @ApiModelProperty(value = "发票类型(必填)")
    @NotBlank(message = "发票类型不能为空")
    private String invType;

    @ApiModelProperty(value = "第三方应收单号(必填)")
    @NotBlank(message = "第三方应收单号不能为空")
    private String thirdOrderNum;

    @ApiModelProperty(value = "期初标志(必填)")
    @NotBlank(message = "期初标志不能为空")
    private String initFlag;

    @ApiModelProperty(value = "起算日期(必填)")
    @NotNull(message = "起算日期不能为空")
    private LocalDateTime startDate;

    @ApiModelProperty(value = "红冲标志(必填) Y或N,默认为N")
    @NotNull(message = "红冲标志不能为空")
    private Boolean redFlushSign;

    @ApiModelProperty(value = "创建日期(必填)")
    @NotNull(message = "创建日期不能为空")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "创建人(必填)")
    @NotBlank(message = "创建人不能为空")
    private String creator;

    @ApiModelProperty(value = "开票备注(必填)")
    private String remark;

    @ApiModelProperty(value = "第三方支付辅助(必填)")
    private String thirdPaymentAssistance;

    @ApiModelProperty(value = "消费卡辅助(必填)")
    private String consumerCardSsistance;

    @ApiModelProperty(value = "信用卡辅助(必填)")
    private String creditCardAssistance;

    @ApiModelProperty(value = "结算方式(必填)")
    private String payType;


    @ApiModelProperty(value = "应收单明细集合")
    private List<ArOrderExDtDTO> items;

    @ApiModelProperty(value = "第三方应收单号")
    private String sourceNo;

    @ApiModelProperty("核销申请中金额")
    private BigDecimal applyVerAmting;




}
