package com.elitesland.fin.application.facade.excel.creditaccount;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * 期初余额额度导入实体类
 */
@Data
public class InitialLimitImportEntity implements Serializable {

    private static final long serialVersionUID = 651605491117978659L;

    @ExcelProperty(index = 0)
    @ApiModelProperty("信用账户编码")
    private String creditAccountCode;

    @ExcelProperty(index = 1)
    @ApiModelProperty("信用账户名称")
    private String creditAccountName;

    @ExcelProperty(index = 2)
    @ApiModelProperty("期初账户额度")
    private String initialAccountLimit;

    @ExcelProperty(index = 3)
    @ApiModelProperty("期初账户使用额度")
    private String initialAccountUsedLimit;

    @ExcelProperty(index = 4)
    @ApiModelProperty("期初占用额度")
    private String initialAccountOccupancyLimit;

    @ExcelProperty(index = 5)
    @ApiModelProperty("备注")
    private String remark;

    @ExcelIgnore
    @ApiModelProperty("状态")
    private String status;

    @ExcelIgnore
    @ApiModelProperty("ID")
    private Long id;

    @ExcelIgnore
    @ApiModelProperty("创建人id")
    private Long createUserId;

    @ExcelIgnore
    @ApiModelProperty("创建人")
    private String creator;

    @ExcelIgnore
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("扩展信息字段")
    private Map<String, String> extensionInfo;
}
