package com.elitesland.fin.application.web.saleinvd;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.application.facade.vo.invoiceredraft.InvoiceRedraftPageVO;
import com.elitesland.fin.application.facade.vo.saleinv.SaleInvDetailAppVO;
import com.elitesland.fin.application.service.saleinvd.SaleInvdService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

/**
 * @author gyj
 * @date 2022/5/6 14:32
 */
@RestController
@RequestMapping("/saleInvd")
@RequiredArgsConstructor
@Api(tags = {"销售已开发票列表"})
public class SaleInvdController {

    public final SaleInvdService saleInvdService;

    @GetMapping("cancel")
    @ApiOperation("作废")
    public ApiResult<Void> cancel(Long id) {
        saleInvdService.cancel(id);
        return ApiResult.ok();
    }

    @GetMapping("/red")
    @ApiOperation("红冲")
    public ApiResult<Void> red(Long id) {
        saleInvdService.red(id);
        return ApiResult.ok();
    }

    @ApiOperation("换开申请")
    @GetMapping("/redraft")
    public ApiResult<InvoiceRedraftPageVO> redraft(Long id) {
        return ApiResult.ok(saleInvdService.redraft(id));
    }

    @ApiOperation("小程序获取销售发票详情接口")
    @GetMapping("app/get")
    public ApiResult<SaleInvDetailAppVO> appGet(Long id) {
        SaleInvDetailAppVO res = saleInvdService.appGet(id);
        return ApiResult.ok(res);
    }
}
