package com.elitesland.fin.infinity.aisino.vo.resp;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.fin.infinity.vo.ResponseVO;
import com.elitesland.fin.utils.BeanUtils;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;


@Data
public class AisinoRespVO extends ResponseVO {

    /**
     * 1成功；-1失败；
     */
    private String code;
    /**
     * 开票申请单号
     */
    private String bizCode;
    private String message;
    private List<ErrorVO> errors;
    private Object result;

    public static AisinoRespVO convertResult(String exchange) {
        return ResponseVO.result(exchange, AisinoRespVO.class);
    }

    @Override
    public String getCode() {
        return "1".equals(code) ? "S" : "E";
    }

    public String getErrorMsg(String applyNo) {
        ResultVO resultVO = BeanUtils.toBean(result, ResultVO.class);
        if (ObjectUtil.isNull(resultVO)) {
            return message;
        }
        Map<String, List<String>> failResult = resultVO.getFailResult();
        List<String> reasonList = failResult.get(applyNo);
        return ResponseVO.success(this) ? "" : StringUtils.join(reasonList, "；");
    }

    @Override
    public List<Map<String, Object>> getData() {
        return null;
    }

    @Override
    public void setData(List<Map<String, Object>> data) {

    }
}
