package com.elitesland.fin.infr.repo.report;

import cn.hutool.core.util.StrUtil;
import com.elitesland.fin.application.facade.vo.report.IpvRespVO;
import com.elitesland.fin.application.facade.vo.report.IpvSumRespVO;
import com.elitesland.fin.domain.entity.recorder.RecOrderDO;
import com.elitesland.fin.domain.entity.report.IpvInvoiceDO;
import com.elitesland.fin.domain.entity.report.QIpvInvoiceDO;
import com.elitesland.fin.domain.param.report.IpvInvoicePageParam;
import com.elitesland.fin.domain.param.report.IpvInvoiceParam;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class IpvInvoiceRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QIpvInvoiceDO ipvInvoiceDO = QIpvInvoiceDO.ipvInvoiceDO;

    public long countIpvInvoice(IpvInvoicePageParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(ipvInvoiceDO.count())
                .from(ipvInvoiceDO);
        jpaQuery.where(this.whereIpvInvoice(paramVO));
        //数据权限
        BusinessSecurityUtil.where(jpaQuery, IpvInvoiceDO.class);
        return jpaQuery.fetchCount();
    }

    private final QBean<IpvRespVO> pageList = Projections.bean(
            IpvRespVO.class,
            ipvInvoiceDO.id,
            ipvInvoiceDO.apOrderNo,
            ipvInvoiceDO.sourceDocNo,
            ipvInvoiceDO.sourceLineNo,
            ipvInvoiceDO.ouCode,
            ipvInvoiceDO.ouName,
            ipvInvoiceDO.suppCode,
            ipvInvoiceDO.suppName,
            ipvInvoiceDO.whCode,
            ipvInvoiceDO.whName,
            ipvInvoiceDO.itemCode,
            ipvInvoiceDO.itemName,
            ipvInvoiceDO.itemType,
            ipvInvoiceDO.finDate,
            ipvInvoiceDO.apQty,
            ipvInvoiceDO.saleQty,
            ipvInvoiceDO.saleRatio,
            ipvInvoiceDO.ratioAmt,
            ipvInvoiceDO.ipv,
            ipvInvoiceDO.uom,
            ipvInvoiceDO.ratioAmt,
            ipvInvoiceDO.accountPeriod,
            ipvInvoiceDO.smallCateCode,
            ipvInvoiceDO.smallCateName
    );

    public List<IpvRespVO> queryIpvInvoice(IpvInvoicePageParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(pageList)
                .from(ipvInvoiceDO);
        paramVO.setPaging(jpaQuery);
        paramVO.fillOrders(jpaQuery, ipvInvoiceDO);
        jpaQuery.where(this.whereIpvInvoice(paramVO));
        //数据权限
        BusinessSecurityUtil.where(jpaQuery, IpvInvoiceDO.class);
        return jpaQuery.fetch();
    }


    private Predicate whereIpvInvoice(IpvInvoicePageParam paramVO) {
        List<Predicate> predicates = new ArrayList<>();
        if (paramVO.getOuId() != null) {
            predicates.add(ipvInvoiceDO.ouId.eq(paramVO.getOuId()));
        }
        if (paramVO.getWhId() != null) {
            predicates.add(ipvInvoiceDO.whId.eq(paramVO.getWhId()));
        }
        if (paramVO.getItemId() != null) {
            predicates.add(ipvInvoiceDO.itemId.eq(paramVO.getItemId()));
        }
        if (paramVO.getSuppId() != null) {
            predicates.add(ipvInvoiceDO.suppId.eq(paramVO.getSuppId()));
        }
        if (StrUtil.isNotBlank(paramVO.getDocNo())) {
            predicates.add(ipvInvoiceDO.sourceDocNo.like(paramVO.getDocNo() + "%"));
        }
        if (!ObjectUtils.isEmpty(paramVO.getFinDateFrom()) && !ObjectUtils.isEmpty(paramVO.getFinDateTo())) {
            predicates.add(ipvInvoiceDO.finDate.between(paramVO.getFinDateFrom(), paramVO.getFinDateTo()));
        }
        if (StrUtil.isNotBlank(paramVO.getAccountPeriod())) {
            predicates.add(ipvInvoiceDO.accountPeriod.eq(paramVO.getAccountPeriod()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public IpvRespVO findIpvByParam(IpvInvoiceParam param) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(IpvRespVO.class,
                        ipvInvoiceDO.saleQty.sum().as("saleQty"),
                        ipvInvoiceDO.saleRatio.sum().as("saleRatio"),
                        ipvInvoiceDO.ratioAmt.sum().as("ratioAmt")
                ))
                .from(ipvInvoiceDO);
        if (StrUtil.isNotBlank(param.getApOrderNo())) {
            jpaQuery.where(ipvInvoiceDO.apOrderNo.eq(param.getApOrderNo()));
        }
        if (StrUtil.isNotBlank(param.getSourceDocNo())) {
            jpaQuery.where(ipvInvoiceDO.sourceDocNo.eq(param.getSourceDocNo()));
        }
        if (param.getSourceLineNo() != null) {
            jpaQuery.where(ipvInvoiceDO.sourceLineNo.eq(param.getSourceLineNo()));
        }
        return jpaQuery.fetchOne();
    }

    public IpvSumRespVO sumIpvInvoice(IpvInvoicePageParam paramVO) {
        var jpaQuery = jpaQueryFactory.select(Projections.bean(IpvSumRespVO.class,
                        ipvInvoiceDO.apQty.sum().as("sumApQty"),
                        ipvInvoiceDO.ipv.sum().as("sumIpv"),
                        ipvInvoiceDO.ratioAmt.sum().as("sumRatioAmt")
                        ))
                .from(ipvInvoiceDO);
        jpaQuery.where(this.whereIpvInvoice(paramVO));
        //数据权限
        BusinessSecurityUtil.where(jpaQuery, IpvInvoiceDO.class);
        return jpaQuery.fetchOne();
    }
}
