package com.elitesland.fin.provider.invoice.await;

import com.elitesland.fin.enums.InvoiceAwaitTypeEnum;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * 付款记录服务工厂类，用于生成指定的付款记录服务类
 * Created by lance on 2023/7/13.
 */
@Slf4j
@Service
public class InvoiceAwaitSaveServiceFactory implements InitializingBean, ApplicationContextAware {

    private final Map<InvoiceAwaitTypeEnum, InvoiceAwaitSaveService> PAYMENT_RECORDS_SERVICE_MAP = new HashMap<>();

    private ApplicationContext appContext;

    @Override
    public void afterPropertiesSet() {
        appContext.getBeansOfType(InvoiceAwaitSaveService.class)
                .values()
                .forEach(strategy -> PAYMENT_RECORDS_SERVICE_MAP.put(strategy.getPaymentRecordStrategy(), strategy));
    }

    @Override
    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        appContext = applicationContext;
    }

    public InvoiceAwaitSaveService initialService(InvoiceAwaitTypeEnum invoiceAwaitTypeEnum) {
        return PAYMENT_RECORDS_SERVICE_MAP.get(invoiceAwaitTypeEnum);
    }
}
