package com.elitesland.fin.repo.creditaccountflow;


import com.elitesland.fin.application.facade.dto.creditaccountflow.CreditAccountFlowDTO;
import com.elitesland.fin.entity.creditaccountflow.CreditAccountFlowDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@Repository
public interface CreditAccountFlowRepo extends JpaRepository<CreditAccountFlowDO, Long>, QuerydslPredicateExecutor<CreditAccountFlowDO> {

    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update credit_account_flow set delete_flag = 1 where flow_no in ?1", nativeQuery = true)
    void deleteByFlowNos(List<String> flowNos);

    boolean existsByCreditAccountCode(String creditAccountCode);


    /**
     * 按照信用账户编码分组查询审核时间最早的一条流水
     *
     * @param codeFlag 是否查询所有
     * @param creditAccountCodes 查询指定信用账户编码集合
     * @return
     */
    @Query(value = "SELECT f.* " +
            "FROM ( " +
            "    SELECT *, ROW_NUMBER() OVER(PARTITION BY credit_account_code ORDER BY audit_date ) AS rn " +
            "    FROM credit_account_flow " +
            "    where audit_date is not null " +
            "    and (?1 or credit_account_code in (?2)) " +
            ") f " +
            "WHERE f.rn = 1; ", nativeQuery = true)
    List<CreditAccountFlowDO> selectByCreditAccountCodeIn(Boolean codeFlag, List<String> creditAccountCodes);

    boolean existsByRootDocNoAndSyncStatusIn(String rootDocNo, List<String> syncStatus);

    List<CreditAccountFlowDO> findByRootDocNo(String rootDocNo);

}
