/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.excel.exp;

import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.account.AccountPageParam;
import com.elitesland.fin.application.facade.vo.account.AccountVO;
import com.elitesland.fin.application.service.account.AccountService;
import com.elitesland.fin.application.service.excel.entity.AccountExportEntity;
import com.elitesland.fin.utils.excel.convert.ExcelConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AccountExportServiceImpl
implements DataExport<AccountExportEntity, AccountPageParam> {
    private static final Logger log = LoggerFactory.getLogger(AccountExportServiceImpl.class);
    private final AccountService accountService;

    public String getTmplCode() {
        return "fin_account_export";
    }

    @BusinessObjectOperation(permissionRef="fin_account_list", businessObjectType="Fin_Account:\u8d26\u6237", operationType=OperationTypeEnum.EXPORT, operationDescription="\u8d22\u52a1\u8d26\u6237\u5bfc\u51fa", operationCode="fin_account_export", dataPermissionEnabled=true, fieldPermissionAutoFilter=true)
    public PagingVO<AccountExportEntity> executeExport(AccountPageParam queryParam) {
        PagingVO<AccountVO> page = this.accountService.page(queryParam);
        return new PagingVO(page.getTotal(), ExcelConvertUtils.convertLoosely(page.getRecords(), AccountExportEntity.class));
    }

    public AccountExportServiceImpl(AccountService accountService) {
        this.accountService = accountService;
    }
}

