/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.expense;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.expense.ExpTypeConvert;
import com.elitesland.fin.application.convert.expense.ExpTypeDtlConvert;
import com.elitesland.fin.application.facade.param.expense.ExpTypeParam;
import com.elitesland.fin.application.facade.vo.expense.ExpTypeDtlVO;
import com.elitesland.fin.application.facade.vo.expense.ExpTypeVO;
import com.elitesland.fin.application.service.expense.ExpTypeService;
import com.elitesland.fin.domain.expense.ExpType;
import com.elitesland.fin.domain.expense.ExpTypeDtl;
import com.elitesland.fin.domain.param.expense.ExpTypeDtlPageParam;
import com.elitesland.fin.domain.param.expense.ExpTypePageParam;
import com.elitesland.fin.domain.service.expense.ExpTypeDomainService;
import com.elitesland.fin.domain.service.expense.ExpTypeDtlDomainService;
import com.elitesland.fin.infr.dto.expesne.ExpTypeDTO;
import com.elitesland.fin.infr.dto.expesne.ExpTypeDtlDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExpTypeServiceImpl
implements ExpTypeService {
    private static final Logger log = LoggerFactory.getLogger(ExpTypeServiceImpl.class);
    private final ExpTypeDomainService expTypeDomainService;
    private final ExpTypeDtlDomainService expTypeDtlDomainService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(ExpTypeParam expTypeParam) {
        ExpType expType = ExpTypeConvert.INSTANCE.convert(expTypeParam);
        if (CollectionUtil.isNotEmpty(expTypeParam.getDtlList())) {
            List<ExpTypeDtl> expTypeDtlList = expTypeParam.getDtlList().stream().map(ExpTypeDtlConvert.INSTANCE::saveParamToEn).collect(Collectors.toList());
            expType.setDtlList(expTypeDtlList);
        }
        Long res = this.expTypeDomainService.save(expType);
        return ApiResult.ok((Object)res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> update(ExpTypeParam expTypeParam) {
        if (null == expTypeParam.getId()) {
            throw new BusinessException("\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ExpType expType = ExpTypeConvert.INSTANCE.convert(expTypeParam);
        if (CollectionUtil.isNotEmpty(expTypeParam.getDtlList())) {
            List<ExpTypeDtl> expTypeDtlList = expTypeParam.getDtlList().stream().map(ExpTypeDtlConvert.INSTANCE::saveParamToEn).collect(Collectors.toList());
            expType.setDtlList(expTypeDtlList);
        }
        Long res = this.expTypeDomainService.update(expType);
        return ApiResult.ok((Object)res);
    }

    @Override
    @SysCodeProc
    public ApiResult<ExpTypeVO> get(Long id) {
        ExpTypeDTO res = this.expTypeDomainService.get(id);
        ExpTypeVO expTypeVO = ExpTypeConvert.INSTANCE.convert(res);
        List<ExpTypeDtlDTO> expTypeDtlDTOList = this.expTypeDtlDomainService.selectByMasId(res.getId());
        if (CollectionUtil.isNotEmpty(expTypeDtlDTOList)) {
            List<ExpTypeDtlVO> expTypeDtlVOList = expTypeDtlDTOList.stream().map(ExpTypeDtlConvert.INSTANCE::dtoToVo).collect(Collectors.toList());
            expTypeVO.setDtlList(expTypeDtlVOList);
        }
        return ApiResult.ok((Object)expTypeVO);
    }

    @Override
    @SysCodeProc
    public ApiResult<PagingVO<ExpTypeVO>> page(ExpTypePageParam expTypePageParam) {
        if (StringUtils.isNotBlank((CharSequence)expTypePageParam.getSourceDoc()) || CollectionUtil.isNotEmpty(expTypePageParam.getSourceDocList())) {
            ArrayList<String> sourceDocList = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)expTypePageParam.getSourceDoc())) {
                sourceDocList.add(expTypePageParam.getSourceDoc());
            }
            if (CollectionUtil.isNotEmpty(expTypePageParam.getSourceDocList())) {
                sourceDocList.addAll(expTypePageParam.getSourceDocList());
            }
            ExpTypeDtlPageParam expTypeDtlPageParam = new ExpTypeDtlPageParam();
            expTypeDtlPageParam.setSourceDocList(sourceDocList);
            List<ExpTypeDtlDTO> expTypeDtlDTOList = this.expTypeDtlDomainService.selectListByParam(expTypeDtlPageParam);
            if (CollectionUtil.isEmpty(expTypeDtlDTOList)) {
                return ApiResult.ok((Object)PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build());
            }
            List<Long> masIds = expTypeDtlDTOList.stream().map(ExpTypeDtlDTO::getMasId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            expTypePageParam.setIdList(masIds);
        }
        PagingVO<ExpTypeDTO> res = this.expTypeDomainService.page(expTypePageParam);
        return ApiResult.ok(ExpTypeConvert.INSTANCE.convertPage(res));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateEnableFlag(List<Long> ids, boolean enable) {
        List<ExpTypeDTO> expTypeDTOS = this.expTypeDomainService.findByIds(ids);
        if (enable) {
            this.checkEnableRule(expTypeDTOS);
        }
        if (!enable) {
            this.checkStopRule(expTypeDTOS);
        }
        Boolean res = this.expTypeDomainService.updateEnableFlag(ids, enable);
        return ApiResult.ok((Object)res);
    }

    @Override
    public ApiResult<Long> updateDef(Long id) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> del(Long id) {
        Long res = this.expTypeDomainService.del(id);
        return ApiResult.ok((Object)res);
    }

    @Override
    public ApiResult<List<ExpTypeVO>> getList() {
        return ApiResult.ok(ExpTypeConvert.INSTANCE.convertList(this.expTypeDomainService.getList()));
    }

    @Override
    public ApiResult<ExpTypeVO> getDef() {
        return null;
    }

    private void checkStopRule(List<ExpTypeDTO> expTypeDTOS) {
        for (ExpTypeDTO expTypeDTO : expTypeDTOS) {
            if (expTypeDTO.getEnableFlag().booleanValue()) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u505c\u7528\u72b6\u6001\u4e0d\u80fd\u518d\u505c\u7528");
        }
    }

    private void checkEnableRule(List<ExpTypeDTO> expTypeDTOS) {
        for (ExpTypeDTO expTypeDTO : expTypeDTOS) {
            if (!expTypeDTO.getEnableFlag().booleanValue()) continue;
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u518d\u542f\u52a8");
        }
    }

    public ExpTypeServiceImpl(ExpTypeDomainService expTypeDomainService, ExpTypeDtlDomainService expTypeDtlDomainService) {
        this.expTypeDomainService = expTypeDomainService;
        this.expTypeDtlDomainService = expTypeDtlDomainService;
    }
}

