/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.writeoff;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.convert.writeoff.FinApPayVerApplySettleConvert;
import com.elitesland.fin.application.facade.dto.writeoff.FinApPayVerApplySettleSaveDTO;
import com.elitesland.fin.application.facade.vo.writeoff.FinApPayVerApplySettleVO;
import com.elitesland.fin.application.service.writeoff.FinApPayVerApplySettleService;
import com.elitesland.fin.domain.entity.writeoff.FinApPayVerApplySettleDO;
import com.elitesland.fin.infr.dto.aporder.ApOrderDTO;
import com.elitesland.fin.infr.dto.payorder.PayOrderDTO;
import com.elitesland.fin.infr.repo.aporder.ApOrderRepoProc;
import com.elitesland.fin.infr.repo.payorder.PayOrderRepoProc;
import com.elitesland.fin.repo.writeoff.FinApPayVerApplySettleRepoProc;
import com.elitesland.fin.rpc.ystsupp.RmiOrgOuRpcServiceService;
import com.elitesland.support.provider.org.dto.OrgOuRpcSimpleDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class FinApPayVerApplySettleServiceImpl
implements FinApPayVerApplySettleService {
    private final FinApPayVerApplySettleRepoProc finApPayVerApplySettleRepoProc;
    private final ApOrderRepoProc apOrderRepoProc;
    private final PayOrderRepoProc payOrderRepoProc;
    private final RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatch(Long masId, List<FinApPayVerApplySettleSaveDTO> saveList) {
        Assert.notNull((Object)masId, (String)"\u4e3b\u8868ID\u4e0d\u80fd\u4e3aNull");
        if (CollectionUtils.isEmpty(saveList)) {
            return;
        }
        List<String> apDocNoList = saveList.stream().map(FinApPayVerApplySettleSaveDTO::getApDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<ApOrderDTO> apOrderDTOList = this.apOrderRepoProc.selectInOutCustByApOrderNo(apDocNoList);
        HashMap apOrderMap = CollectionUtil.isEmpty(apOrderDTOList) ? new HashMap() : apOrderDTOList.stream().collect(Collectors.toMap(ApOrderDTO::getApOrderNo, t -> t, (t1, t2) -> t1));
        List<String> payDocNoList = saveList.stream().map(FinApPayVerApplySettleSaveDTO::getPayDocNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<PayOrderDTO> payOrderDTOList = this.payOrderRepoProc.selectInOutCustByPayOrderNo(payDocNoList);
        HashMap payOrderMap = CollectionUtil.isEmpty(payOrderDTOList) ? new HashMap() : payOrderDTOList.stream().collect(Collectors.toMap(PayOrderDTO::getPayOrderNo, t -> t, (t1, t2) -> t1));
        this.finApPayVerApplySettleRepoProc.save(saveList.stream().map(e -> {
            PayOrderDTO payOrderDTO;
            FinApPayVerApplySettleDO entity = FinApPayVerApplySettleConvert.INSTANCE.save2Do((FinApPayVerApplySettleSaveDTO)e);
            entity.setMasId(masId);
            ApOrderDTO apOrderDTO = (ApOrderDTO)apOrderMap.get(entity.getApDocNo());
            if (Objects.nonNull(apOrderDTO)) {
                String inOutCust = StringUtils.isBlank((CharSequence)entity.getApInOutCust()) ? apOrderDTO.getInOutCust() : entity.getApInOutCust();
                String relevanceOuCode = StringUtils.isBlank((CharSequence)entity.getApRelevanceOuCode()) ? apOrderDTO.getRelevanceOuCode() : entity.getApRelevanceOuCode();
                String apSuppCode = StringUtils.isBlank((CharSequence)entity.getApSuppCode()) ? apOrderDTO.getSuppCode() : entity.getApSuppCode();
                entity.setApInOutCust(inOutCust);
                entity.setApRelevanceOuCode(relevanceOuCode);
                entity.setApSuppCode(apSuppCode);
            }
            if (Objects.nonNull(payOrderDTO = (PayOrderDTO)payOrderMap.get(entity.getPayDocNo()))) {
                String inOutCust = StringUtils.isBlank((CharSequence)entity.getPayInOutCust()) ? payOrderDTO.getInOutCust() : entity.getPayInOutCust();
                String relevanceOuCode = StringUtils.isBlank((CharSequence)entity.getPayRelevanceOuCode()) ? payOrderDTO.getRelevanceOuCode() : entity.getPayRelevanceOuCode();
                String paySuppCode = StringUtils.isBlank((CharSequence)entity.getPaySuppCode()) ? payOrderDTO.getSuppCode() : entity.getPaySuppCode();
                entity.setPayInOutCust(inOutCust);
                entity.setPayRelevanceOuCode(relevanceOuCode);
                entity.setPaySuppCode(paySuppCode);
            }
            return entity;
        }).collect(Collectors.toList()));
    }

    @Override
    public List<FinApPayVerApplySettleVO> listByMasIds(Collection<Long> masIds) {
        List<FinApPayVerApplySettleVO> finApPayVerApplySettleVOList = this.finApPayVerApplySettleRepoProc.listByMasIds(masIds).stream().map(FinApPayVerApplySettleConvert.INSTANCE::entity2Vo).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(finApPayVerApplySettleVOList)) {
            return Collections.EMPTY_LIST;
        }
        List apRelevanceOuCodeList = finApPayVerApplySettleVOList.stream().map(FinApPayVerApplySettleVO::getApRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List payRelevanceOuCodeList = finApPayVerApplySettleVOList.stream().map(FinApPayVerApplySettleVO::getPayRelevanceOuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> relevanceOuCodeAllList = Stream.of(apRelevanceOuCodeList, payRelevanceOuCodeList).flatMap(list -> list.stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, OrgOuRpcSimpleDTO> ouMap = this.rmiOrgOuRpcServiceService.findBaseOuMapByCodes(relevanceOuCodeAllList);
        if (CollectionUtil.isNotEmpty(finApPayVerApplySettleVOList)) {
            finApPayVerApplySettleVOList.forEach(v -> {
                OrgOuRpcSimpleDTO ouPayRpcSimpleDTO;
                OrgOuRpcSimpleDTO ouApRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getApRelevanceOuCode());
                if (Objects.nonNull(ouApRpcSimpleDTO)) {
                    v.setApRelevanceOuName(ouApRpcSimpleDTO.getOuName());
                }
                if (Objects.nonNull(ouPayRpcSimpleDTO = (OrgOuRpcSimpleDTO)ouMap.get(v.getPayRelevanceOuCode()))) {
                    v.setPayRelevanceOuName(ouPayRpcSimpleDTO.getOuName());
                }
            });
        }
        return finApPayVerApplySettleVOList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBatchNo(Collection<Long> masIds, String bachNo) {
        if (this.finApPayVerApplySettleRepoProc.updateBatchNo(masIds, bachNo) <= 0L) {
            throw new BusinessException("\u66f4\u65b0\u6838\u9500\u5904\u7406\u7f16\u53f7\u5931\u8d25!");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateVerFlag(Collection<Long> masIds, String verFlag) {
        if (this.finApPayVerApplySettleRepoProc.updateVerFlag(masIds, verFlag) <= 0L) {
            throw new BusinessException("\u66f4\u65b0\u6838\u9500\u5904\u7406\u7f16\u53f7\u5931\u8d25!");
        }
    }

    public FinApPayVerApplySettleServiceImpl(FinApPayVerApplySettleRepoProc finApPayVerApplySettleRepoProc, ApOrderRepoProc apOrderRepoProc, PayOrderRepoProc payOrderRepoProc, RmiOrgOuRpcServiceService rmiOrgOuRpcServiceService) {
        this.finApPayVerApplySettleRepoProc = finApPayVerApplySettleRepoProc;
        this.apOrderRepoProc = apOrderRepoProc;
        this.payOrderRepoProc = payOrderRepoProc;
        this.rmiOrgOuRpcServiceService = rmiOrgOuRpcServiceService;
    }
}

