/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.web.expense;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigQueryParam;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigSaveParam;
import com.elitesland.fin.application.facade.param.expense.ExpRuleConfigSortParam;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigPageVO;
import com.elitesland.fin.application.facade.vo.expense.ExpRuleConfigQueryVO;
import com.elitesland.fin.application.service.expense.ExpenseRuleConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fin/expense/rule"})
@Api(value="\u8d39\u7528\u8ba1\u7b97\u89c4\u5219\u914d\u7f6e", tags={"\u8d39\u7528\u8ba1\u7b97\u89c4\u5219\u914d\u7f6e"})
public class ExpenseRuleController {
    private final ExpenseRuleConfigService expenseRuleConfigService;

    @PostMapping(value={"/page"})
    @ApiOperation(value="\u8d39\u7528\u8ba1\u7b97\u89c4\u5219\u914d\u7f6e-\u5206\u9875\u67e5\u8be2")
    public ApiResult<PagingVO<ExpRuleConfigPageVO>> page(@RequestBody ExpRuleConfigQueryParam param) {
        PagingVO<ExpRuleConfigPageVO> ret = this.expenseRuleConfigService.searchPage(param);
        return ApiResult.ok(ret);
    }

    @PostMapping(value={"/detail/{id}"})
    @ApiOperation(value="\u8d39\u7528\u8ba1\u7b97\u89c4\u5219\u914d\u7f6e-\u8be6\u60c5")
    public ApiResult<ExpRuleConfigQueryVO> detail(@PathVariable(value="id") Long id) {
        ExpRuleConfigQueryVO ret = this.expenseRuleConfigService.detail(id);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/getList/{code}"})
    @ApiOperation(value="\u8d39\u7528\u8ba1\u7b97\u89c4\u5219\u914d\u7f6e-\u83b7\u53d6\u6392\u5e8f\u6570\u636e")
    public ApiResult<List<ExpRuleConfigQueryVO>> getList(@PathVariable(value="code") String code) {
        List<ExpRuleConfigQueryVO> ret = this.expenseRuleConfigService.getList(code);
        return ApiResult.ok(ret);
    }

    @PostMapping(value={"/getList/expType"})
    @ApiOperation(value="\u8d39\u7528\u8ba1\u7b97\u89c4\u5219\u914d\u7f6e-\u83b7\u53d6\u8d39\u7528\u7c7b\u578b\u5217\u8868")
    public ApiResult<List<ExpRuleConfigQueryVO>> getExpTypeList() {
        List<ExpRuleConfigQueryVO> ret = this.expenseRuleConfigService.getExpTypeList();
        return ApiResult.ok(ret);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u8d39\u7528\u8ba1\u7b97\u89c4\u5219\u914d\u7f6e-\u4fdd\u5b58/\u66f4\u65b0")
    public ApiResult<Void> save(@RequestBody ExpRuleConfigSaveParam param) {
        this.expenseRuleConfigService.saveOrUpdate(param);
        return ApiResult.ok();
    }

    @PostMapping(value={"/sort"})
    @ApiOperation(value="\u8d39\u7528\u8ba1\u7b97\u89c4\u5219\u914d\u7f6e-\u6392\u5e8f")
    public ApiResult<Void> sort(@RequestBody List<ExpRuleConfigSortParam> param) {
        this.expenseRuleConfigService.sort(param);
        return ApiResult.ok();
    }

    @GetMapping(value={"/del/{masId}"})
    @ApiOperation(value="\u8d39\u7528\u8ba1\u7b97\u89c4\u5219\u914d\u7f6e-\u5220\u9664")
    public ApiResult<Void> del(@PathVariable(value="masId") Long masId) {
        this.expenseRuleConfigService.del(masId);
        return ApiResult.ok();
    }

    @PostMapping(value={"/enable"})
    @ApiOperation(value="\u542f\u7528/\u72b6\u6001\u6279\u91cf\u4fee\u6539")
    public ApiResult<Void> enable(@RequestBody List<Long> ids) {
        this.expenseRuleConfigService.updateEnableFlag(ids, true);
        return ApiResult.ok();
    }

    @PostMapping(value={"/stop"})
    @ApiOperation(value="\u505c\u7528/\u72b6\u6001\u6279\u91cf\u4fee\u6539")
    public ApiResult<Void> stop(@RequestBody List<Long> ids) {
        this.expenseRuleConfigService.updateEnableFlag(ids, false);
        return ApiResult.ok();
    }

    public ExpenseRuleController(ExpenseRuleConfigService expenseRuleConfigService) {
        this.expenseRuleConfigService = expenseRuleConfigService;
    }
}

