/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.accountingengine;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.convert.accountingengine.FinFastCodeLineConvert;
import com.elitesland.fin.application.facade.base.BaseModelDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinFastCodeDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinFastCodeLineDTO;
import com.elitesland.fin.application.facade.param.accountingengine.FinFastCodeParam;
import com.elitesland.fin.domain.entity.accountingengine.FinFastCodeDO;
import com.elitesland.fin.domain.entity.accountingengine.QFinFastCodeDO;
import com.elitesland.fin.repo.accountingengine.FinFastCodeLineRepo;
import com.elitesland.fin.repo.accountingengine.FinFastCodeRepo;
import com.elitesland.fin.utils.StringUtil;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class FinFastCodeRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final FinFastCodeRepo finFastCodeRepo;
    private final FinFastCodeLineRepo finFastCodeLineRepo;
    private final QFinFastCodeDO qFinFastCodeDO = QFinFastCodeDO.finFastCodeDO;

    public PagingVO<FinFastCodeDTO> page(FinFastCodeParam finFastCodeParam) {
        Predicate where = this.where(finFastCodeParam);
        JPAQuery query = (JPAQuery)this.select(FinFastCodeDTO.class).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{where}));
        finFastCodeParam.setPaging(query);
        finFastCodeParam.fillOrders(query, this.qFinFastCodeDO);
        List finFastCodeDTOList = query.fetch();
        List<Long> ids = finFastCodeDTOList.stream().map(BaseModelDTO::getId).collect(Collectors.toList());
        List<FinFastCodeLineDTO> finFastCodeLineDTOList = FinFastCodeLineConvert.INSTANCE.DOToDTO(this.finFastCodeLineRepo.findAllByMasIdIn(ids));
        for (FinFastCodeDTO finFastCodeDTO : finFastCodeDTOList) {
            finFastCodeDTO.setFinFastCodeLineDetailList(finFastCodeLineDTOList.stream().filter(finFastCodeLineDTO -> finFastCodeDTO.getId().equals(finFastCodeLineDTO.getMasId())).collect(Collectors.toList()));
        }
        return PagingVO.builder().total((long)finFastCodeDTOList.size()).records(finFastCodeDTOList).build();
    }

    private Predicate where(FinFastCodeParam finFastCodeParam) {
        return BaseRepoProc.PredicateBuilder.builder().andEq(finFastCodeParam.getId() != null, this.qFinFastCodeDO.id, (Object)finFastCodeParam.getId()).andLike(StringUtils.isNotEmpty((CharSequence)finFastCodeParam.getFastCode()), (StringExpression)this.qFinFastCodeDO.fastCode, StringUtil.buildLikeString(finFastCodeParam.getFastCode())).andLike(StringUtils.isNotEmpty((CharSequence)finFastCodeParam.getFastName()), (StringExpression)this.qFinFastCodeDO.fastName, StringUtil.buildLikeString(finFastCodeParam.getFastName())).andEq(StringUtils.isNotEmpty((CharSequence)finFastCodeParam.getStatus()), (SimpleExpression)this.qFinFastCodeDO.status, (Object)finFastCodeParam.getStatus()).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qFinFastCodeDO.id, this.qFinFastCodeDO.fastCode, this.qFinFastCodeDO.fastName, this.qFinFastCodeDO.status, this.qFinFastCodeDO.createTime, this.qFinFastCodeDO.creator, this.qFinFastCodeDO.modifyTime, this.qFinFastCodeDO.updater})).from((EntityPath)this.qFinFastCodeDO);
    }

    public FinFastCodeDO findByFastCode(String finFastCode) {
        List<FinFastCodeDO> finFastCodeDOList = this.finFastCodeRepo.findAllByFastCode(finFastCode);
        if (CollectionUtils.isNotEmpty(finFastCodeDOList)) {
            Assert.equals((Object)finFastCodeDOList.size(), (Object)1, (String)"\u67e5\u8be2\u5230\u591a\u6761\u5feb\u7801", (Object[])new Object[0]);
            return finFastCodeDOList.get(0);
        }
        return null;
    }

    public List<FinFastCodeDO> findAllByFastCodeIn(List<String> finFastCodeList) {
        if (CollectionUtils.isEmpty(finFastCodeList)) {
            return Lists.newArrayList();
        }
        List<FinFastCodeDO> finFastCodeDOList = this.finFastCodeRepo.findAllByFastCodeIn(finFastCodeList);
        Assert.notEmpty(finFastCodeDOList, (String)"\u67e5\u4e0d\u5230\u5feb\u7801", (Object[])new Object[0]);
        return finFastCodeDOList;
    }

    public List<FinFastCodeDO> findAllByFastCodeInAndStatus(List<String> finFastCodeList, String status) {
        if (CollectionUtils.isEmpty(finFastCodeList)) {
            return Lists.newArrayList();
        }
        List<FinFastCodeDO> finFastCodeDOList = this.finFastCodeRepo.findAllByFastCodeInAndStatus(finFastCodeList, status);
        Assert.notEmpty(finFastCodeDOList, (String)"\u67e5\u4e0d\u5230\u5feb\u7801", (Object[])new Object[0]);
        return finFastCodeDOList;
    }

    public FinFastCodeRepoProc(JPAQueryFactory jpaQueryFactory, FinFastCodeRepo finFastCodeRepo, FinFastCodeLineRepo finFastCodeLineRepo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.finFastCodeRepo = finFastCodeRepo;
        this.finFastCodeLineRepo = finFastCodeLineRepo;
    }
}

