/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.flow;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.core.support.customfield.service.impl.CustomFieldJpaServiceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.application.facade.param.flow.AccountFlowPageParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowParam;
import com.elitesland.fin.application.facade.param.flow.AccountFlowQueryParam;
import com.elitesland.fin.application.facade.param.saobei.param.SaoBeiTransParam;
import com.elitesland.fin.application.facade.vo.flow.AccountFlowVO;
import com.elitesland.fin.application.facade.vo.saobei.SaoBeiTransVO;
import com.elitesland.fin.common.FinConstant;
import com.elitesland.fin.common.FinPushInter;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.flow.AccountFlowDO;
import com.elitesland.fin.entity.flow.QAccountFlowDO;
import com.elitesland.fin.entity.push.QFinPushResultDO;
import com.elitesland.fin.utils.BusinessSecurityUtil;
import com.elitesland.fin.utils.PartitionJpaUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class AccountFlowRepoProc
extends BaseRepoProc<AccountFlowDO> {
    private static final QAccountFlowDO qAccountFlowDO = QAccountFlowDO.accountFlowDO;

    public AccountFlowRepoProc() {
        super((EntityPathBase)qAccountFlowDO);
    }

    public PagingVO<AccountFlowVO> page(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = this.where(accountFlowPageParam);
        JPAQuery query = (JPAQuery)this.select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        BusinessSecurityUtil.where(query, AccountFlowDO.class);
        PartitionJpaUtil.appendYmConditionToPredicate(query, AccountFlowDO.class, accountFlowPageParam);
        if (accountFlowPageParam.getBipPushTimeEnd() != null || accountFlowPageParam.getBipPushTimeStart() != null || CharSequenceUtil.isNotBlank((CharSequence)accountFlowPageParam.getBipPushResult())) {
            QFinPushResultDO BIP = QFinPushResultDO.finPushResultDO;
            ((JPAQuery)query.leftJoin((EntityPath)BIP)).on((Predicate)BIP.docId.eq(AccountFlowRepoProc.qAccountFlowDO.id).and((Predicate)BIP.interCode.eq((Object)FinPushInter.BIP_FIN_PAY_ACCOUNT_FLOW_STORAGE_SAVE.getInterCode())));
            Predicate predicateBIP = BaseRepoProc.PredicateBuilder.builder().andBetween(BIP.pushTimeLast, (Comparable)accountFlowPageParam.getBipPushTimeStart(), (Comparable)accountFlowPageParam.getBipPushTimeEnd()).andEq((SimpleExpression)BIP.pushResult, (Object)accountFlowPageParam.getBipPushResult()).build();
            query.where(predicateBIP);
        }
        accountFlowPageParam.setPaging(query);
        accountFlowPageParam.fillOrders(query, qAccountFlowDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public AccountFlowVO selectByAccCode(String accCode) {
        return (AccountFlowVO)((Object)((JPAQuery)((JPAQuery)((JPAQuery)this.select(AccountFlowVO.class).where((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountCode.eq((Object)accCode))).where((Predicate)AccountFlowRepoProc.qAccountFlowDO.deleteFlag.eq((Object)0).or((Predicate)AccountFlowRepoProc.qAccountFlowDO.deleteFlag.isNull()))).orderBy(AccountFlowRepoProc.qAccountFlowDO.createTime.desc())).fetchFirst());
    }

    public List<AccountFlowVO> selectListByParam(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = this.where(accountFlowPageParam);
        JPAQuery query = (JPAQuery)this.select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        return query.fetch();
    }

    private List<Predicate> where(AccountFlowPageParam accountFlowPageParam) {
        Predicate customFieldPredicate;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccountHolderName())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountHolderName.eq((Object)accountFlowPageParam.getAccountHolderName()));
        }
        if (CollectionUtils.isNotEmpty(accountFlowPageParam.getAccountHolderNameList())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountHolderName.in(accountFlowPageParam.getAccountHolderNameList()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccountName())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountName.like(accountFlowPageParam.getAccountName()));
        }
        if (CollectionUtils.isNotEmpty(accountFlowPageParam.getAccountNameList())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountName.in(accountFlowPageParam.getAccountNameList()));
        }
        if (CollectionUtils.isNotEmpty(accountFlowPageParam.getAccountCodeList())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountCode.in(accountFlowPageParam.getAccountCodeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccountCode())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountCode.eq((Object)accountFlowPageParam.getAccountCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getTransactionType())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.transactionType.eq((Object)accountFlowPageParam.getTransactionType()));
        }
        if (accountFlowPageParam.getTransactionTimeS() != null) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.transactionTime.goe((Comparable)accountFlowPageParam.getTransactionTimeS()));
        }
        if (accountFlowPageParam.getTransactionTimeE() != null) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.transactionTime.loe((Comparable)accountFlowPageParam.getTransactionTimeE()));
        }
        if (accountFlowPageParam.getAuditDateS() != null) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.auditDate.goe((Comparable)accountFlowPageParam.getAuditDateS()));
        }
        if (accountFlowPageParam.getAuditDateE() != null) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.auditDate.loe((Comparable)accountFlowPageParam.getAuditDateE()));
        }
        if (accountFlowPageParam.getAmountFrom() != null) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.amount.goe((Number)accountFlowPageParam.getAmountFrom()));
        }
        if (accountFlowPageParam.getAmountTo() != null) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.amount.loe((Number)accountFlowPageParam.getAmountTo()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getSecFranchiseeCode())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.secFranchiseeCode.eq((Object)accountFlowPageParam.getSecFranchiseeCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)accountFlowPageParam.getAccountType())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountType.eq((Object)accountFlowPageParam.getAccountType()));
        }
        if (StrUtil.isNotBlank((CharSequence)accountFlowPageParam.getSourceNo())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.sourceNo.eq((Object)accountFlowPageParam.getSourceNo()));
        }
        if (StrUtil.isNotBlank((CharSequence)accountFlowPageParam.getFlowNo())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.flowNo.eq((Object)accountFlowPageParam.getFlowNo()));
        }
        if (CollectionUtil.isNotEmpty(accountFlowPageParam.getSourceDocList())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.sourceDoc.in(accountFlowPageParam.getSourceDocList()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getIds())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.id.in(accountFlowPageParam.getIds()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccType())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountType.eq((Object)accountFlowPageParam.getAccType()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getAccTypeList())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountType.in(accountFlowPageParam.getAccTypeList()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getFlowNoList())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.flowNo.in(accountFlowPageParam.getFlowNoList()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getTransactionTypeList())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.transactionType.in(accountFlowPageParam.getTransactionTypeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccKeyword())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountCode.like("%" + accountFlowPageParam.getAccKeyword() + "%").or((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountName.like("%" + accountFlowPageParam.getAccKeyword() + "%")));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccCode())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountCode.eq((Object)accountFlowPageParam.getAccCode()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getAccCodeList())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountCode.in(accountFlowPageParam.getAccCodeList()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getAccName())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountName.like("%" + accountFlowPageParam.getAccName() + "%"));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getSourceNoEq())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.sourceNo.eq((Object)accountFlowPageParam.getSourceNoEq()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getSourceNoList())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.sourceNo.in(accountFlowPageParam.getSourceNoList()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getSourceDoc())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.sourceDoc.eq((Object)accountFlowPageParam.getSourceDoc()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getBusinessType())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.businessType.eq((Object)accountFlowPageParam.getBusinessType()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getRelateFlowNo())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.relateFlowNo.eq((Object)accountFlowPageParam.getRelateFlowNo()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getSyncStatus())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.syncStatus.eq((Object)accountFlowPageParam.getSyncStatus()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getSyncStatus())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.syncStatus.eq((Object)accountFlowPageParam.getSyncStatus()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getSyncStatusList())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.syncStatus.in(accountFlowPageParam.getSyncStatusList()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getToAccountNo())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.toAccountNo.eq((Object)accountFlowPageParam.getToAccountNo()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getFromOuCode())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.fromOuCode.eq((Object)accountFlowPageParam.getFromOuCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getToOuCode())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.toOuCode.eq((Object)accountFlowPageParam.getToOuCode()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getRootDoc())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.rootDoc.eq((Object)accountFlowPageParam.getRootDoc()));
        }
        if (!StringUtils.isEmpty((CharSequence)accountFlowPageParam.getRootDocNo())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.rootDocNo.eq((Object)accountFlowPageParam.getRootDocNo()));
        }
        if (!CollectionUtils.isEmpty(accountFlowPageParam.getOptTypeList())) {
            ArrayList<String> sourceDocStatusList = new ArrayList<String>();
            if (accountFlowPageParam.getOptTypeList().contains(UdcEnum.FLOW_OPT_TYPE_PAY.getValueCode())) {
                sourceDocStatusList.addAll(FinConstant.ACCOUNT_FLOW_TYPE_PAY);
            }
            if (accountFlowPageParam.getOptTypeList().contains(UdcEnum.FLOW_OPT_TYPE_CLOSE.getValueCode())) {
                sourceDocStatusList.addAll(FinConstant.ACCOUNT_FLOW_TYPE_CLOSE);
            }
            if (accountFlowPageParam.getOptTypeList().contains(UdcEnum.FLOW_OPT_TYPE_RETURN.getValueCode())) {
                sourceDocStatusList.addAll(FinConstant.ACCOUNT_FLOW_TYPE_RETURN);
            }
            if (accountFlowPageParam.getOptTypeList().contains(UdcEnum.FLOW_OPT_TYPE_REFUND.getValueCode())) {
                sourceDocStatusList.addAll(FinConstant.ACCOUNT_FLOW_TYPE_REFUND);
            }
            if (accountFlowPageParam.getOptTypeList().contains(UdcEnum.FLOW_OPT_TYPE_AO.getValueCode())) {
                sourceDocStatusList.addAll(FinConstant.ACCOUNT_FLOW_TYPE_AO_ALL);
            }
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.sourceDocStatus.in(sourceDocStatusList));
        }
        if ((customFieldPredicate = CustomFieldJpaServiceUtil.getPredicate((List)accountFlowPageParam.getConditions(), AccountFlowDO.class)) != null) {
            predicates.add(customFieldPredicate);
        }
        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{AccountFlowRepoProc.qAccountFlowDO.id, AccountFlowRepoProc.qAccountFlowDO.accountType, AccountFlowRepoProc.qAccountFlowDO.flowNo, AccountFlowRepoProc.qAccountFlowDO.transactionType, AccountFlowRepoProc.qAccountFlowDO.amount, AccountFlowRepoProc.qAccountFlowDO.transactionTime, AccountFlowRepoProc.qAccountFlowDO.accountCode, AccountFlowRepoProc.qAccountFlowDO.accountName, AccountFlowRepoProc.qAccountFlowDO.accountAmount, AccountFlowRepoProc.qAccountFlowDO.accountOccupancyAmount, AccountFlowRepoProc.qAccountFlowDO.sourceNo, AccountFlowRepoProc.qAccountFlowDO.sourceDoc, AccountFlowRepoProc.qAccountFlowDO.remark, AccountFlowRepoProc.qAccountFlowDO.createTime, AccountFlowRepoProc.qAccountFlowDO.createUserId, AccountFlowRepoProc.qAccountFlowDO.creator, AccountFlowRepoProc.qAccountFlowDO.modifyTime, AccountFlowRepoProc.qAccountFlowDO.modifyUserId, AccountFlowRepoProc.qAccountFlowDO.updater, AccountFlowRepoProc.qAccountFlowDO.deleteFlag, AccountFlowRepoProc.qAccountFlowDO.companyCode, AccountFlowRepoProc.qAccountFlowDO.secFranchiseeCode, AccountFlowRepoProc.qAccountFlowDO.accountType, AccountFlowRepoProc.qAccountFlowDO.accountCode, AccountFlowRepoProc.qAccountFlowDO.accountName, AccountFlowRepoProc.qAccountFlowDO.accountAmount, AccountFlowRepoProc.qAccountFlowDO.accountOccupancyAmount, AccountFlowRepoProc.qAccountFlowDO.accountAvailableAmount, AccountFlowRepoProc.qAccountFlowDO.auditUserId, AccountFlowRepoProc.qAccountFlowDO.auditUserName, AccountFlowRepoProc.qAccountFlowDO.auditDate, AccountFlowRepoProc.qAccountFlowDO.orderState, AccountFlowRepoProc.qAccountFlowDO.accountHolderName, AccountFlowRepoProc.qAccountFlowDO.ruleCode, AccountFlowRepoProc.qAccountFlowDO.priorityNo, AccountFlowRepoProc.qAccountFlowDO.extensionInfo, AccountFlowRepoProc.qAccountFlowDO.businessType, AccountFlowRepoProc.qAccountFlowDO.tOuCode.as("touCode"), AccountFlowRepoProc.qAccountFlowDO.relateFlowNo, AccountFlowRepoProc.qAccountFlowDO.syncStatus, AccountFlowRepoProc.qAccountFlowDO.syncLog, AccountFlowRepoProc.qAccountFlowDO.fromAccountNo, AccountFlowRepoProc.qAccountFlowDO.toAccountNo, AccountFlowRepoProc.qAccountFlowDO.fromOuCode, AccountFlowRepoProc.qAccountFlowDO.toOuCode, AccountFlowRepoProc.qAccountFlowDO.rootDoc, AccountFlowRepoProc.qAccountFlowDO.rootDocNo, AccountFlowRepoProc.qAccountFlowDO.sourceDocStatus})).from((EntityPath)qAccountFlowDO);
    }

    public PagingVO<AccountFlowVO> dealerPage(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = this.where(accountFlowPageParam);
        JPAQuery query = (JPAQuery)this.dealerSelect(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        accountFlowPageParam.setPaging(query);
        accountFlowPageParam.fillOrders(query, qAccountFlowDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private <T> JPAQuery<T> dealerSelect(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{AccountFlowRepoProc.qAccountFlowDO.id, AccountFlowRepoProc.qAccountFlowDO.flowNo, AccountFlowRepoProc.qAccountFlowDO.transactionType, AccountFlowRepoProc.qAccountFlowDO.amount, AccountFlowRepoProc.qAccountFlowDO.transactionTime, AccountFlowRepoProc.qAccountFlowDO.accountCode, AccountFlowRepoProc.qAccountFlowDO.accountName, AccountFlowRepoProc.qAccountFlowDO.sourceNo, AccountFlowRepoProc.qAccountFlowDO.sourceDoc})).from((EntityPath)qAccountFlowDO);
    }

    public List<AccountFlowVO> dealerSelectAmt(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = this.where(accountFlowPageParam);
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccountFlowVO.class, (Expression[])new Expression[]{AccountFlowRepoProc.qAccountFlowDO.id, AccountFlowRepoProc.qAccountFlowDO.amount})).from((EntityPath)qAccountFlowDO);
        jpaQuery.where(ExpressionUtils.allOf(where));
        return jpaQuery.fetch();
    }

    public void approveAccountFlow(AccountFlowParam accountFlowParam) {
        this.jpaQueryFactory.update((EntityPath)qAccountFlowDO).set((Path)AccountFlowRepoProc.qAccountFlowDO.orderState, (Object)accountFlowParam.getOrderState()).set(AccountFlowRepoProc.qAccountFlowDO.auditUserId, (Object)accountFlowParam.getAuditUserId()).set((Path)AccountFlowRepoProc.qAccountFlowDO.auditUserName, (Object)accountFlowParam.getAuditUserName()).set(AccountFlowRepoProc.qAccountFlowDO.auditDate, (Object)accountFlowParam.getAuditDate()).where(new Predicate[]{AccountFlowRepoProc.qAccountFlowDO.id.eq((Object)accountFlowParam.getId())}).execute();
    }

    public List<AccountFlowVO> queryByAccountFlowQueryParam(AccountFlowQueryParam accountFlowQueryParam) {
        JPAQuery<AccountFlowVO> query = this.select(AccountFlowVO.class);
        if (accountFlowQueryParam.getSourceId() != null) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.sourceId.eq((Object)accountFlowQueryParam.getSourceId()));
        }
        if (accountFlowQueryParam.getSourceNo() != null) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.sourceNo.eq((Object)accountFlowQueryParam.getSourceNo()));
        }
        if (StringUtils.isNotEmpty((CharSequence)accountFlowQueryParam.getSourceDoc())) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.sourceDoc.eq((Object)accountFlowQueryParam.getSourceDoc()));
        }
        if (StringUtils.isNotEmpty((CharSequence)accountFlowQueryParam.getSourceDocStatus())) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.sourceDocStatus.eq((Object)accountFlowQueryParam.getSourceDocStatus()));
        }
        if (StringUtils.isNotEmpty((CharSequence)accountFlowQueryParam.getAccountType())) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountType.eq((Object)accountFlowQueryParam.getAccountType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)accountFlowQueryParam.getAccountCode())) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountCode.eq((Object)accountFlowQueryParam.getAccountCode()));
        }
        return query.fetch();
    }

    public void updateAccountFlowAmount(AccountFlowParam accountFlowParam) {
        this.jpaQueryFactory.update((EntityPath)qAccountFlowDO).set(AccountFlowRepoProc.qAccountFlowDO.accountAmount, (Object)accountFlowParam.getAccountAmount()).set(AccountFlowRepoProc.qAccountFlowDO.accountOccupancyAmount, (Object)accountFlowParam.getAccountOccupancyAmount()).set(AccountFlowRepoProc.qAccountFlowDO.accountAvailableAmount, (Object)accountFlowParam.getAccountAvailableAmount()).where(new Predicate[]{AccountFlowRepoProc.qAccountFlowDO.accountCode.eq((Object)accountFlowParam.getAccountCode()).and((Predicate)AccountFlowRepoProc.qAccountFlowDO.orderState.eq((Object)accountFlowParam.getOrderState()))}).execute();
    }

    public void updateAccountFlowAmountById(AccountFlowParam accountFlowParam) {
        this.jpaQueryFactory.update((EntityPath)qAccountFlowDO).set(AccountFlowRepoProc.qAccountFlowDO.accountAmount, (Object)accountFlowParam.getAccountAmount()).set(AccountFlowRepoProc.qAccountFlowDO.accountOccupancyAmount, (Object)accountFlowParam.getAccountOccupancyAmount()).set(AccountFlowRepoProc.qAccountFlowDO.accountAvailableAmount, (Object)accountFlowParam.getAccountAvailableAmount()).set((Path)AccountFlowRepoProc.qAccountFlowDO.orderState, (Object)accountFlowParam.getOrderState()).set(AccountFlowRepoProc.qAccountFlowDO.auditUserId, (Object)accountFlowParam.getAuditUserId()).set((Path)AccountFlowRepoProc.qAccountFlowDO.auditUserName, (Object)accountFlowParam.getAuditUserName()).set(AccountFlowRepoProc.qAccountFlowDO.auditDate, (Object)accountFlowParam.getAuditDate()).where(new Predicate[]{AccountFlowRepoProc.qAccountFlowDO.id.eq((Object)accountFlowParam.getId()).and((Predicate)AccountFlowRepoProc.qAccountFlowDO.orderState.eq((Object)accountFlowParam.getOrderState()))}).execute();
    }

    public List<AccountFlowVO> selectListByQueryParam(AccountFlowQueryParam queryParam) {
        JPAQuery<AccountFlowVO> query = this.select(AccountFlowVO.class);
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getSourceNo())) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.sourceNo.eq((Object)queryParam.getSourceNo()));
        }
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getAccountType())) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountType.eq((Object)queryParam.getAccountType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getFlowNo())) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.flowNo.eq((Object)queryParam.getFlowNo()));
        }
        if (!CollectionUtils.isEmpty(queryParam.getFlowNoList())) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.flowNo.in(queryParam.getFlowNoList()));
        }
        if (!CollectionUtils.isEmpty(queryParam.getAccountCodeList())) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountCode.in(queryParam.getAccountCodeList()));
        }
        return query.fetch();
    }

    public AccountFlowVO selectPreviousRepairAmtByParam(AccountFlowQueryParam flowQueryParam) {
        JPAQuery<AccountFlowVO> query = this.select(AccountFlowVO.class);
        if (!StringUtils.isEmpty((CharSequence)flowQueryParam.getAccountCode())) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountCode.eq((Object)flowQueryParam.getAccountCode()));
        }
        query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.auditDate.isNotNull());
        return (AccountFlowVO)((Object)((JPAQuery)query.orderBy(AccountFlowRepoProc.qAccountFlowDO.auditDate.desc())).fetchFirst());
    }

    public List<AccountFlowVO> selectRepairAfterPage(AccountFlowPageParam flowPageParam) {
        List<Predicate> where = this.selectRepairAfterPageWhere(flowPageParam);
        JPAQuery query = (JPAQuery)this.select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        query.orderBy(AccountFlowRepoProc.qAccountFlowDO.auditDate.desc());
        flowPageParam.setPaging(query);
        return query.fetch();
    }

    private List<Predicate> selectRepairAfterPageWhere(AccountFlowPageParam pageParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.auditDate.isNotNull());
        if (!CollectionUtils.isEmpty(pageParam.getFlowNoList())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.flowNo.in(pageParam.getFlowNoList()));
        }
        if (Objects.nonNull(pageParam.getRepairTime())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.auditDate.gt((Comparable)pageParam.getRepairTime()));
        }
        if (!StringUtils.isEmpty((CharSequence)pageParam.getAccountCode())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountCode.eq((Object)pageParam.getAccountCode()));
        }
        if (!CollectionUtils.isEmpty(pageParam.getAccountCodeList())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountCode.in(pageParam.getAccountCodeList()));
        }
        return predicates;
    }

    public List<AccountFlowVO> selectRepairAfter(AccountFlowPageParam flowPageParam) {
        List<Predicate> where = this.selectRepairAfterWhere(flowPageParam);
        JPAQuery query = (JPAQuery)this.select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        query.orderBy(AccountFlowRepoProc.qAccountFlowDO.auditDate.desc());
        return query.fetch();
    }

    private List<Predicate> selectRepairAfterWhere(AccountFlowPageParam pageParam) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.auditDate.isNotNull());
        if (!CollectionUtils.isEmpty(pageParam.getFlowNoList())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.flowNo.in(pageParam.getFlowNoList()));
        }
        if (Objects.nonNull(pageParam.getRepairTime())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.auditDate.goe((Comparable)pageParam.getRepairTime()));
        }
        if (!StringUtils.isEmpty((CharSequence)pageParam.getAccountCode())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountCode.eq((Object)pageParam.getAccountCode()));
        }
        if (!CollectionUtils.isEmpty(pageParam.getAccountCodeList())) {
            predicates.add((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountCode.in(pageParam.getAccountCodeList()));
        }
        return predicates;
    }

    public void updateOccupancyAndAvailableAndAmountById(BigDecimal accountOccupancyAmount, BigDecimal accountAvailableAmount, BigDecimal amount, Long id) {
        this.jpaQueryFactory.update((EntityPath)qAccountFlowDO).set(AccountFlowRepoProc.qAccountFlowDO.accountOccupancyAmount, (Object)accountOccupancyAmount).set(AccountFlowRepoProc.qAccountFlowDO.accountAvailableAmount, (Object)accountAvailableAmount).set(AccountFlowRepoProc.qAccountFlowDO.amount, (Object)amount).where(new Predicate[]{AccountFlowRepoProc.qAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public void updateAccountAndAvailableAndAmountById(BigDecimal accountAmount, BigDecimal accountAvailableAmount, BigDecimal amount, Long id) {
        this.jpaQueryFactory.update((EntityPath)qAccountFlowDO).set(AccountFlowRepoProc.qAccountFlowDO.accountAmount, (Object)accountAmount).set(AccountFlowRepoProc.qAccountFlowDO.accountAvailableAmount, (Object)accountAvailableAmount).set(AccountFlowRepoProc.qAccountFlowDO.amount, (Object)amount).where(new Predicate[]{AccountFlowRepoProc.qAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public void updateOccupancyAndAvailableById(BigDecimal accountOccupancyAmount, BigDecimal accountAvailableAmount, Long id) {
        this.jpaQueryFactory.update((EntityPath)qAccountFlowDO).set(AccountFlowRepoProc.qAccountFlowDO.accountOccupancyAmount, (Object)accountOccupancyAmount).set(AccountFlowRepoProc.qAccountFlowDO.accountAvailableAmount, (Object)accountAvailableAmount).where(new Predicate[]{AccountFlowRepoProc.qAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public void updateAccountAndAvailableById(BigDecimal accountAmount, BigDecimal accountAvailableAmount, Long id) {
        this.jpaQueryFactory.update((EntityPath)qAccountFlowDO).set(AccountFlowRepoProc.qAccountFlowDO.accountAmount, (Object)accountAmount).set(AccountFlowRepoProc.qAccountFlowDO.accountAvailableAmount, (Object)accountAvailableAmount).where(new Predicate[]{AccountFlowRepoProc.qAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public PagingVO<AccountFlowVO> appPage(AccountFlowPageParam accountFlowPageParam) {
        List<Predicate> where = this.where(accountFlowPageParam);
        JPAQuery query = (JPAQuery)this.select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        accountFlowPageParam.setPaging(query);
        accountFlowPageParam.fillOrders(query, qAccountFlowDO);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public List<AccountFlowVO> appList(AccountFlowPageParam pageParam) {
        List<Predicate> where = this.where(pageParam);
        JPAQuery query = (JPAQuery)this.select(AccountFlowVO.class).where(ExpressionUtils.allOf(where));
        pageParam.fillOrders(query, qAccountFlowDO);
        return query.fetch();
    }

    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> ids) {
        this.jpaQueryFactory.update((EntityPath)qAccountFlowDO).set(AccountFlowRepoProc.qAccountFlowDO.deleteFlag, (Object)deleteFlag).where(new Predicate[]{AccountFlowRepoProc.qAccountFlowDO.id.in(ids)}).execute();
    }

    public List<AccountFlowVO> findBySourceIds(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccountFlowVO.class, (Expression[])new Expression[]{AccountFlowRepoProc.qAccountFlowDO.id, AccountFlowRepoProc.qAccountFlowDO.accountCode, AccountFlowRepoProc.qAccountFlowDO.sourceId, AccountFlowRepoProc.qAccountFlowDO.sourceNo})).from((EntityPath)qAccountFlowDO)).where((Predicate)AccountFlowRepoProc.qAccountFlowDO.sourceId.in(ids))).fetch();
    }

    public List<AccountFlowDO> listBySourceId(long sourceId) {
        return super.getList((Predicate)AccountFlowRepoProc.qAccountFlowDO.sourceId.eq((Object)sourceId), new OrderSpecifier[0]);
    }

    private <T> JPAQuery<T> selectSaoBei(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{AccountFlowRepoProc.qAccountFlowDO.id, AccountFlowRepoProc.qAccountFlowDO.flowNo, AccountFlowRepoProc.qAccountFlowDO.amount, AccountFlowRepoProc.qAccountFlowDO.accountType, AccountFlowRepoProc.qAccountFlowDO.sourceDocStatus, AccountFlowRepoProc.qAccountFlowDO.relateFlowNo, AccountFlowRepoProc.qAccountFlowDO.syncStatus, AccountFlowRepoProc.qAccountFlowDO.fromAccountNo, AccountFlowRepoProc.qAccountFlowDO.toAccountNo, AccountFlowRepoProc.qAccountFlowDO.fromOuCode, AccountFlowRepoProc.qAccountFlowDO.toOuCode, AccountFlowRepoProc.qAccountFlowDO.rootDoc, AccountFlowRepoProc.qAccountFlowDO.rootDocNo, AccountFlowRepoProc.qAccountFlowDO.businessType, AccountFlowRepoProc.qAccountFlowDO.sourceNo})).from((EntityPath)qAccountFlowDO);
    }

    public List<SaoBeiTransVO> selectSaoBeiTrans(SaoBeiTransParam param) {
        JPAQuery<SaoBeiTransVO> query = this.selectSaoBei(SaoBeiTransVO.class);
        if (CollectionUtils.isNotEmpty(param.getIds())) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.id.in(param.getIds()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSyncStatus())) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.syncStatus.eq((Object)param.getSyncStatus()));
        }
        if (CollectionUtils.isNotEmpty(param.getSourceDocStatusList())) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.sourceDocStatus.in(param.getSourceDocStatusList()));
        }
        if (CollectionUtils.isNotEmpty(param.getSyncStatusList())) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.syncStatus.in(param.getSyncStatusList()));
        }
        if (param.getCreateTimeFrom() != null) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.createTime.goe((Comparable)param.getCreateTimeFrom()));
        }
        if (param.getCreateTimeTo() != null) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.createTime.loe((Comparable)param.getCreateTimeTo()));
        }
        if (CollectionUtils.isNotEmpty(param.getRootDocNoList())) {
            query.where((Predicate)AccountFlowRepoProc.qAccountFlowDO.rootDocNo.in(param.getRootDocNoList()));
        }
        return query.fetch();
    }

    public void updateSaoBeiTransInfo(Long id, String relateFlowNo, String syncStatus, String syncLog) {
        this.jpaQueryFactory.update((EntityPath)qAccountFlowDO).set((Path)AccountFlowRepoProc.qAccountFlowDO.relateFlowNo, (Object)relateFlowNo).set((Path)AccountFlowRepoProc.qAccountFlowDO.syncStatus, (Object)syncStatus).set((Path)AccountFlowRepoProc.qAccountFlowDO.syncLog, (Object)syncLog).where(new Predicate[]{AccountFlowRepoProc.qAccountFlowDO.id.eq((Object)id)}).execute();
    }

    public AccountFlowDO getLatestFlowBeforeTime(String accountCode, String accountType, LocalDateTime transactionTime) {
        return (AccountFlowDO)((Object)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qAccountFlowDO).from((EntityPath)qAccountFlowDO)).where((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountCode.eq((Object)accountCode).and((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountType.eq((Object)accountType)).and((Predicate)AccountFlowRepoProc.qAccountFlowDO.transactionTime.lt((Comparable)transactionTime)))).orderBy(AccountFlowRepoProc.qAccountFlowDO.transactionTime.desc())).fetchFirst());
    }

    public AccountFlowDO getLatestFlowAfterTime(String accountCode, String accountType, LocalDateTime transactionTime) {
        return (AccountFlowDO)((Object)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qAccountFlowDO).from((EntityPath)qAccountFlowDO)).where((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountCode.eq((Object)accountCode).and((Predicate)AccountFlowRepoProc.qAccountFlowDO.accountType.eq((Object)accountType)).and((Predicate)AccountFlowRepoProc.qAccountFlowDO.transactionTime.gt((Comparable)transactionTime)))).orderBy(AccountFlowRepoProc.qAccountFlowDO.transactionTime.asc())).fetchFirst());
    }
}

