/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.repo.push;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.fin.application.facade.vo.push.FinPushResultVO;
import com.elitesland.fin.common.FinPushInter;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.entity.push.FinPushResultDO;
import com.elitesland.fin.entity.push.QFinPushResultDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class FinPushResultRepoProc
extends BaseRepoProc<FinPushResultDO> {
    private static final QFinPushResultDO QDO = QFinPushResultDO.finPushResultDO;

    public FinPushResultRepoProc() {
        super((EntityPathBase)QDO);
    }

    public Long getExistsRecord(@NotBlank String interCode, long docId) {
        return super.getIdByPredicate((Predicate)FinPushResultRepoProc.QDO.docId.eq((Object)docId).and((Predicate)FinPushResultRepoProc.QDO.interCode.eq((Object)interCode)), new OrderSpecifier[0]);
    }

    public FinPushResultDO getRecord(@NotBlank String interCode, long docId) {
        return (FinPushResultDO)((Object)super.getOne((Predicate)FinPushResultRepoProc.QDO.docId.eq((Object)docId).and((Predicate)FinPushResultRepoProc.QDO.interCode.eq((Object)interCode))));
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePushNoop(long id, String reason) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)FinPushResultRepoProc.QDO.failReason, (Object)reason).set(FinPushResultRepoProc.QDO.pushTimeLast, (Object)LocalDateTime.now()).set((Path)FinPushResultRepoProc.QDO.pushResult, (Object)UdcEnum.COM_PUSH_RESULT_NOOP.getValueCode()).where(new Predicate[]{FinPushResultRepoProc.QDO.id.eq((Object)id).and((Predicate)FinPushResultRepoProc.QDO.pushResult.ne((Object)UdcEnum.COM_PUSH_RESULT_SUCCESS.getValueCode()))}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePushFail(long id, String failReason) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)FinPushResultRepoProc.QDO.failReason, (Object)failReason).set(FinPushResultRepoProc.QDO.pushTimeLast, (Object)LocalDateTime.now()).set((Path)FinPushResultRepoProc.QDO.pushResult, (Object)UdcEnum.COM_PUSH_RESULT_FAIL.getValueCode()).where(new Predicate[]{FinPushResultRepoProc.QDO.id.eq((Object)id).and((Predicate)FinPushResultRepoProc.QDO.pushResult.ne((Object)UdcEnum.COM_PUSH_RESULT_SUCCESS.getValueCode()))}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePushSuccess(long id) {
        this.jpaQueryFactory.update((EntityPath)QDO).setNull((Path)FinPushResultRepoProc.QDO.failReason).set(FinPushResultRepoProc.QDO.pushTimeLast, (Object)LocalDateTime.now()).set((Path)FinPushResultRepoProc.QDO.pushResult, (Object)UdcEnum.COM_PUSH_RESULT_SUCCESS.getValueCode()).where(new Predicate[]{FinPushResultRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePushRecordId(long id, Long pushRecordId) {
        super.updateValue(FinPushResultRepoProc.QDO.pushRecordId, (Object)pushRecordId, id);
    }

    public Map<Long, FinPushResultVO> queryByDocId(@NotEmpty Collection<Long> docIds, @NotBlank FinPushInter inter) {
        QBean qbean = Projections.bean(FinPushResultVO.class, (Expression[])new Expression[]{FinPushResultRepoProc.QDO.docId, FinPushResultRepoProc.QDO.docNo, FinPushResultRepoProc.QDO.interCode, FinPushResultRepoProc.QDO.pushResult, FinPushResultRepoProc.QDO.pushTimeFirst, FinPushResultRepoProc.QDO.pushTimeLast, FinPushResultRepoProc.QDO.failReason, FinPushResultRepoProc.QDO.pushRecordId});
        return super.getList(qbean, (Predicate)FinPushResultRepoProc.QDO.docId.in(docIds).and((Predicate)FinPushResultRepoProc.QDO.interCode.eq((Object)inter.getInterCode())), new OrderSpecifier[0]).stream().collect(Collectors.toMap(FinPushResultVO::getDocId, v -> v, (v1, v2) -> v1));
    }
}

