/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.rpc.tms;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.rpc.tms.TmsOutService;
import com.elitesland.tms.api.provider.TmsProvider;
import com.elitesland.tms.api.vo.TmsOuQueryParamVO;
import com.elitesland.tms.api.vo.TmsOuRespVO;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TmsOutServiceImpl
implements TmsOutService {
    private static final Logger log = LoggerFactory.getLogger(TmsOutServiceImpl.class);
    private final TmsProvider tmsProvider;

    @Override
    public List<TmsOuRespVO> findTmsOuList(TmsOuQueryParamVO tmsOuQueryParamVO) {
        ApiResult apiResult = this.tmsProvider.findTmsOuList(tmsOuQueryParamVO);
        if (apiResult.isSuccess()) {
            List rpcDTOList = (List)apiResult.getData();
            if (CollectionUtil.isNotEmpty((Collection)rpcDTOList)) {
                return rpcDTOList;
            }
        } else {
            throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u7269\u6d41\u57df(findTmsOuList)\u67e5\u8be2\u5feb\u901f\u516c\u53f8\u5931\u8d25\uff1a" + apiResult.getErrorMsg());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<String, TmsOuRespVO> findTmsOuMapByCodes(List<String> logisticsOuCodes) {
        if (CollectionUtil.isEmpty(logisticsOuCodes)) {
            return new HashMap<String, TmsOuRespVO>();
        }
        TmsOuQueryParamVO tmsOuQueryParamVO = new TmsOuQueryParamVO();
        tmsOuQueryParamVO.setLogisticsOuCodes(logisticsOuCodes);
        List<TmsOuRespVO> rpcDTOList = this.findTmsOuList(tmsOuQueryParamVO);
        if (CollectionUtil.isEmpty(rpcDTOList)) {
            return new HashMap<String, TmsOuRespVO>();
        }
        Map<String, TmsOuRespVO> rpcMap = rpcDTOList.stream().collect(Collectors.toMap(TmsOuRespVO::getLogisticsOuCode, t -> t, (t1, t2) -> t1));
        return rpcMap;
    }

    public TmsOutServiceImpl(TmsProvider tmsProvider) {
        this.tmsProvider = tmsProvider;
    }
}

