package com.elitesland.fin.application.facade.param.invoice;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
@ApiModel("发票申请参数")
public class InvoiceApplyParam {

    @ApiModelProperty(value = "来源单据编号")
    private List<String> optDocNos;

    @ApiModelProperty("业务单据ID")
    @NotEmpty(message = "未选择任何单据")
    private List<Long> ids;

    @ApiModelProperty(value = "来源单明细id")
    private List<Long> bizDtlKey;

    @ApiModelProperty("税号")
    private String custTaxNo;

    @ApiModelProperty("开票抬头")
    private String custInvTitle;

    @ApiModelProperty("开票地址")
    private String address;

    @ApiModelProperty("开户银行")
    private String custBank;

    @ApiModelProperty("银行账号")
    private String custBankAcc;

    @ApiModelProperty("电话")
    private String custTel;

    @ApiModelProperty("发票类型")
    private String invType;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("开票客户名称")
    private String invCustName;

    @ApiModelProperty("开票客户编码")
    private String invCustCode;

    @ApiModelProperty("开票客户ID")
    private Long invCustId;

    @ApiModelProperty("客户地址")
    private String custAdd;

    @ApiModelProperty("开票抬头类型")
    private String invTitleType;
    @ApiModelProperty("开票邮箱")
    private String invEmail;
    @ApiModelProperty("开票联系人")
    private String invPicName;
    @ApiModelProperty("开票联系人电话")
    private String invPicPhone;

}
