package com.elitesland.fin.entity.creditaccount;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "credit_setting")
@org.hibernate.annotations.Table(appliesTo = "credit_setting", comment = "信用设置")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
@ApiModel(value = "credit_setting", description = "信用设置")
public class CreditSettingDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -6829086991452645974L;

    @ApiModelProperty(value = "叠加参数")
    @Column(name = "extra_param",columnDefinition = "varchar(32)  comment '叠加参数'")
    private String extraParam;

    @ApiModelProperty(value = "常规参数")
    @Column(name = "general_param",columnDefinition = "varchar(32)  comment '常规参数'")
    private String generalParam;

    @Column(name = "enable_flag", columnDefinition = "tinyint(1) comment '启用标志'")
    private Boolean enableFlag;

    @Column(name = "auto_repayment_flag", columnDefinition = "tinyint(1) comment '自动还款设置标志'")
    private Boolean autoRepaymentFlag;

    @Column(name = "payment_period_flag", columnDefinition = "tinyint(1) comment '账期检查设置标识'")
    private Boolean paymentPeriodFlag;
}
