/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.accountingengine;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.fin.application.convert.accountingengine.FinAccountEngineConvert;
import com.elitesland.fin.application.facade.dto.accountingengine.FinAccountEngineConfigDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.FinAccountEngineDTO;
import com.elitesland.fin.application.facade.dto.accountingengine.PageParam;
import com.elitesland.fin.application.facade.param.accountingengine.ManualProposedParam;
import com.elitesland.fin.application.service.accountingengine.FinAccountEngineJdbcService;
import com.elitesland.fin.application.service.accountingengine.JournalGenerateService;
import com.elitesland.fin.common.FinAccountEngineConditionEnum;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.domain.entity.accountingengine.FinAccEngDetConditionDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccEngDetDataDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccEngDetDataLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountEngineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinAccountEngineDetailsDO;
import com.elitesland.fin.domain.entity.accountingengine.FinEventTableConditionDO;
import com.elitesland.fin.domain.entity.accountingengine.FinEventTableDO;
import com.elitesland.fin.domain.entity.accountingengine.FinEventTableLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFastCodeDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFastCodeLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleDO;
import com.elitesland.fin.domain.entity.accountingengine.FinFlexibleValueDO;
import com.elitesland.fin.domain.entity.accountingengine.FinJournalLogDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookLineDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSetOfBookOuDO;
import com.elitesland.fin.domain.entity.accountingengine.FinSobAccountPeriodDO;
import com.elitesland.fin.repo.accountingengine.FinAccEngDetConditionRepo;
import com.elitesland.fin.repo.accountingengine.FinAccEngDetDataLineRepo;
import com.elitesland.fin.repo.accountingengine.FinAccEngDetDataRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountEngineDetailsRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountEngineRepo;
import com.elitesland.fin.repo.accountingengine.FinAccountEngineRepoProc;
import com.elitesland.fin.repo.accountingengine.FinEventTableConditionRepo;
import com.elitesland.fin.repo.accountingengine.FinEventTableLineRepo;
import com.elitesland.fin.repo.accountingengine.FinEventTableRepo;
import com.elitesland.fin.repo.accountingengine.FinFastCodeLineRepoProc;
import com.elitesland.fin.repo.accountingengine.FinFastCodeRepoProc;
import com.elitesland.fin.repo.accountingengine.FinFlexibleRepoProc;
import com.elitesland.fin.repo.accountingengine.FinFlexibleValueRepoProc;
import com.elitesland.fin.repo.accountingengine.FinJournalLogRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookLineRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookOuRepo;
import com.elitesland.fin.repo.accountingengine.FinSetOfBookRepo;
import com.elitesland.fin.repo.accountingengine.FinSobAccountPeriodRepo;
import com.elitesland.fin.utils.DataCompareUtil;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class JournalGenerateServiceImpl
implements JournalGenerateService {
    private static final Logger log = LoggerFactory.getLogger(JournalGenerateServiceImpl.class);
    private final FinAccountEngineRepo finAccountEngineRepo;
    private final FinAccountEngineRepoProc finAccountEngineRepoProc;
    private final FinAccountEngineDetailsRepo finAccountEngineDetailsRepo;
    private final FinAccEngDetConditionRepo finAccEngDetConditionRepo;
    private final FinAccEngDetDataRepo finAccEngDetDataRepo;
    private final FinAccEngDetDataLineRepo finAccEngDetDataLineRepo;
    private final FinEventTableRepo finEventTableRepo;
    private final FinEventTableLineRepo finEventTableLineRepo;
    private final FinEventTableConditionRepo finEventTableConditionRepo;
    private final FinJournalLogRepo finJournalLogRepo;
    private final FinSetOfBookOuRepo finSetOfBookOuRepo;
    private final FinSetOfBookRepo finSetOfBookRepo;
    private final FinSetOfBookLineRepo finSetOfBookLineRepo;
    private final FinFastCodeLineRepoProc finFastCodeLineRepoProc;
    private final FinFastCodeRepoProc finFastCodeRepoProc;
    private final FinFlexibleRepoProc finFlexibleRepoProc;
    private final FinFlexibleValueRepoProc finFlexibleValueRepoProc;
    private final FinSobAccountPeriodRepo finSobAccountPeriodRepo;
    private final TenantClientProvider tenantClientProvider;
    private final FinAccountEngineJdbcService finAccountEngineJdbcService;
    @Value(value="${fin.journal.batchSaveSize:500}")
    private int batchSize = 500;

    @Override
    public void generateJournal(List<Long> engineIds) {
        List<FinAccountEngineDO> finAccountEngineDOS = this.finAccountEngineRepo.findAllByIdInAndStatus(engineIds, UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        if (CollectionUtils.isEmpty(finAccountEngineDOS)) {
            log.error("\u81ea\u52a8\u62df\u5b9a\uff0c\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4f1a\u8ba1\u5f15\u64ce");
            this.saveFinJournalLog(null, "\u81ea\u52a8\u62df\u5b9a\uff0c\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4f1a\u8ba1\u5f15\u64ce");
            throw new BusinessException("\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4f1a\u8ba1\u5f15\u64ce");
        }
        List<Long> eventTableIds = finAccountEngineDOS.stream().map(v -> v.getEventTableId()).collect(Collectors.toList());
        List<FinEventTableDO> eventTableDOS = this.finEventTableRepo.findAllByIdInAndStatus(eventTableIds, UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        if (CollectionUtils.isEmpty(eventTableDOS)) {
            log.error("\u81ea\u52a8\u62df\u5b9a\u5931\u8d25\uff0c\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4e8b\u4ef6\u8868\u5355\uff0c\u4f1a\u8ba1\u5f15\u64ceIDS\uff1a{}", engineIds);
            this.saveFinJournalLog(null, String.format("\u81ea\u52a8\u62df\u5b9a\uff0c\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4e8b\u4ef6\u8868\u5355,\u4f1a\u8ba1\u5f15\u64ceIDS\uff1a{}", engineIds));
            throw new BusinessException("\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4e8b\u4ef6\u8868\u5355");
        }
        Map<Long, FinEventTableDO> eventTableMap = eventTableDOS.stream().collect(Collectors.toMap(BaseModel::getId, v -> v, (v1, v2) -> v2));
        for (FinAccountEngineDO finAccountEngineDO : finAccountEngineDOS) {
            FinEventTableDO finEventTableDO = eventTableMap.get(finAccountEngineDO.getEventTableId());
            if (finEventTableDO == null) {
                log.error("\u81ea\u52a8\u62df\u5b9a\u5931\u8d25\uff0c\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4e8b\u4ef6\u8868\u5355\uff0c\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", (Object)finAccountEngineDO.getId());
                this.saveFinJournalLog(null, String.format("\u81ea\u52a8\u62df\u5b9a\uff0c\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4e8b\u4ef6\u8868\u5355,\u4e8b\u4ef6\u8868\u5355\uff1a{}", finAccountEngineDO.getEventTable()));
                continue;
            }
            try {
                ManualProposedParam manualProposedParam = new ManualProposedParam();
                manualProposedParam.setProposedType("job");
                this.pageGenerateJournalInner(finAccountEngineDO, finEventTableDO, false, manualProposedParam);
            }
            catch (Exception e) {
                log.error("\u81ea\u52a8\u62df\u5b9a\u5931\u8d25,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), e});
            }
        }
    }

    @Override
    public void manualProposed(ManualProposedParam manualProposedParam) {
        Assert.notNull((Object)manualProposedParam, (String)"\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)manualProposedParam.getEventTableName(), (String)"\u8868\u540d\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull(manualProposedParam.getDocIds(), (String)"\u5355\u636eID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull(manualProposedParam.getDocNums(), (String)"\u5355\u636e\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(manualProposedParam.getDocIds()), (String)"\u5355\u636eID\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(manualProposedParam.getDocNums()), (String)"\u5355\u636e\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.equals((Object)manualProposedParam.getDocIds().size(), (Object)manualProposedParam.getDocNums().size(), (String)"\u5355\u636eID\u548c\u5355\u636e\u7f16\u7801\u4e0d\u5339\u914d", (Object[])new Object[0]);
        FinEventTableDO finEventTableDO = this.finEventTableRepo.findByMasTableAndStatus(manualProposedParam.getEventTableName(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        if (finEventTableDO == null) {
            log.error("\u624b\u52a8\u62df\u5b9a\u5931\u8d25\uff0c\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4e8b\u4ef6\u8868\u5355");
            this.saveFinJournalLog(null, "\u81ea\u52a8\u62df\u5b9a\uff0c\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4e8b\u4ef6\u8868\u5355");
            throw new BusinessException("\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4e8b\u4ef6\u8868\u5355");
        }
        List<FinAccountEngineDO> finAccountEngineDOs = this.finAccountEngineRepo.findByEventTableAndStatus(finEventTableDO.getEventTable(), UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        if (CollectionUtils.isEmpty(finAccountEngineDOs)) {
            log.error("\u624b\u52a8\u62df\u5b9a\u5931\u8d25\uff0c\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4f1a\u8ba1\u5f15\u64ce");
            this.saveFinJournalLog(null, "\u624b\u52a8\u62df\u5b9a\uff0c\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4f1a\u8ba1\u5f15\u64ce");
            throw new BusinessException("\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u4f1a\u8ba1\u5f15\u64ce");
        }
        for (FinAccountEngineDO finAccountEngineDO : finAccountEngineDOs) {
            try {
                this.pageGenerateJournalInner(finAccountEngineDO, finEventTableDO, true, manualProposedParam);
            }
            catch (Exception e) {
                log.error("\u624b\u52a8\u62df\u5b9a\u5931\u8d25,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), e});
            }
        }
    }

    private void generateJournalInner(FinAccountEngineDO finAccountEngineDO, FinEventTableDO finEventTableDO, boolean manualFlag, ManualProposedParam manualProposedParam) {
        ArrayList<Map> saveMapList = new ArrayList<Map>();
        HashSet<Long> proposingDocIds = new HashSet<Long>();
        HashSet<Long> successProposingDocIds = new HashSet<Long>();
        FinAccountEngineConfigDTO finAccountEngineConfigDTO = null;
        Connection eventTableConnection = null;
        Connection journalConnection = null;
        try {
            try {
                finAccountEngineConfigDTO = this.queryFinAccountEngineConfigData(finAccountEngineDO, finEventTableDO);
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u4f1a\u8ba1\u5f15\u64ce\u914d\u7f6e\u6570\u636e\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), e});
                throw new BusinessException("\u67e5\u8be2\u4f1a\u8ba1\u5f15\u64ce\u914d\u7f6e\u5f02\u5e38," + e.getMessage());
            }
            finAccountEngineConfigDTO.setFinAccountEngineDTO(FinAccountEngineConvert.INSTANCE.DOToDTO(finAccountEngineDO));
            finAccountEngineConfigDTO.setFinEventTableDO(finEventTableDO);
            finAccountEngineConfigDTO.setManualFlag(manualFlag);
            if (manualFlag) {
                finAccountEngineConfigDTO.setDocIds(manualProposedParam.getDocIds());
                finAccountEngineConfigDTO.setDocNums(manualProposedParam.getDocNums());
            }
            try {
                eventTableConnection = this.finAccountEngineJdbcService.getEventTableConnection(finAccountEngineConfigDTO.getFinEventTableDO());
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u4e8b\u4ef6\u8868\u5355\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), e});
                throw new BusinessException("\u83b7\u53d6\u4e8b\u4ef6\u8868\u5355\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38");
            }
            try {
                journalConnection = this.finAccountEngineJdbcService.getJournalConnection(finAccountEngineConfigDTO.getFinAccountEngineDTO());
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u4f1a\u8ba1\u5206\u5f55\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), e});
                throw new BusinessException("\u83b7\u53d6\u4f1a\u8ba1\u5206\u5f55\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38");
            }
            List<Map> dataList = null;
            try {
                dataList = this.finAccountEngineJdbcService.queryEventTableData(eventTableConnection, finAccountEngineConfigDTO, manualFlag, manualProposedParam);
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u4e8b\u4ef6\u8868\u5355\u6570\u636e\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), e});
                throw new BusinessException("\u67e5\u8be2\u4e8b\u4ef6\u8868\u5355\u6570\u636e\u5f02\u5e38");
            }
            if (CollectionUtils.isEmpty(dataList)) {
                log.error("\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u5355\u636e,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", (Object)finEventTableDO.getEventTable(), (Object)finAccountEngineDO.getId());
                String checkDocIdResult = manualProposedParam.getDocIds().stream().map(Objects::toString).collect(Collectors.joining("\u3001", "[", "]"));
                String checkDocNumResult = manualProposedParam.getDocNums().stream().map(Objects::toString).collect(Collectors.joining("\u3001", "[", "]"));
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u5355\u636e,\u5355\u636eID:" + checkDocIdResult + ";\u5355\u636e\u7f16\u7801:" + checkDocNumResult);
            }
            if (manualFlag) {
                this.finAccountEngineJdbcService.deleteExistJournal(eventTableConnection, journalConnection, finAccountEngineConfigDTO, finAccountEngineConfigDTO.getDocNums(), finAccountEngineConfigDTO.getDocIds());
            }
            this.generateFinJournalMap(eventTableConnection, finAccountEngineConfigDTO, dataList, saveMapList, proposingDocIds, successProposingDocIds);
            this.saveFinJournal(finAccountEngineDO, finEventTableDO, journalConnection, saveMapList, proposingDocIds, successProposingDocIds, manualFlag);
            try {
                this.finAccountEngineJdbcService.batchUpdateProposedStatus(finAccountEngineConfigDTO.getFinEventTableDO(), eventTableConnection, successProposingDocIds, UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_SUCCESS.getValueCode());
            }
            catch (SQLException e) {
                log.error("\u6279\u91cf\u66f4\u65b0\u5355\u636e\u62df\u5b9a\u6210\u529f\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), e});
                throw new BusinessException("\u6279\u91cf\u66f4\u65b0\u5355\u636e\u62df\u5b9a\u6210\u529f\u5f02\u5e38");
            }
            proposingDocIds.removeAll(successProposingDocIds);
            try {
                this.finAccountEngineJdbcService.batchUpdateProposedStatus(finAccountEngineConfigDTO.getFinEventTableDO(), eventTableConnection, proposingDocIds, UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode());
            }
            catch (SQLException e) {
                log.error("\u6279\u91cf\u66f4\u65b0\u5355\u636e\u62df\u5b9a\u5931\u8d25\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), e});
                throw new BusinessException("\u6279\u91cf\u66f4\u65b0\u5355\u636e\u62df\u5b9a\u5931\u8d25\u5f02\u5e38");
            }
            this.finAccountEngineJdbcService.closeConnection(eventTableConnection);
            this.finAccountEngineJdbcService.closeConnection(journalConnection);
        }
        catch (Exception e) {
            try {
                this.saveFinJournalLog(null, String.format("%s,\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011", e.getMessage(), finEventTableDO.getEventTable()));
                try {
                    this.finAccountEngineJdbcService.batchUpdateProposedStatus(finAccountEngineConfigDTO.getFinEventTableDO(), eventTableConnection, proposingDocIds, UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode());
                }
                catch (SQLException sqle) {
                    log.error("\u6279\u91cf\u66f4\u65b0\u5355\u636e\u62df\u5b9a\u5931\u8d25\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), sqle});
                    throw new BusinessException("\u6279\u91cf\u66f4\u65b0\u5355\u636e\u62df\u5b9a\u5931\u8d25\u5f02\u5e38");
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.finAccountEngineJdbcService.closeConnection(eventTableConnection);
                this.finAccountEngineJdbcService.closeConnection(journalConnection);
                throw throwable;
            }
        }
    }

    private void pageGenerateJournalInner(FinAccountEngineDO finAccountEngineDO, FinEventTableDO finEventTableDO, boolean manualFlag, ManualProposedParam manualProposedParam) {
        ArrayList<Map> saveMapList = new ArrayList<Map>();
        HashSet<Long> proposingDocIds = new HashSet<Long>();
        HashSet<Long> successProposingDocIds = new HashSet<Long>();
        FinAccountEngineConfigDTO finAccountEngineConfigDTO = null;
        Connection eventTableConnection = null;
        Connection journalConnection = null;
        try {
            try {
                finAccountEngineConfigDTO = this.queryFinAccountEngineConfigData(finAccountEngineDO, finEventTableDO);
                ArrayList<FinAccountEngineDetailsDO> proposedAccountEngineDetails = new ArrayList<FinAccountEngineDetailsDO>();
                if (CollectionUtils.isNotEmpty(finAccountEngineConfigDTO.getFinAccountEngineDetailsDOList())) {
                    finAccountEngineConfigDTO.getFinAccountEngineDetailsDOList().stream().forEach(v -> {
                        if (manualFlag) {
                            if (!UdcEnum.PROPOSED_TYPE_AUTO.getValueCode().equals(v.getProposedType())) {
                                proposedAccountEngineDetails.add((FinAccountEngineDetailsDO)v);
                            }
                        } else if (!UdcEnum.PROPOSED_TYPE_MANUAL.getValueCode().equals(v.getProposedType())) {
                            proposedAccountEngineDetails.add((FinAccountEngineDetailsDO)v);
                        }
                    });
                }
                if (CollectionUtils.isEmpty(proposedAccountEngineDetails)) {
                    throw new BusinessException((manualFlag ? "\u624b\u52a8" : "\u81ea\u52a8") + "\u62df\u5b9a\uff0c\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u62df\u5b9a\u7c7b\u578b\u7684\u4f1a\u8ba1\u5f15\u64ce\u5206\u7c7b");
                }
                finAccountEngineConfigDTO.setFinAccountEngineDetailsDOList(proposedAccountEngineDetails);
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u4f1a\u8ba1\u5f15\u64ce\u914d\u7f6e\u6570\u636e\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), e});
                throw new BusinessException("\u67e5\u8be2\u4f1a\u8ba1\u5f15\u64ce\u914d\u7f6e\u5f02\u5e38," + e.getMessage());
            }
            finAccountEngineConfigDTO.setFinAccountEngineDTO(FinAccountEngineConvert.INSTANCE.DOToDTO(finAccountEngineDO));
            finAccountEngineConfigDTO.setFinEventTableDO(finEventTableDO);
            finAccountEngineConfigDTO.setManualFlag(manualFlag);
            if (manualFlag) {
                finAccountEngineConfigDTO.setDocIds(manualProposedParam.getDocIds());
                finAccountEngineConfigDTO.setDocNums(manualProposedParam.getDocNums());
            }
            try {
                eventTableConnection = this.finAccountEngineJdbcService.getEventTableConnection(finAccountEngineConfigDTO.getFinEventTableDO());
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u4e8b\u4ef6\u8868\u5355\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), e});
                throw new BusinessException("\u83b7\u53d6\u4e8b\u4ef6\u8868\u5355\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38");
            }
            try {
                journalConnection = this.finAccountEngineJdbcService.getJournalConnection(finAccountEngineConfigDTO.getFinAccountEngineDTO());
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u4f1a\u8ba1\u5206\u5f55\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), e});
                throw new BusinessException("\u83b7\u53d6\u4f1a\u8ba1\u5206\u5f55\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38");
            }
            PageParam pageParam = new PageParam();
            pageParam.setLimit(this.batchSize);
            List<Map> dataList = null;
            try {
                dataList = this.finAccountEngineJdbcService.pageQueryEventTableData(eventTableConnection, finAccountEngineConfigDTO, manualFlag, manualProposedParam, pageParam);
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2\u4e8b\u4ef6\u8868\u5355\u6570\u636e\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), e});
                throw new BusinessException("\u67e5\u8be2\u4e8b\u4ef6\u8868\u5355\u6570\u636e\u5f02\u5e38");
            }
            if (CollectionUtils.isEmpty(dataList)) {
                log.error("\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u5355\u636e,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", (Object)finEventTableDO.getEventTable(), (Object)finAccountEngineDO.getId());
                String checkDocIdResult = manualProposedParam.getDocIds().stream().map(Objects::toString).collect(Collectors.joining("\u3001", "[", "]"));
                String checkDocNumResult = manualProposedParam.getDocNums().stream().map(Objects::toString).collect(Collectors.joining("\u3001", "[", "]"));
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u5355\u636e,\u5355\u636eID:" + checkDocIdResult + ";\u5355\u636e\u7f16\u7801:" + checkDocNumResult);
            }
            if (manualFlag) {
                this.finAccountEngineJdbcService.deleteExistJournal(eventTableConnection, journalConnection, finAccountEngineConfigDTO, finAccountEngineConfigDTO.getDocNums(), finAccountEngineConfigDTO.getDocIds());
            }
            while (CollectionUtils.isNotEmpty(dataList)) {
                saveMapList = new ArrayList();
                proposingDocIds = new HashSet();
                successProposingDocIds = new HashSet();
                this.generateFinJournalMapNew(eventTableConnection, finAccountEngineConfigDTO, dataList, saveMapList, proposingDocIds, successProposingDocIds);
                this.saveFinJournal(finAccountEngineDO, finEventTableDO, journalConnection, saveMapList, proposingDocIds, successProposingDocIds, manualFlag);
                try {
                    this.finAccountEngineJdbcService.batchUpdateProposedStatus(finAccountEngineConfigDTO.getFinEventTableDO(), eventTableConnection, successProposingDocIds, UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_SUCCESS.getValueCode());
                }
                catch (SQLException e) {
                    log.error("\u6279\u91cf\u66f4\u65b0\u5355\u636e\u62df\u5b9a\u6210\u529f\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), e});
                    throw new BusinessException("\u6279\u91cf\u66f4\u65b0\u5355\u636e\u62df\u5b9a\u6210\u529f\u5f02\u5e38");
                }
                proposingDocIds.removeAll(successProposingDocIds);
                try {
                    this.finAccountEngineJdbcService.batchUpdateProposedStatus(finAccountEngineConfigDTO.getFinEventTableDO(), eventTableConnection, proposingDocIds, UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode());
                }
                catch (SQLException e) {
                    log.error("\u6279\u91cf\u66f4\u65b0\u5355\u636e\u62df\u5b9a\u5931\u8d25\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), e});
                    throw new BusinessException("\u6279\u91cf\u66f4\u65b0\u5355\u636e\u62df\u5b9a\u5931\u8d25\u5f02\u5e38");
                }
                try {
                    dataList = this.finAccountEngineJdbcService.pageQueryEventTableData(eventTableConnection, finAccountEngineConfigDTO, manualFlag, manualProposedParam, pageParam);
                }
                catch (Exception e) {
                    log.error("\u67e5\u8be2\u4e8b\u4ef6\u8868\u5355\u6570\u636e\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), e});
                    throw new BusinessException("\u67e5\u8be2\u4e8b\u4ef6\u8868\u5355\u6570\u636e\u5f02\u5e38");
                }
            }
            this.finAccountEngineJdbcService.closeConnection(eventTableConnection);
            this.finAccountEngineJdbcService.closeConnection(journalConnection);
        }
        catch (Exception e) {
            try {
                this.saveFinJournalLog(null, String.format("%s,\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011", e.getMessage(), finEventTableDO.getEventTable()));
                try {
                    this.finAccountEngineJdbcService.batchUpdateProposedStatus(finAccountEngineConfigDTO.getFinEventTableDO(), eventTableConnection, proposingDocIds, UdcEnum.DOC_PROPOSED_STATUS_PROPOSED_FAIL.getValueCode());
                }
                catch (SQLException sqle) {
                    log.error("\u6279\u91cf\u66f4\u65b0\u5355\u636e\u62df\u5b9a\u5931\u8d25\u5f02\u5e38,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID\uff1a{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), sqle});
                    throw new BusinessException("\u6279\u91cf\u66f4\u65b0\u5355\u636e\u62df\u5b9a\u5931\u8d25\u5f02\u5e38");
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.finAccountEngineJdbcService.closeConnection(eventTableConnection);
                this.finAccountEngineJdbcService.closeConnection(journalConnection);
                throw throwable;
            }
        }
    }

    private void generateFinJournalMap(Connection eventTableConnection, FinAccountEngineConfigDTO finAccountEngineConfigDTO, List<Map> dataList, List<Map> saveMapList, Set<Long> proposingDocIds, Set<Long> successProposingDocIds) {
        boolean manualFlag = finAccountEngineConfigDTO.getManualFlag() == null ? false : finAccountEngineConfigDTO.getManualFlag();
        FinEventTableDO finEventTableDO = finAccountEngineConfigDTO.getFinEventTableDO();
        FinAccountEngineDTO finAccountEngineDO = finAccountEngineConfigDTO.getFinAccountEngineDTO();
        String docNumKey = finAccountEngineConfigDTO.getFinAccountEngineDTO().getColumnDocNum();
        HashSet<Long> updatedDocIds = new HashSet<Long>();
        Map<Object, List<Map>> dataGroup = dataList.stream().collect(Collectors.groupingBy(v -> v.get("main_id")));
        Set<Object> dataKeys = dataGroup.keySet();
        String docNum = null;
        JournalLogInfo journalLogInfo = null;
        for (Object key : dataKeys) {
            journalLogInfo = new JournalLogInfo(finEventTableDO.getEventTable(), finAccountEngineDO.getId());
            try {
                String ouCode;
                List<Map> resultList;
                ArrayList<Map> perDocDataMap;
                int successDetailDataSize;
                block20: {
                    successDetailDataSize = 0;
                    perDocDataMap = new ArrayList<Map>();
                    journalLogInfo.setManualFlag(manualFlag);
                    resultList = dataGroup.get(key);
                    docNum = resultList.get(0).get(docNumKey).toString();
                    if (docNum == null) {
                        journalLogInfo.setErrMsg("\u5355\u636e\u7f16\u7801\u4e3a\u7a7a");
                        this.saveFinJournalLogNew(journalLogInfo);
                        continue;
                    }
                    journalLogInfo.setDocNum(docNum);
                    ouCode = String.valueOf(resultList.get(0).get(finAccountEngineConfigDTO.getFinAccountEngineDTO().getColumnCompany()));
                    if (ouCode == null) {
                        journalLogInfo.setErrMsg("\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
                        this.saveFinJournalLogNew(journalLogInfo);
                        continue;
                    }
                    journalLogInfo.setOuCode(ouCode);
                    long docId = (Long)key;
                    journalLogInfo.setDocId(docId);
                    proposingDocIds.add(docId);
                    try {
                        if (updatedDocIds.contains(docId)) break block20;
                        this.finAccountEngineJdbcService.updateProposedStatus(finEventTableDO, eventTableConnection, docId, UdcEnum.DOC_PROPOSED_STATUS_PROPOSING.getValueCode());
                        updatedDocIds.add(docId);
                    }
                    catch (Exception e) {
                        journalLogInfo.setErrMsg(e.getMessage());
                        this.saveFinJournalLogNew(journalLogInfo);
                        continue;
                    }
                }
                for (Map result : resultList) {
                    if (!finAccountEngineConfigDTO.isMasTableOnly()) {
                        journalLogInfo.setDetailDocId((long)((Long)result.get("detail_id")));
                    }
                    boolean hitFinAccountEngineDetailFlag = false;
                    for (FinAccountEngineDetailsDO finAccountEngineDetailsDO : finAccountEngineConfigDTO.getFinAccountEngineDetailsDOList()) {
                        journalLogInfo.setAccountEngine(finAccountEngineDetailsDO.getAccountEngine());
                        List<FinAccEngDetConditionDO> finAccEngDetConditionDOList = finAccountEngineConfigDTO.getFinAccEngDetConditionDOList().stream().filter(finAccEngDetDataDO -> finAccountEngineDetailsDO.getId().equals(finAccEngDetDataDO.getMasId())).collect(Collectors.toList());
                        if (!this.checkDataMeetCondition(result, finAccEngDetConditionDOList)) {
                            log.info("\u5355\u636e\u4e0d\u6ee1\u8db3\u4f1a\u8ba1\u660e\u7ec6\u6761\u4ef6\uff0c\u4e8b\u4ef6\u8868\u5355\uff1a{}\uff0c\u5355\u636e\u7f16\u7801\uff1a{}\uff0c\u5355\u636e\u660e\u7ec6ID\uff1a{}\uff0c\u4f1a\u8ba1\u5f15\u64ce\u660e\u7ec6\uff1a{}", new Object[]{finEventTableDO.getEventTable(), docNum, journalLogInfo.getDetailDocId(), finAccountEngineDetailsDO.getAccountEngine()});
                            continue;
                        }
                        hitFinAccountEngineDetailFlag = true;
                        List finAccEngDetDataDOListItem = finAccountEngineConfigDTO.getFinAccEngDetDataDOList().stream().filter(finAccEngDetDataDO -> finAccountEngineDetailsDO.getId().equals(finAccEngDetDataDO.getMasId())).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(finAccEngDetDataDOListItem)) {
                            journalLogInfo.setErrMsg("\u4f1a\u8ba1\u5f15\u64ce\u6570\u636e\u884c\u672a\u914d\u7f6e");
                            this.saveFinJournalLogNew(journalLogInfo);
                            break;
                        }
                        ArrayList<Map> detDataList = new ArrayList<Map>();
                        boolean needCycleAccountEngineDetails = true;
                        boolean setOfBookOuFoundYet = false;
                        for (FinAccEngDetDataDO finAccEngDetDataDO2 : finAccEngDetDataDOListItem) {
                            journalLogInfo.setDetDataName(finAccEngDetDataDO2.getName());
                            if (!this.checkFinSetOfBookOu(finAccountEngineConfigDTO, ouCode, docNum, finAccountEngineConfigDTO.getFinAccountEngineDTO(), finAccountEngineDetailsDO, finAccEngDetDataDO2)) continue;
                            setOfBookOuFoundYet = true;
                            List finAccEngDetDataLineDOListItem = finAccountEngineConfigDTO.getFinAccEngDetDataLineDOList().stream().filter(finAccEngDetDataLineDO -> finAccEngDetDataDO2.getId().equals(finAccEngDetDataLineDO.getMasId())).collect(Collectors.toList());
                            if (CollectionUtils.isEmpty(finAccEngDetDataLineDOListItem)) {
                                journalLogInfo.setErrMsg("\u67e5\u4e0d\u5230\u6570\u636e\u6620\u5c04");
                                this.saveFinJournalLogNew(journalLogInfo);
                                needCycleAccountEngineDetails = false;
                                break;
                            }
                            HashMap<String, Long> saveMap = new HashMap<String, Long>();
                            saveMap.put("detDataId", finAccEngDetDataDO2.getId());
                            saveMap.put("main_id", (Long)result.get("main_id"));
                            saveMap.put("account_engine_id", finAccountEngineDO.getId());
                            saveMap.put("account_engine_details_id", finAccountEngineDetailsDO.getId());
                            saveMap.put("acc_eng_det_data_id", finAccEngDetDataDO2.getId());
                            for (FinAccEngDetDataLineDO finAccEngDetDataLineDO2 : finAccEngDetDataLineDOListItem) {
                                journalLogInfo.setColumnName(finAccEngDetDataLineDO2.getColumnName());
                                if (!this.checkConstant(finAccEngDetDataLineDO2, docNum, finAccountEngineConfigDTO.getFinAccountEngineDTO(), finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap, journalLogInfo)) {
                                    needCycleAccountEngineDetails = false;
                                    break;
                                }
                                if (!this.checkColumn(finAccEngDetDataLineDO2, result, docNum, finAccountEngineConfigDTO.getFinAccountEngineDTO(), finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap, journalLogInfo)) {
                                    needCycleAccountEngineDetails = false;
                                    break;
                                }
                                if (!this.checkFastCode(finAccEngDetDataLineDO2, finAccountEngineConfigDTO, result, docNum, finAccountEngineConfigDTO.getFinAccountEngineDTO(), finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap, journalLogInfo)) {
                                    needCycleAccountEngineDetails = false;
                                    break;
                                }
                                if (!this.checkFlexible(finAccEngDetDataLineDO2, finAccountEngineConfigDTO, docNum, finAccountEngineConfigDTO.getFinAccountEngineDTO(), finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap, journalLogInfo)) {
                                    needCycleAccountEngineDetails = false;
                                    break;
                                }
                                if (this.checkAccountPeriod(finAccEngDetDataLineDO2, result, finAccountEngineConfigDTO, ouCode, docNum, finAccountEngineConfigDTO.getFinAccountEngineDTO(), finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap, journalLogInfo)) continue;
                                needCycleAccountEngineDetails = false;
                                break;
                            }
                            detDataList.add(saveMap);
                        }
                        if (!setOfBookOuFoundYet) {
                            this.saveFinJournalLog(docNum, String.format("\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u516c\u53f8\u8d26\u5957\uff0c\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011,\u4f1a\u8ba1\u5f15\u64ce\u660e\u7ec6\u3010%s\u3011,\u5355\u636e\u516c\u53f8\u7f16\u7801\u3010%s\u3011", finAccountEngineDO.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), ouCode));
                            needCycleAccountEngineDetails = false;
                        }
                        if (!needCycleAccountEngineDetails || CollectionUtils.isEmpty(detDataList) || !this.checkDebtAndCreditSumEqual(detDataList, journalLogInfo)) break;
                        perDocDataMap.addAll(detDataList);
                        ++successDetailDataSize;
                        break;
                    }
                    if (hitFinAccountEngineDetailFlag) continue;
                    journalLogInfo.setErrMsg("\u5355\u636e\u4e0d\u6ee1\u8db3\u4f1a\u8ba1\u660e\u7ec6\u6761\u4ef6");
                    journalLogInfo.setAccountEngine(null);
                    journalLogInfo.setDetDataName(null);
                    journalLogInfo.setColumnName(null);
                    this.saveFinJournalLogNew(journalLogInfo);
                }
                if (successDetailDataSize != resultList.size()) continue;
                saveMapList.addAll(perDocDataMap);
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u4f1a\u8ba1\u51ed\u8bc1\u5f02\u5e38\u6267\u884c\u5f02\u5e38", (Throwable)e);
                journalLogInfo.setErrMsg("\u751f\u6210\u4f1a\u8ba1\u51ed\u8bc1\u5f02\u5e38," + e.getMessage());
                this.saveFinJournalLogNew(journalLogInfo);
            }
        }
    }

    private void generateFinJournalMapNew(Connection eventTableConnection, FinAccountEngineConfigDTO finAccountEngineConfigDTO, List<Map> dataList, List<Map> saveMapList, Set<Long> proposingDocIds, Set<Long> successProposingDocIds) {
        boolean manualFlag = finAccountEngineConfigDTO.getManualFlag() == null ? false : finAccountEngineConfigDTO.getManualFlag();
        FinEventTableDO finEventTableDO = finAccountEngineConfigDTO.getFinEventTableDO();
        FinAccountEngineDTO finAccountEngineDO = finAccountEngineConfigDTO.getFinAccountEngineDTO();
        String docNumKey = finAccountEngineConfigDTO.getFinAccountEngineDTO().getColumnDocNum();
        HashSet<Long> updatedDocIds = new HashSet<Long>();
        Map<Object, List<Map>> dataGroup = dataList.stream().collect(Collectors.groupingBy(v -> v.get("main_id")));
        Set<Object> dataKeys = dataGroup.keySet();
        String docNum = null;
        JournalLogInfo journalLogInfo = null;
        Map<Long, FinAccEngDetDataDO> finAccEngDetDataDOMap = finAccountEngineConfigDTO.getFinAccEngDetDataDOList().stream().collect(Collectors.toMap(v -> v.getId(), v -> v, (o, n) -> n));
        for (Object key : dataKeys) {
            journalLogInfo = new JournalLogInfo(finEventTableDO.getEventTable(), finAccountEngineDO.getId());
            try {
                String ouCode;
                List<Map> resultList;
                ArrayList perDocMergedDataMap;
                ArrayList<Map> perDocDataMap;
                int successDetailDataSize;
                block33: {
                    successDetailDataSize = 0;
                    perDocDataMap = new ArrayList<Map>();
                    perDocMergedDataMap = new ArrayList();
                    journalLogInfo.setManualFlag(manualFlag);
                    resultList = dataGroup.get(key);
                    docNum = resultList.get(0).get(docNumKey).toString();
                    if (docNum == null) {
                        journalLogInfo.setErrMsg("\u5355\u636e\u7f16\u7801\u4e3a\u7a7a");
                        this.saveFinJournalLogNew(journalLogInfo);
                        continue;
                    }
                    journalLogInfo.setDocNum(docNum);
                    ouCode = String.valueOf(resultList.get(0).get(finAccountEngineConfigDTO.getFinAccountEngineDTO().getColumnCompany()));
                    if (ouCode == null) {
                        journalLogInfo.setErrMsg("\u516c\u53f8\u7f16\u7801\u4e3a\u7a7a");
                        this.saveFinJournalLogNew(journalLogInfo);
                        continue;
                    }
                    journalLogInfo.setOuCode(ouCode);
                    long docId = (Long)key;
                    journalLogInfo.setDocId(docId);
                    proposingDocIds.add(docId);
                    try {
                        if (updatedDocIds.contains(docId)) break block33;
                        this.finAccountEngineJdbcService.updateProposedStatus(finEventTableDO, eventTableConnection, docId, UdcEnum.DOC_PROPOSED_STATUS_PROPOSING.getValueCode());
                        updatedDocIds.add(docId);
                    }
                    catch (Exception e) {
                        journalLogInfo.setErrMsg(e.getMessage());
                        this.saveFinJournalLogNew(journalLogInfo);
                        continue;
                    }
                }
                for (Map result : resultList) {
                    if (!finAccountEngineConfigDTO.isMasTableOnly()) {
                        journalLogInfo.setDetailDocId((long)((Long)result.get("detail_id")));
                    }
                    boolean hitFinAccountEngineDetailFlag = false;
                    for (FinAccountEngineDetailsDO finAccountEngineDetailsDO : finAccountEngineConfigDTO.getFinAccountEngineDetailsDOList()) {
                        journalLogInfo.setAccountEngine(finAccountEngineDetailsDO.getAccountEngine());
                        List<FinAccEngDetConditionDO> finAccEngDetConditionDOList = finAccountEngineConfigDTO.getFinAccEngDetConditionDOList().stream().filter(finAccEngDetDataDO -> finAccountEngineDetailsDO.getId().equals(finAccEngDetDataDO.getMasId())).collect(Collectors.toList());
                        if (!this.checkDataMeetCondition(result, finAccEngDetConditionDOList)) {
                            log.info("\u5355\u636e\u4e0d\u6ee1\u8db3\u4f1a\u8ba1\u660e\u7ec6\u6761\u4ef6\uff0c\u4e8b\u4ef6\u8868\u5355\uff1a{}\uff0c\u5355\u636e\u7f16\u7801\uff1a{}\uff0c\u5355\u636e\u660e\u7ec6ID\uff1a{}\uff0c\u4f1a\u8ba1\u5f15\u64ce\u660e\u7ec6\uff1a{}", new Object[]{finEventTableDO.getEventTable(), docNum, journalLogInfo.getDetailDocId(), finAccountEngineDetailsDO.getAccountEngine()});
                            continue;
                        }
                        hitFinAccountEngineDetailFlag = true;
                        List finAccEngDetDataDOListItem = finAccountEngineConfigDTO.getFinAccEngDetDataDOList().stream().filter(finAccEngDetDataDO -> finAccountEngineDetailsDO.getId().equals(finAccEngDetDataDO.getMasId())).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(finAccEngDetDataDOListItem)) {
                            journalLogInfo.setErrMsg("\u4f1a\u8ba1\u5f15\u64ce\u6570\u636e\u884c\u672a\u914d\u7f6e");
                            this.saveFinJournalLogNew(journalLogInfo);
                            break;
                        }
                        ArrayList<Map> detDataList = new ArrayList<Map>();
                        boolean needCycleAccountEngineDetails = true;
                        boolean setOfBookOuFoundYet = false;
                        for (FinAccEngDetDataDO finAccEngDetDataDO2 : finAccEngDetDataDOListItem) {
                            journalLogInfo.setDetDataName(finAccEngDetDataDO2.getName());
                            if (!this.checkFinSetOfBookOu(finAccountEngineConfigDTO, ouCode, docNum, finAccountEngineConfigDTO.getFinAccountEngineDTO(), finAccountEngineDetailsDO, finAccEngDetDataDO2)) continue;
                            setOfBookOuFoundYet = true;
                            List finAccEngDetDataLineDOListItem = finAccountEngineConfigDTO.getFinAccEngDetDataLineDOList().stream().filter(finAccEngDetDataLineDO -> finAccEngDetDataDO2.getId().equals(finAccEngDetDataLineDO.getMasId())).collect(Collectors.toList());
                            if (CollectionUtils.isEmpty(finAccEngDetDataLineDOListItem)) {
                                journalLogInfo.setErrMsg("\u67e5\u4e0d\u5230\u6570\u636e\u6620\u5c04");
                                this.saveFinJournalLogNew(journalLogInfo);
                                needCycleAccountEngineDetails = false;
                                break;
                            }
                            HashMap<String, Number> saveMap = new HashMap<String, Number>();
                            saveMap.put("detDataId", finAccEngDetDataDO2.getId());
                            saveMap.put("main_id", (Number)result.get("main_id"));
                            saveMap.put("account_engine_id", finAccountEngineDO.getId());
                            saveMap.put("account_engine_details_id", finAccountEngineDetailsDO.getId());
                            saveMap.put("acc_eng_det_data_id", finAccEngDetDataDO2.getId());
                            for (FinAccEngDetDataLineDO finAccEngDetDataLineDO2 : finAccEngDetDataLineDOListItem) {
                                journalLogInfo.setColumnName(finAccEngDetDataLineDO2.getColumnName());
                                if (!this.checkConstant(finAccEngDetDataLineDO2, docNum, finAccountEngineConfigDTO.getFinAccountEngineDTO(), finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap, journalLogInfo)) {
                                    needCycleAccountEngineDetails = false;
                                    break;
                                }
                                if (!this.checkColumn(finAccEngDetDataLineDO2, result, docNum, finAccountEngineConfigDTO.getFinAccountEngineDTO(), finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap, journalLogInfo)) {
                                    needCycleAccountEngineDetails = false;
                                    break;
                                }
                                if (!this.checkFastCode(finAccEngDetDataLineDO2, finAccountEngineConfigDTO, result, docNum, finAccountEngineConfigDTO.getFinAccountEngineDTO(), finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap, journalLogInfo)) {
                                    needCycleAccountEngineDetails = false;
                                    break;
                                }
                                if (!this.checkFlexible(finAccEngDetDataLineDO2, finAccountEngineConfigDTO, docNum, finAccountEngineConfigDTO.getFinAccountEngineDTO(), finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap, journalLogInfo)) {
                                    needCycleAccountEngineDetails = false;
                                    break;
                                }
                                if (this.checkAccountPeriod(finAccEngDetDataLineDO2, result, finAccountEngineConfigDTO, ouCode, docNum, finAccountEngineConfigDTO.getFinAccountEngineDTO(), finAccountEngineDetailsDO, finAccEngDetDataDO2, saveMap, journalLogInfo)) continue;
                                needCycleAccountEngineDetails = false;
                                break;
                            }
                            if (Boolean.TRUE.equals(finAccEngDetDataDO2.getAbsFlag())) {
                                if (saveMap.get("debit_amt") != null) {
                                    saveMap.put("debit_amt", ((BigDecimal)saveMap.get("debit_amt")).abs());
                                }
                                if (saveMap.get("credit_amt") != null) {
                                    saveMap.put("credit_amt", ((BigDecimal)saveMap.get("credit_amt")).abs());
                                }
                                if (saveMap.get("debit_cur_amt") != null) {
                                    saveMap.put("debit_cur_amt", ((BigDecimal)saveMap.get("debit_cur_amt")).abs());
                                }
                                if (saveMap.get("credit_cur_amt") != null) {
                                    saveMap.put("credit_cur_amt", ((BigDecimal)saveMap.get("credit_cur_amt")).abs());
                                }
                            }
                            detDataList.add(saveMap);
                        }
                        if (!setOfBookOuFoundYet) {
                            this.saveFinJournalLog(docNum, String.format("\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u516c\u53f8\u8d26\u5957\uff0c\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011,\u4f1a\u8ba1\u5f15\u64ce\u660e\u7ec6\u3010%s\u3011,\u5355\u636e\u516c\u53f8\u7f16\u7801\u3010%s\u3011", finAccountEngineDO.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), ouCode));
                            needCycleAccountEngineDetails = false;
                        }
                        if (!needCycleAccountEngineDetails || CollectionUtils.isEmpty(detDataList) || !this.checkDebtAndCreditSumEqual(detDataList, journalLogInfo)) break;
                        perDocDataMap.addAll(detDataList);
                        ++successDetailDataSize;
                        break;
                    }
                    if (hitFinAccountEngineDetailFlag) continue;
                    journalLogInfo.setErrMsg("\u5355\u636e\u4e0d\u6ee1\u8db3\u4f1a\u8ba1\u660e\u7ec6\u6761\u4ef6");
                    journalLogInfo.setAccountEngine(null);
                    journalLogInfo.setDetDataName(null);
                    journalLogInfo.setColumnName(null);
                    this.saveFinJournalLogNew(journalLogInfo);
                }
                if (successDetailDataSize != resultList.size()) continue;
                if (CollectionUtils.isNotEmpty(perDocDataMap)) {
                    Map detDataIdMap = perDocDataMap.stream().collect(Collectors.groupingBy(v -> v.get("detDataId"), Collectors.toList()));
                    for (Map.Entry detDataIdMapEntry : detDataIdMap.entrySet()) {
                        FinAccEngDetDataDO finAccEngDetDataDO3 = finAccEngDetDataDOMap.get(detDataIdMapEntry.getKey());
                        if (finAccEngDetDataDO3.getCombineFlag().booleanValue()) {
                            String sobCode = finAccEngDetDataDO3.getSobCode();
                            Map<String, Map<String, FinSetOfBookLineDO>> sobSetOfBookLineMap = finAccountEngineConfigDTO.getSetOfBookLineMap();
                            Map<String, FinSetOfBookLineDO> setOfBookLineDOMap = sobSetOfBookLineMap.get(sobCode);
                            Set<String> sobColumnNames = setOfBookLineDOMap.keySet();
                            List lineColumnNames = finAccountEngineConfigDTO.getFinAccEngDetDataLineDOList().stream().filter(finAccEngDetDataLineDO -> finAccEngDetDataDO3.getId().equals(finAccEngDetDataLineDO.getMasId())).map(v -> v.getColumnName()).collect(Collectors.toList());
                            List realSobColumnNames = sobColumnNames.stream().filter(v -> lineColumnNames.contains(v)).collect(Collectors.toList());
                            Map mergingMap = detDataIdMapEntry.getValue().stream().collect(Collectors.groupingBy(v -> {
                                StringBuilder sb = new StringBuilder();
                                for (String realSobColumnName : realSobColumnNames) {
                                    sb.append(v.get(realSobColumnName));
                                }
                                return sb.toString();
                            }, Collectors.toList()));
                            for (Map.Entry entry : mergingMap.entrySet()) {
                                BigDecimal debit_amt = BigDecimal.ZERO;
                                BigDecimal credit_amt = BigDecimal.ZERO;
                                BigDecimal debit_cur_amt = BigDecimal.ZERO;
                                BigDecimal credit_cur_amt = BigDecimal.ZERO;
                                for (Map data : entry.getValue()) {
                                    if (data.get("debit_amt") != null) {
                                        debit_amt = debit_amt.add((BigDecimal)data.get("debit_amt"));
                                    }
                                    if (data.get("credit_amt") != null) {
                                        credit_amt = credit_amt.add((BigDecimal)data.get("credit_amt"));
                                    }
                                    if (data.get("debit_cur_amt") != null) {
                                        debit_cur_amt = debit_cur_amt.add((BigDecimal)data.get("debit_cur_amt"));
                                    }
                                    if (data.get("credit_cur_amt") == null) continue;
                                    credit_cur_amt = credit_cur_amt.add((BigDecimal)data.get("credit_cur_amt"));
                                }
                                HashMap<String, BigDecimal> mergedData = new HashMap<String, BigDecimal>((Map)entry.getValue().get(0));
                                mergedData.put("debit_amt", debit_amt);
                                mergedData.put("credit_amt", credit_amt);
                                mergedData.put("debit_cur_amt", debit_cur_amt);
                                mergedData.put("credit_cur_amt", credit_cur_amt);
                                perDocMergedDataMap.add(mergedData);
                            }
                            continue;
                        }
                        perDocMergedDataMap.addAll(detDataIdMapEntry.getValue());
                    }
                }
                saveMapList.addAll(perDocMergedDataMap);
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u4f1a\u8ba1\u51ed\u8bc1\u5f02\u5e38\u6267\u884c\u5f02\u5e38", (Throwable)e);
                journalLogInfo.setErrMsg("\u751f\u6210\u4f1a\u8ba1\u51ed\u8bc1\u5f02\u5e38," + e.getMessage());
                this.saveFinJournalLogNew(journalLogInfo);
            }
        }
    }

    private void saveFinJournalLog(String docNum, String log) {
        FinJournalLogDO finJournalLogDo = new FinJournalLogDO();
        finJournalLogDo.setDocNum(docNum);
        finJournalLogDo.setLog(log);
        this.finJournalLogRepo.save(finJournalLogDo);
    }

    private void saveFinJournalLogNew(JournalLogInfo journalLogInfo) {
        String docNum = journalLogInfo.getDocNum();
        String proposedType = "";
        if (journalLogInfo.getManualFlag() != null) {
            proposedType = journalLogInfo.getManualFlag() != false ? "\u624b\u52a8\u62df\u5b9a" : "\u81ea\u52a8\u62df\u5b9a";
        }
        String formatMsg = String.format("%s,%s,\u4e8b\u4ef6\u8868\u5355\u3010%s\u3011,\u5355\u636e\u660e\u7ec6ID\u3010%s\u3011,\u4f1a\u8ba1\u5f15\u64ce\u660e\u7ec6\u3010%s\u3011,\u6570\u636e\u884c\u3010%s\u3011,\u5217\u540d\u79f0\u3010%s\u3011", proposedType, journalLogInfo.getErrMsg(), journalLogInfo.getEventTable(), journalLogInfo.getDetailDocId(), journalLogInfo.getAccountEngine(), journalLogInfo.getDetDataName(), journalLogInfo.getColumnName());
        FinJournalLogDO finJournalLogDo = new FinJournalLogDO();
        finJournalLogDo.setDocNum(docNum);
        finJournalLogDo.setLog(formatMsg);
        this.finJournalLogRepo.save(finJournalLogDo);
        log.error("\u4f1a\u8ba1\u5f15\u64ce\u751f\u6210\u4f1a\u8ba1\u51ed\u8bc1\u5f02\u5e38\u65e5\u5fd7\uff1a{}", (Object)JSON.toJSONString((Object)finJournalLogDo));
    }

    private boolean checkDataMeetCondition(Map data, List<FinAccEngDetConditionDO> finAccEngDetConditionDOList) {
        if (CollectionUtils.isEmpty(finAccEngDetConditionDOList)) {
            return false;
        }
        for (FinAccEngDetConditionDO finAccEngDetConditionDO : finAccEngDetConditionDOList) {
            String conditionType = finAccEngDetConditionDO.getConditionType();
            String tableName = finAccEngDetConditionDO.getTableName();
            String columnName = finAccEngDetConditionDO.getColumnName();
            String valueFrom = finAccEngDetConditionDO.getValueFrom();
            String valueTo = finAccEngDetConditionDO.getValueTo();
            Object value = data.get(columnName);
            boolean testResult = true;
            if (FinAccountEngineConditionEnum.EQUAL.name().equals(conditionType)) {
                if (StringUtils.isBlank((CharSequence)valueFrom)) continue;
                if (value == null) {
                    return false;
                }
                if (value instanceof Number) {
                    testResult = DataCompareUtil.numberEqual((Number)value, valueFrom);
                } else if (value instanceof Boolean) {
                    testResult = DataCompareUtil.booleanEqual((Boolean)value, valueFrom);
                } else if (value instanceof String) {
                    testResult = DataCompareUtil.stringEqual((String)value, valueFrom);
                } else if (value instanceof LocalDateTime) {
                    testResult = DataCompareUtil.dateTimeEqual((LocalDateTime)value, valueFrom);
                }
            } else if (FinAccountEngineConditionEnum.GREATER.name().equals(conditionType)) {
                if (StringUtils.isBlank((CharSequence)valueFrom)) continue;
                if (value == null) {
                    return false;
                }
                if (value instanceof Number) {
                    testResult = DataCompareUtil.numberGreater((Number)value, valueFrom);
                } else if (value instanceof LocalDateTime) {
                    testResult = DataCompareUtil.dateTimeGreater((LocalDateTime)value, valueFrom);
                }
            } else if (FinAccountEngineConditionEnum.LESS.name().equals(conditionType)) {
                if (StringUtils.isBlank((CharSequence)valueFrom)) continue;
                if (value == null) {
                    return false;
                }
                if (value instanceof Number) {
                    testResult = DataCompareUtil.numberLess((Number)value, valueFrom);
                } else if (value instanceof LocalDateTime) {
                    testResult = DataCompareUtil.dateTimeLess((LocalDateTime)value, valueFrom);
                }
            } else if (FinAccountEngineConditionEnum.GREATER_EQUAL.name().equals(conditionType)) {
                if (StringUtils.isBlank((CharSequence)valueFrom)) continue;
                if (value == null) {
                    return false;
                }
                if (value instanceof Number) {
                    testResult = DataCompareUtil.numberGreaterEqual((Number)value, valueFrom);
                } else if (value instanceof LocalDateTime) {
                    testResult = DataCompareUtil.dateTimeGreaterEqual((LocalDateTime)value, valueFrom);
                }
            } else if (FinAccountEngineConditionEnum.LESS_EQUAL.name().equals(conditionType)) {
                if (StringUtils.isBlank((CharSequence)valueFrom)) continue;
                if (value == null) {
                    return false;
                }
                if (value instanceof Number) {
                    testResult = DataCompareUtil.numberLessEqual((Number)value, valueFrom);
                } else if (value instanceof LocalDateTime) {
                    testResult = DataCompareUtil.dateTimeLessEqual((LocalDateTime)value, valueFrom);
                }
            } else if (FinAccountEngineConditionEnum.IS_NULL.name().equals(conditionType)) {
                testResult = value == null || value instanceof String && StringUtils.isBlank((CharSequence)((String)value));
            } else if (FinAccountEngineConditionEnum.IS_NOT_NULL.name().equals(conditionType)) {
                testResult = value != null && (!(value instanceof String) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{(String)value}));
            } else if (FinAccountEngineConditionEnum.IN.name().equals(conditionType)) {
                if (StringUtils.isBlank((CharSequence)valueFrom)) continue;
                if (value == null) {
                    return false;
                }
                if (value instanceof Number) {
                    testResult = DataCompareUtil.numberIn((Number)value, valueFrom);
                } else if (value instanceof String) {
                    testResult = DataCompareUtil.StringIn((String)value, valueFrom);
                }
            } else if (FinAccountEngineConditionEnum.NOT_IN.name().equals(conditionType)) {
                if (StringUtils.isBlank((CharSequence)valueFrom)) continue;
                if (value == null) {
                    return true;
                }
                if (value instanceof Number) {
                    testResult = DataCompareUtil.numberNotIn((Number)value, valueFrom);
                } else if (value instanceof String) {
                    testResult = DataCompareUtil.StringNotIn((String)value, valueFrom);
                }
            } else if (FinAccountEngineConditionEnum.BETWEEN_AND.name().equals(conditionType)) {
                if (StringUtils.isBlank((CharSequence)valueFrom) || StringUtils.isBlank((CharSequence)valueTo)) continue;
                if (value == null) {
                    return false;
                }
                if (value instanceof Number) {
                    testResult = DataCompareUtil.numberBetweenAnd((Number)value, valueFrom, valueTo);
                } else if (value instanceof LocalDateTime) {
                    testResult = DataCompareUtil.dateTimeBetweenAnd((LocalDateTime)value, valueFrom, valueTo);
                }
            }
            if (testResult) continue;
            return false;
        }
        return true;
    }

    private boolean checkFinSetOfBookOu(FinAccountEngineConfigDTO finAccountEngineConfigDTO, String ouCode, String docNum, FinAccountEngineDTO finAccountEngineDO, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO) {
        String sobCode = finAccEngDetDataDO.getSobCode();
        FinSetOfBookDO finSetOfBookDOResult = finAccountEngineConfigDTO.getFinSetOfBookDOList().stream().filter(finSetOfBookDO -> finSetOfBookDO.getSobCode().equals(sobCode)).findFirst().orElse(null);
        if (finSetOfBookDOResult == null) {
            log.info("\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u8d26\u5957\uff0c\u4e8b\u4ef6\u8868\u5355\uff1a{},\u4f1a\u8ba1\u5f15\u64ce\u660e\u7ec6\uff1a{},\u6570\u636e\u884c\uff1a{},\u5355\u636e\u516c\u53f8\u7f16\u7801\uff1a{}", new Object[]{finAccountEngineDO.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), ouCode});
            return false;
        }
        List finSetOfBookOuDOListItem = finAccountEngineConfigDTO.getFinSetOfBookOuDOList().stream().filter(finSetOfBookOuDO -> finSetOfBookDOResult.getId().equals(finSetOfBookOuDO.getMasId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(finSetOfBookOuDOListItem)) {
            log.info("\u67e5\u4e0d\u5230\u8d26\u5957\u516c\u53f8\uff0c\u4e8b\u4ef6\u8868\u5355\uff1a{},\u4f1a\u8ba1\u5f15\u64ce\u660e\u7ec6\uff1a{},\u6570\u636e\u884c\uff1a{},\u5355\u636e\u516c\u53f8\u7f16\u7801\uff1a{}", new Object[]{finAccountEngineDO.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), ouCode});
            return false;
        }
        FinSetOfBookOuDO finSetOfBookOuDOResult = finSetOfBookOuDOListItem.stream().filter(finSetOfBookOuDO -> ouCode.equals(finSetOfBookOuDO.getOuCode()) || Objects.equals(ouCode, String.valueOf(finSetOfBookOuDO.getOuId()))).findFirst().orElse(null);
        if (finSetOfBookOuDOResult == null) {
            log.info("\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u516c\u53f8\u8d26\u5957\uff0c\u4e8b\u4ef6\u8868\u5355\uff1a{},\u4f1a\u8ba1\u5f15\u64ce\u660e\u7ec6\uff1a{},\u6570\u636e\u884c\uff1a{},\u5355\u636e\u516c\u53f8\u7f16\u7801\uff1a{}", new Object[]{finAccountEngineDO.getEventTable(), finAccountEngineDetailsDO.getAccountEngine(), finAccEngDetDataDO.getName(), ouCode});
            return false;
        }
        return true;
    }

    private FinAccountEngineConfigDTO queryFinAccountEngineConfigData(FinAccountEngineDO finAccountEngineDO, FinEventTableDO finEventTableDO) {
        Map<String, Long> flexCodeIdMap;
        ArrayList<Long> flexIds;
        List<FinEventTableLineDO> finEventTableLineDOList = this.finEventTableLineRepo.findAllByMasId(finEventTableDO.getId());
        Assert.notEmpty(finEventTableLineDOList, (String)"\u67e5\u4e0d\u5230\u4e8b\u4ef6\u8868\u5355\u660e\u7ec6", (Object[])new Object[0]);
        List<FinEventTableConditionDO> conditionDOListAll = this.finEventTableConditionRepo.findAllByMasId(finEventTableDO.getId());
        List<FinAccountEngineDetailsDO> finAccountEngineDetailsDOList = this.finAccountEngineDetailsRepo.findAllByMasIdAndActiveFlag(finAccountEngineDO.getId(), Boolean.TRUE).stream().sorted(Comparator.comparing(FinAccountEngineDetailsDO::getSerialNum).reversed()).collect(Collectors.toList());
        Assert.notEmpty(finAccountEngineDetailsDOList, (String)"\u67e5\u4e0d\u5230\u542f\u7528\u7684\u4f1a\u8ba1\u5f15\u64ce\u660e\u7ec6", (Object[])new Object[0]);
        List<Long> finAccountEngineDetailsDOIds = finAccountEngineDetailsDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<FinAccEngDetConditionDO> finAccEngDetConditionDOList = this.finAccEngDetConditionRepo.findAllByMasIdIn(finAccountEngineDetailsDOIds);
        List<FinAccEngDetDataDO> finAccEngDetDataDOList = this.finAccEngDetDataRepo.findAllByMasIdIn(finAccountEngineDetailsDOIds).stream().sorted(Comparator.comparing(FinAccEngDetDataDO::getSerialNum).reversed()).collect(Collectors.toList());
        Assert.notEmpty(finAccEngDetDataDOList, (String)"\u67e5\u4e0d\u5230\u6570\u636e\u884c\u8be6\u60c5", (Object[])new Object[0]);
        List<Long> finAccEngDetDataDOIds = finAccEngDetDataDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<FinAccEngDetDataLineDO> finAccEngDetDataLineDOList = this.finAccEngDetDataLineRepo.findAllByMasIdIn(finAccEngDetDataDOIds);
        Assert.notEmpty(finAccEngDetDataLineDOList, (String)"\u67e5\u4e0d\u5230\u6570\u636e\u6620\u5c04", (Object[])new Object[0]);
        List<String> fastCodes = finAccEngDetDataLineDOList.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getFastCode())).map(FinAccEngDetDataLineDO::getFastCode).collect(Collectors.toList());
        List<FinFastCodeDO> finFastCodeDOList = this.finFastCodeRepoProc.findAllByFastCodeInAndStatus(fastCodes, UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<Long> finFastCodeDOIds = finFastCodeDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<FinFastCodeLineDO> finFastCodeLineDOList = this.finFastCodeLineRepoProc.findByMasIdIn(finFastCodeDOIds);
        List<String> sobCodes = finAccEngDetDataDOList.stream().map(FinAccEngDetDataDO::getSobCode).collect(Collectors.toList());
        List<FinSetOfBookDO> finSetOfBookDOList = this.finSetOfBookRepo.findAllBySobCodeInAndStatus(sobCodes, UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        Assert.notEmpty(finSetOfBookDOList, (String)"\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u5e10\u5957", (Object[])new Object[0]);
        List<Long> finSetOfBookDOIds = finSetOfBookDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        List<FinSetOfBookOuDO> finSetOfBookOuDOList = this.finSetOfBookOuRepo.findAllByMasIdIn(finSetOfBookDOIds);
        Assert.notEmpty(finSetOfBookOuDOList, (String)"\u67e5\u4e0d\u5230\u5e10\u5957\u5e10\u5957\u516c\u53f8", (Object[])new Object[0]);
        List<FinSetOfBookLineDO> finSetOfBookLineDOList = this.finSetOfBookLineRepo.findAllByMasIdIn(finSetOfBookDOIds);
        Assert.notEmpty(finSetOfBookLineDOList, (String)"\u67e5\u4e0d\u5230\u5e10\u5957\u660e\u7ec6", (Object[])new Object[0]);
        Map masFinSetOfBookLineMap = finSetOfBookLineDOList.stream().collect(Collectors.groupingBy(v -> v.getMasId(), Collectors.toList()));
        Map<String, Map<String, FinSetOfBookLineDO>> setOfBookLineMap = finSetOfBookDOList.stream().collect(Collectors.toMap(v -> v.getSobCode(), v -> masFinSetOfBookLineMap.get(v.getId()) != null ? ((List)masFinSetOfBookLineMap.get(v.getId())).stream().collect(Collectors.toMap(w -> w.getColumnName(), w -> w, (o, n) -> n)) : new HashMap()));
        List<FinSobAccountPeriodDO> finSobAccountPeriodDOList = this.finSobAccountPeriodRepo.findAllByStatus(UdcEnum.ACCOUNT_PERIOD_CONTROL_STATUS_OPEN.getValueCode());
        List<String> flexibleCodes = finSetOfBookLineDOList.stream().filter(finSetOfBookLineDO -> StringUtils.isNotEmpty((CharSequence)finSetOfBookLineDO.getFlexibleCode())).map(FinSetOfBookLineDO::getFlexibleCode).collect(Collectors.toList());
        HashMap<String, Map<String, FinFlexibleValueDO>> flexCodeValueMap = new HashMap();
        List<FinFlexibleDO> finFlexibleDOS = this.finFlexibleRepoProc.findAllByFlexibleCodeInAndStatus(flexibleCodes, UdcEnum.FIN_ACTIVE_STATUS_ACTIVE.getValueCode());
        List<FinFlexibleValueDO> finFlexibleValueDOList = null;
        if (CollectionUtils.isNotEmpty(finFlexibleDOS) && CollectionUtils.isNotEmpty(finFlexibleValueDOList = this.finFlexibleValueRepoProc.findByMasIdInAndValidTime(flexIds = new ArrayList<Long>((flexCodeIdMap = finFlexibleDOS.stream().collect(Collectors.toMap(v -> v.getFlexibleCode(), v -> v.getId(), (o, n) -> n))).values()), LocalDateTime.now()))) {
            Map flexibleValueMap = finFlexibleValueDOList.stream().collect(Collectors.groupingBy(v -> v.getMasId(), Collectors.toList()));
            flexCodeValueMap = finFlexibleDOS.stream().collect(Collectors.toMap(v -> v.getFlexibleCode(), v -> flexibleValueMap.get(v.getId()) != null ? ((List)flexibleValueMap.get(v.getId())).stream().collect(Collectors.toMap(w -> w.getFlexibleValueCode(), w -> w, (o, n) -> n)) : null, (o, n) -> n));
        }
        FinAccountEngineConfigDTO finAccountEngineConfigDTO = new FinAccountEngineConfigDTO();
        finAccountEngineConfigDTO.setFinAccountEngineDTO(FinAccountEngineConvert.INSTANCE.DOToDTO(finAccountEngineDO));
        finAccountEngineConfigDTO.setFinEventTableDO(finEventTableDO);
        finAccountEngineConfigDTO.setFinEventTableLineDOList(finEventTableLineDOList);
        finAccountEngineConfigDTO.setFinEventTableConditionDOList(conditionDOListAll.stream().filter(v -> "DATA_SELECT".equals(v.getCategory())).collect(Collectors.toList()));
        finAccountEngineConfigDTO.setFinEventTableProposedConditionList(conditionDOListAll.stream().filter(v -> "PROPOSED".equals(v.getCategory())).collect(Collectors.toList()));
        finAccountEngineConfigDTO.setFinAccountEngineDetailsDOList(finAccountEngineDetailsDOList);
        finAccountEngineConfigDTO.setFinAccEngDetConditionDOList(finAccEngDetConditionDOList);
        finAccountEngineConfigDTO.setFinAccEngDetDataDOList(finAccEngDetDataDOList);
        finAccountEngineConfigDTO.setFinAccEngDetDataLineDOList(finAccEngDetDataLineDOList);
        finAccountEngineConfigDTO.setFinFastCodeDOList(finFastCodeDOList);
        finAccountEngineConfigDTO.setFinFastCodeLineDOList(finFastCodeLineDOList);
        finAccountEngineConfigDTO.setFinSetOfBookDOList(finSetOfBookDOList);
        finAccountEngineConfigDTO.setFinSetOfBookOuDOList(finSetOfBookOuDOList);
        finAccountEngineConfigDTO.setFinSetOfBookLineDOList(finSetOfBookLineDOList);
        finAccountEngineConfigDTO.setFinSobAccountPeriodDOList(finSobAccountPeriodDOList);
        finAccountEngineConfigDTO.setFinFlexibleDOList(finFlexibleDOS);
        finAccountEngineConfigDTO.setFlexCodeValueMap(flexCodeValueMap);
        finAccountEngineConfigDTO.setFinFlexibleValueDOList(finFlexibleValueDOList);
        finAccountEngineConfigDTO.setSetOfBookLineMap(setOfBookLineMap);
        if (StringUtils.isNotBlank((CharSequence)finEventTableDO.getTableName())) {
            finAccountEngineConfigDTO.setMasTableOnly(false);
        } else {
            finAccountEngineConfigDTO.setMasTableOnly(true);
        }
        return finAccountEngineConfigDTO;
    }

    private boolean checkConstant(FinAccEngDetDataLineDO finAccEngDetDataLineDO, String docNum, FinAccountEngineDTO finAccountEngineDO, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO, Map saveMap, JournalLogInfo journalLogInfo) {
        if (UdcEnum.SOURCE_TYPE_CONSTANT.getValueCode().equals(finAccEngDetDataLineDO.getSourceType())) {
            if (StringUtils.isEmpty((CharSequence)finAccEngDetDataLineDO.getConstant())) {
                journalLogInfo.setErrMsg("\u5e38\u6570\u5217\u503c\u4e3a\u7a7a");
                this.saveFinJournalLogNew(journalLogInfo);
                return false;
            }
            this.put(saveMap, finAccEngDetDataLineDO.getColumnName(), finAccEngDetDataLineDO.getConstant(), finAccEngDetDataLineDO);
        }
        return true;
    }

    private boolean checkColumn(FinAccEngDetDataLineDO finAccEngDetDataLineDO, Map result, String docNum, FinAccountEngineDTO finAccountEngineDO, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO, Map saveMap, JournalLogInfo journalLogInfo) {
        if (UdcEnum.SOURCE_TYPE_COLUMN.getValueCode().equals(finAccEngDetDataLineDO.getSourceType())) {
            if (!result.containsKey(finAccEngDetDataLineDO.getColumnSource())) {
                journalLogInfo.setErrMsg("\u8868\u5355\u6570\u636e\u672a\u5305\u542b\u6620\u5c04\u5217");
                this.saveFinJournalLogNew(journalLogInfo);
                return false;
            }
            this.put(saveMap, finAccEngDetDataLineDO.getColumnName(), result.get(finAccEngDetDataLineDO.getColumnSource()) == null ? null : result.get(finAccEngDetDataLineDO.getColumnSource()), finAccEngDetDataLineDO);
        }
        return true;
    }

    private boolean checkFastCode(FinAccEngDetDataLineDO finAccEngDetDataLineDO, FinAccountEngineConfigDTO finAccountEngineConfigDTO, Map result, String docNum, FinAccountEngineDTO finAccountEngineDO, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO, Map saveMap, JournalLogInfo journalLogInfo) {
        if (UdcEnum.SOURCE_TYPE_FAST_CODE.getValueCode().equals(finAccEngDetDataLineDO.getSourceType())) {
            FinFastCodeDO finFastCodeDOResult = finAccountEngineConfigDTO.getFinFastCodeDOList().stream().filter(finFastCodeDO -> finFastCodeDO.getFastCode().equals(finAccEngDetDataLineDO.getFastCode())).findFirst().orElse(null);
            if (finFastCodeDOResult == null) {
                journalLogInfo.setErrMsg("\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u5feb\u7801");
                this.saveFinJournalLogNew(journalLogInfo);
                return false;
            }
            List finFastCodeLineDOListItem = finAccountEngineConfigDTO.getFinFastCodeLineDOList().stream().filter(finFastCodeLineDO -> finFastCodeDOResult.getId().equals(finFastCodeLineDO.getMasId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(finFastCodeLineDOListItem)) {
                journalLogInfo.setErrMsg("\u672a\u67e5\u5230\u5feb\u7801\u660e\u7ec6");
                this.saveFinJournalLogNew(journalLogInfo);
                return false;
            }
            FinFastCodeLineDO finFastCodeLineDOResult = finFastCodeLineDOListItem.stream().filter(finFastCodeLineDO -> {
                if (StringUtils.isNotEmpty((CharSequence)finFastCodeLineDO.getConditionOne())) {
                    if (result.get(finFastCodeLineDO.getConditionOne()) == null) {
                        return false;
                    }
                    if (!finFastCodeLineDO.getConditionOneValue().equals("" + result.get(finFastCodeLineDO.getConditionOne()))) {
                        return false;
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)finFastCodeLineDO.getConditionTwo())) {
                    if (result.get(finFastCodeLineDO.getConditionOne()) == null) {
                        return false;
                    }
                    if (!finFastCodeLineDO.getConditionTwoValue().equals("" + result.get(finFastCodeLineDO.getConditionTwo()))) {
                        return false;
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)finFastCodeLineDO.getConditionThree())) {
                    if (result.get(finFastCodeLineDO.getConditionOne()) == null) {
                        return false;
                    }
                    if (!finFastCodeLineDO.getConditionThreeValue().equals("" + result.get(finFastCodeLineDO.getConditionThree()))) {
                        return false;
                    }
                }
                return true;
            }).findFirst().orElse(null);
            if (finFastCodeLineDOResult == null) {
                journalLogInfo.setErrMsg("\u5feb\u7801\u6761\u4ef6\u4e0d\u6ee1\u8db3");
                this.saveFinJournalLogNew(journalLogInfo);
                return false;
            }
            if (StringUtils.isBlank((CharSequence)finAccEngDetDataLineDO.getOutputColumn())) {
                journalLogInfo.setErrMsg("\u8f93\u51fa\u5b57\u6bb5\u672a\u914d\u7f6e");
                this.saveFinJournalLogNew(journalLogInfo);
                return false;
            }
            String outputValue = null;
            if ("ACC_ENG_FAST_CODE_OUTPUT_ONE".equals(finAccEngDetDataLineDO.getOutputColumn())) {
                outputValue = finFastCodeLineDOResult.getOutputOne();
            }
            if ("ACC_ENG_FAST_CODE_OUTPUT_TWO".equals(finAccEngDetDataLineDO.getOutputColumn())) {
                outputValue = finFastCodeLineDOResult.getOutputTwo();
            }
            if ("ACC_ENG_FAST_CODE_OUTPUT_THREE".equals(finAccEngDetDataLineDO.getOutputColumn())) {
                outputValue = finFastCodeLineDOResult.getOutputThree();
            }
            if (outputValue == null) {
                journalLogInfo.setErrMsg("\u8f93\u51fa\u5b57\u6bb5\u914d\u7f6e\u6709\u8bef");
                this.saveFinJournalLogNew(journalLogInfo);
                return false;
            }
            saveMap.put(finAccEngDetDataLineDO.getColumnName(), outputValue);
        }
        return true;
    }

    private boolean checkFlexible(FinAccEngDetDataLineDO finAccEngDetDataLineDO, FinAccountEngineConfigDTO finAccountEngineConfigDTO, String docNum, FinAccountEngineDTO finAccountEngineDO, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO, Map saveMap, JournalLogInfo journalLogInfo) {
        if (UdcEnum.SOURCE_TYPE_FLEXIBLE.getValueCode().equals(finAccEngDetDataLineDO.getSourceType())) {
            String columnName;
            Map<String, Map<String, FinFlexibleValueDO>> flexCodeValueMap = finAccountEngineConfigDTO.getFlexCodeValueMap();
            String sobCode = finAccEngDetDataDO.getSobCode();
            Map<String, FinSetOfBookLineDO> finSetOfBookLineDOMap = finAccountEngineConfigDTO.getSetOfBookLineMap().get(sobCode);
            FinSetOfBookLineDO finSetOfBookLineDO = finSetOfBookLineDOMap.get(columnName = finAccEngDetDataLineDO.getColumnName());
            if (finSetOfBookLineDO == null) {
                journalLogInfo.setErrMsg("\u672a\u67e5\u8be2\u5230\u8d26\u5957\u6838\u7b97\u7ef4\u5ea6\u6570\u636e");
                this.saveFinJournalLogNew(journalLogInfo);
                return false;
            }
            if (!Boolean.TRUE.equals(finSetOfBookLineDO.getFlexibleFlag())) {
                journalLogInfo.setErrMsg("\u8d26\u5957\u6838\u7b97\u7ef4\u5ea6\u4e0d\u652f\u6301\u503c\u96c6");
                this.saveFinJournalLogNew(journalLogInfo);
                return false;
            }
            String flexibleCode = finSetOfBookLineDO.getFlexibleCode();
            Map<String, FinFlexibleValueDO> flexibleValueDOMap = flexCodeValueMap.get(flexibleCode);
            FinFlexibleValueDO finFlexibleValueDO = flexibleValueDOMap.get(finAccEngDetDataLineDO.getFlexibleCode());
            if (finFlexibleValueDO == null) {
                journalLogInfo.setErrMsg("\u67e5\u4e0d\u5230\u6709\u6548\u7684\u503c\u96c6\u660e\u7ec6");
                this.saveFinJournalLogNew(journalLogInfo);
                return false;
            }
            this.put(saveMap, finAccEngDetDataLineDO.getColumnName(), finFlexibleValueDO.getFlexibleValueCode(), finAccEngDetDataLineDO);
        }
        return true;
    }

    private boolean checkAccountPeriod(FinAccEngDetDataLineDO finAccEngDetDataLineDO, Map result, FinAccountEngineConfigDTO finAccountEngineConfigDTO, String ouCode, String docNum, FinAccountEngineDTO finAccountEngineDO, FinAccountEngineDetailsDO finAccountEngineDetailsDO, FinAccEngDetDataDO finAccEngDetDataDO, Map saveMap, JournalLogInfo journalLogInfo) {
        if (UdcEnum.SOURCE_TYPE_ACCOUNT_PERIOD.getValueCode().equals(finAccEngDetDataLineDO.getSourceType())) {
            if (!result.containsKey(finAccEngDetDataLineDO.getColumnSource())) {
                journalLogInfo.setErrMsg("\u4f1a\u8ba1\u671f\u95f4\u5b57\u6bb5\u5217\u6765\u6e90\u672a\u914d\u7f6e");
                this.saveFinJournalLogNew(journalLogInfo);
                return false;
            }
            if (result.get(finAccEngDetDataLineDO.getColumnSource()) == null) {
                journalLogInfo.setErrMsg("\u4f1a\u8ba1\u671f\u95f4\u5b57\u6bb5\u5217\u503c\u4e3a\u7a7a");
                this.saveFinJournalLogNew(journalLogInfo);
                return false;
            }
            Object detDate = result.get(finAccEngDetDataLineDO.getColumnSource());
            LocalDateTime localDateTime = detDate instanceof Timestamp ? ((Timestamp)detDate).toLocalDateTime() : (LocalDateTime)result.get(finAccEngDetDataLineDO.getColumnSource());
            String sobCode = finAccEngDetDataDO.getSobCode();
            FinSetOfBookDO finSetOfBookDOResult = finAccountEngineConfigDTO.getFinSetOfBookDOList().stream().filter(finSetOfBookDO -> finSetOfBookDO.getSobCode().equals(sobCode)).findFirst().orElse(null);
            if (finSetOfBookDOResult == null) {
                journalLogInfo.setErrMsg("\u67e5\u4e0d\u5230\u542f\u7528\u72b6\u6001\u7684\u8d26\u5957");
                this.saveFinJournalLogNew(journalLogInfo);
                return false;
            }
            FinSobAccountPeriodDO finSobAccountPeriodDOResult = finAccountEngineConfigDTO.getFinSobAccountPeriodDOList().stream().filter(finSobAccountPeriodDO -> finSetOfBookDOResult.getSobCode().equals(finSobAccountPeriodDO.getSobCode()) && this.checkFinSobAccountPeriodOu(ouCode, (FinSobAccountPeriodDO)finSobAccountPeriodDO) != false && UdcEnum.ACCOUNT_PERIOD_CONTROL_STATUS_OPEN.getValueCode().equals(finSobAccountPeriodDO.getStatus()) && localDateTime.compareTo(finSobAccountPeriodDO.getActiveStartTime()) >= 0 && localDateTime.compareTo(finSobAccountPeriodDO.getActiveEndTime()) <= 0).findFirst().orElse(null);
            if (finSobAccountPeriodDOResult == null) {
                journalLogInfo.setErrMsg("\u672a\u67e5\u8be2\u5230\u4f1a\u8ba1\u671f\u95f4");
                this.saveFinJournalLogNew(journalLogInfo);
                return false;
            }
            this.put(saveMap, finAccEngDetDataLineDO.getColumnName(), finSobAccountPeriodDOResult.getPeriodStyle(), finAccEngDetDataLineDO);
        }
        return true;
    }

    private Boolean checkFinSobAccountPeriodOu(String ouCode, FinSobAccountPeriodDO finSobAccountPeriodDO) {
        if (ouCode.equals(finSobAccountPeriodDO.getOuCode()) || Objects.equals(ouCode, String.valueOf(finSobAccountPeriodDO.getOuId()))) {
            return true;
        }
        return false;
    }

    private boolean checkDebtAndCreditSumEqual(List<Map> dataList, JournalLogInfo journalLogInfo) {
        if (CollectionUtils.isEmpty(dataList)) {
            return true;
        }
        BigDecimal debit_amt = BigDecimal.ZERO;
        BigDecimal credit_amt = BigDecimal.ZERO;
        BigDecimal debit_cur_amt = BigDecimal.ZERO;
        BigDecimal credit_cur_amt = BigDecimal.ZERO;
        for (Map data : dataList) {
            if (data.get("debit_amt") == null || data.get("credit_amt") == null || data.get("debit_cur_amt") == null || data.get("credit_cur_amt") == null) {
                journalLogInfo.setErrMsg("\u6821\u9a8c\u501f\u65b9\u3001\u8d37\u65b9\u91d1\u989d\u662f\u5426\u76f8\u7b49\u5931\u8d25\uff0c\u5b58\u5728\u503c\u4e3a\u7a7a\u7684\u91d1\u989d\u5b57\u6bb5");
                this.saveFinJournalLogNew(journalLogInfo);
                return false;
            }
            debit_amt = debit_amt.add((BigDecimal)data.get("debit_amt"));
            credit_amt = credit_amt.add((BigDecimal)data.get("credit_amt"));
            debit_cur_amt = debit_cur_amt.add((BigDecimal)data.get("debit_cur_amt"));
            credit_cur_amt = credit_cur_amt.add((BigDecimal)data.get("credit_cur_amt"));
        }
        if (debit_amt.compareTo(credit_amt) != 0 || debit_cur_amt.compareTo(credit_cur_amt) != 0) {
            journalLogInfo.setErrMsg("\u6821\u9a8c\u501f\u65b9\u3001\u8d37\u65b9\u91d1\u989d\u662f\u5426\u76f8\u7b49\u5931\u8d25\uff0c\u501f\u65b9\u548c\u8d37\u65b9\u91d1\u989d\u4e0d\u76f8\u7b49");
            this.saveFinJournalLogNew(journalLogInfo);
            return false;
        }
        return true;
    }

    private void saveFinJournal(FinAccountEngineDO finAccountEngineDO, FinEventTableDO finEventTableDO, Connection connection, List<Map> saveMapList, Set<Long> proposingDocIds, Set<Long> successProposingDocIds, boolean manualFlag) {
        if (CollectionUtils.isEmpty(saveMapList)) {
            return;
        }
        Assert.notNull((Object)finAccountEngineDO, (String)"\u67e5\u4e0d\u5230\u4f1a\u8ba1\u5f15\u64ce", (Object[])new Object[0]);
        try {
            SysUserDTO sysUserDTO;
            GeneralUserDetails principal;
            long tenantId = -1L;
            if (this.tenantClientProvider.getSessionTenant() != null) {
                tenantId = this.tenantClientProvider.getSessionTenant().getId();
            }
            long finalTenantId = tenantId;
            String creator = "\u7cfb\u7edf\u81ea\u52a8";
            if (manualFlag && (principal = (GeneralUserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()) != null && (sysUserDTO = principal.getUser()) != null) {
                creator = sysUserDTO.getLastName();
            }
            String finalCreator = creator;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (CollectionUtils.isNotEmpty(saveMapList)) {
                saveMapList.stream().forEach(v -> v.put("tenant_id", finalTenantId));
                saveMapList.stream().forEach(v -> v.put("create_user_id", -1));
                saveMapList.stream().forEach(v -> v.put("create_time", LocalDateTime.now()));
                saveMapList.stream().forEach(v -> v.put("creator", finalCreator));
            }
            Map<Object, List<Map>> detDataIdMap = saveMapList.stream().collect(Collectors.groupingBy(v -> v.get("detDataId")));
            for (Object key : detDataIdMap.keySet()) {
                List<Map> maps = detDataIdMap.get(key);
                maps.stream().forEach(v -> {
                    v.remove("detDataId");
                    successProposingDocIds.add((Long)v.get("main_id"));
                    v.remove("main_id");
                });
                this.finAccountEngineJdbcService.finJournalBatchSave(finAccountEngineDO, connection, maps);
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u4f1a\u8ba1\u51ed\u8bc1\u5931\u8d25,\u4e8b\u4ef6\u8868\u5355:{},\u4f1a\u8ba1\u5f15\u64ceID:{}", new Object[]{finEventTableDO.getEventTable(), finAccountEngineDO.getId(), e});
            throw new BusinessException("\u4fdd\u5b58\u4f1a\u8ba1\u51ed\u8bc1\u5931\u8d25\uff0c" + e.getMessage());
        }
    }

    private void put(Map map, String key, Object value, FinAccEngDetDataLineDO finAccEngDetDataLineDO) {
        if (StringUtils.isBlank((CharSequence)finAccEngDetDataLineDO.getColumnType())) {
            map.put(key, "" + value);
        } else if (finAccEngDetDataLineDO.getColumnType().trim().equals("varchar")) {
            map.put(key, "" + value);
        } else if (finAccEngDetDataLineDO.getColumnType().trim().equals("decimal")) {
            if (value instanceof BigDecimal) {
                map.put(key, value);
            } else if (value instanceof Float) {
                if (Objects.isNull(value)) {
                    map.put(key, BigDecimal.ZERO);
                } else {
                    map.put(key, BigDecimal.valueOf(Float.valueOf(value.toString()).floatValue()));
                }
            } else if (Objects.isNull(value)) {
                map.put(key, BigDecimal.ZERO);
            } else {
                map.put(key, BigDecimal.valueOf(Double.valueOf((String)value)));
            }
        } else if (finAccEngDetDataLineDO.getColumnType().trim().equals("datetime")) {
            map.put(key, value);
        } else if (finAccEngDetDataLineDO.getColumnType().trim().equals("bigint")) {
            map.put(key, value);
        } else if (finAccEngDetDataLineDO.getColumnType().trim().equals("int")) {
            map.put(key, value);
        }
    }

    public JournalGenerateServiceImpl(FinAccountEngineRepo finAccountEngineRepo, FinAccountEngineRepoProc finAccountEngineRepoProc, FinAccountEngineDetailsRepo finAccountEngineDetailsRepo, FinAccEngDetConditionRepo finAccEngDetConditionRepo, FinAccEngDetDataRepo finAccEngDetDataRepo, FinAccEngDetDataLineRepo finAccEngDetDataLineRepo, FinEventTableRepo finEventTableRepo, FinEventTableLineRepo finEventTableLineRepo, FinEventTableConditionRepo finEventTableConditionRepo, FinJournalLogRepo finJournalLogRepo, FinSetOfBookOuRepo finSetOfBookOuRepo, FinSetOfBookRepo finSetOfBookRepo, FinSetOfBookLineRepo finSetOfBookLineRepo, FinFastCodeLineRepoProc finFastCodeLineRepoProc, FinFastCodeRepoProc finFastCodeRepoProc, FinFlexibleRepoProc finFlexibleRepoProc, FinFlexibleValueRepoProc finFlexibleValueRepoProc, FinSobAccountPeriodRepo finSobAccountPeriodRepo, TenantClientProvider tenantClientProvider, FinAccountEngineJdbcService finAccountEngineJdbcService) {
        this.finAccountEngineRepo = finAccountEngineRepo;
        this.finAccountEngineRepoProc = finAccountEngineRepoProc;
        this.finAccountEngineDetailsRepo = finAccountEngineDetailsRepo;
        this.finAccEngDetConditionRepo = finAccEngDetConditionRepo;
        this.finAccEngDetDataRepo = finAccEngDetDataRepo;
        this.finAccEngDetDataLineRepo = finAccEngDetDataLineRepo;
        this.finEventTableRepo = finEventTableRepo;
        this.finEventTableLineRepo = finEventTableLineRepo;
        this.finEventTableConditionRepo = finEventTableConditionRepo;
        this.finJournalLogRepo = finJournalLogRepo;
        this.finSetOfBookOuRepo = finSetOfBookOuRepo;
        this.finSetOfBookRepo = finSetOfBookRepo;
        this.finSetOfBookLineRepo = finSetOfBookLineRepo;
        this.finFastCodeLineRepoProc = finFastCodeLineRepoProc;
        this.finFastCodeRepoProc = finFastCodeRepoProc;
        this.finFlexibleRepoProc = finFlexibleRepoProc;
        this.finFlexibleValueRepoProc = finFlexibleValueRepoProc;
        this.finSobAccountPeriodRepo = finSobAccountPeriodRepo;
        this.tenantClientProvider = tenantClientProvider;
        this.finAccountEngineJdbcService = finAccountEngineJdbcService;
    }

    static class JournalLogInfo {
        private Long docId;
        private Long detailDocId;
        private String docNum;
        private String ouCode;
        private String eventTable;
        private Long accountEngineId;
        private String accountEngine;
        private String detDataName;
        private String columnName;
        private String errMsg;
        private Boolean manualFlag;

        public JournalLogInfo(String eventTable, Long accountEngineId) {
            this.eventTable = eventTable;
            this.accountEngineId = accountEngineId;
        }

        public JournalLogInfo(String docNum, String eventTable, String accountEngine) {
            this.docNum = docNum;
            this.eventTable = eventTable;
            this.accountEngine = accountEngine;
        }

        public Long getDocId() {
            return this.docId;
        }

        public Long getDetailDocId() {
            return this.detailDocId;
        }

        public String getDocNum() {
            return this.docNum;
        }

        public String getOuCode() {
            return this.ouCode;
        }

        public String getEventTable() {
            return this.eventTable;
        }

        public Long getAccountEngineId() {
            return this.accountEngineId;
        }

        public String getAccountEngine() {
            return this.accountEngine;
        }

        public String getDetDataName() {
            return this.detDataName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getErrMsg() {
            return this.errMsg;
        }

        public Boolean getManualFlag() {
            return this.manualFlag;
        }

        public void setDocId(Long docId) {
            this.docId = docId;
        }

        public void setDetailDocId(Long detailDocId) {
            this.detailDocId = detailDocId;
        }

        public void setDocNum(String docNum) {
            this.docNum = docNum;
        }

        public void setOuCode(String ouCode) {
            this.ouCode = ouCode;
        }

        public void setEventTable(String eventTable) {
            this.eventTable = eventTable;
        }

        public void setAccountEngineId(Long accountEngineId) {
            this.accountEngineId = accountEngineId;
        }

        public void setAccountEngine(String accountEngine) {
            this.accountEngine = accountEngine;
        }

        public void setDetDataName(String detDataName) {
            this.detDataName = detDataName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public void setErrMsg(String errMsg) {
            this.errMsg = errMsg;
        }

        public void setManualFlag(Boolean manualFlag) {
            this.manualFlag = manualFlag;
        }
    }
}

