/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.fin.application.service.invoice.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.fin.application.facade.vo.invoice.InvoiceAwaitRespVO;
import com.elitesland.fin.application.service.invoice.impl.AbstractInvoiceSaveServiceImpl;
import com.elitesland.fin.common.PaymentRecordTypeEnum;
import com.elitesland.fin.common.UdcEnum;
import com.elitesland.fin.rpc.order.RmiOrderRpcService;
import com.elitesland.order.param.SalReconciliatInvDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SalReconciliationInvoiceServiceImpl
extends AbstractInvoiceSaveServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(SalReconciliationInvoiceServiceImpl.class);
    @Autowired
    private RmiOrderRpcService rmiOrderRpcService;

    @Override
    protected PaymentRecordTypeEnum getSourceType() {
        return PaymentRecordTypeEnum.SACCK;
    }

    @Override
    protected void callBackMethod(List<InvoiceAwaitRespVO> records) {
        this.updateInvingState(records);
    }

    private void updateInvingState(List<InvoiceAwaitRespVO> records) {
        ArrayList<SalReconciliatInvDTO> salInvDtoList = new ArrayList<SalReconciliatInvDTO>();
        Set optDocIds = records.stream().map(InvoiceAwaitRespVO::getOptDocId).filter(Objects::nonNull).collect(Collectors.toSet());
        Optional<String> optional = records.stream().map(InvoiceAwaitRespVO::getInvoiceApplyNo).filter(Objects::nonNull).findFirst();
        String applyNo = optional.get();
        for (Long optDocId : optDocIds) {
            SalReconciliatInvDTO invDTO = new SalReconciliatInvDTO();
            invDTO.setInvState(UdcEnum.INV_STATE_ING.getValueCode());
            invDTO.setId(optDocId);
            invDTO.setInvApplyNo(applyNo);
            salInvDtoList.add(invDTO);
        }
        try {
            Long result = this.rmiOrderRpcService.updateInvingState(salInvDtoList);
            log.info("\u56de\u5199\u5bf9\u8d26\u5355\u53d1\u7968\u4fe1\u606f: \u53c2\u6570: {},  \u8fd4\u56de\u503c: {}", salInvDtoList, (Object)result);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5bf9\u8d26\u5355\u53d1\u7968\u72b6\u6001\u5931\u8d25: \u53c2\u6570: {} \u5931\u8d25\u539f\u56e0: {}", salInvDtoList, (Object)e.getMessage());
            throw new BusinessException("\u66f4\u65b0\u5bf9\u8d26\u5355\u53d1\u7968\u72b6\u6001\u5931\u8d25\uff0c" + e.getMessage());
        }
    }
}

