package com.elitesland.fin.application.facade.vo.accountingengine;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.fin.application.facade.base.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;

/**
 * @author gyj
 * @date 2023/10/10
 */
@Data
@ApiModel(description = "会计引擎条件")
public class FinAccEngDetConditionVO extends BaseModelVO {

    @ApiModelProperty("主表id")
    private Long masId;

    @ApiModelProperty("序列号")
    private Integer serialNum;

    @ApiModelProperty("表单名称")
    private String tableName;

    @ApiModelProperty("字段名称")
    private String columnName;

    @ApiModelProperty("条件")
    @SysCode(sys = "yst-fin", mod = "EVENT_TABLE_CONDITION")
    private String conditionType;
    private String conditionTypeName;

    @ApiModelProperty("从值内容")
    private String valueFrom;

    @ApiModelProperty("至值内容")
    private String valueTo;
}
